/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.codegen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.maven.codegen.NewProfilePanel;
import org.netbeans.modules.maven.model.pom.Activation;
import org.netbeans.modules.maven.model.pom.ActivationFile;
import org.netbeans.modules.maven.model.pom.ActivationOS;
import org.netbeans.modules.maven.model.pom.ActivationProperty;
import org.netbeans.modules.maven.model.pom.BuildBase;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.DependencyManagement;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.maven.model.pom.PluginManagement;
import org.netbeans.modules.maven.model.pom.Profile;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.w3c.dom.Node;

public class ProfileGenerator
implements CodeGenerator {
    private POMModel model;
    private JTextComponent component;

    private ProfileGenerator(POMModel pOMModel, JTextComponent jTextComponent) {
        this.model = pOMModel;
        this.component = jTextComponent;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(ProfileGenerator.class, (String)"NAME_Profile");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() {
        try {
            this.model.sync();
        }
        catch (IOException iOException) {
            Logger.getLogger(ProfileGenerator.class.getName()).log(Level.INFO, "Error while syncing the editor document with model for pom.xml file", iOException);
        }
        if (!this.model.getState().equals((Object)Model.State.VALID)) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ProfileGenerator.class, (String)"MSG_Cannot_Parse"));
            return;
        }
        NewProfilePanel newProfilePanel = new NewProfilePanel(this.model);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)newProfilePanel, NbBundle.getMessage(ProfileGenerator.class, (String)"TIT_Add_profile"));
        newProfilePanel.attachDialogDisplayer(dialogDescriptor);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (object == DialogDescriptor.OK_OPTION) {
            String string = newProfilePanel.getProfileId();
            Profile profile = this.model.getProject().findProfileById(string);
            boolean bl = "pom".equals(this.model.getProject().getPackaging());
            if (profile == null) {
                try {
                    Plugin plugin;
                    Dependency dependency;
                    this.model.startTransaction();
                    profile = this.model.getFactory().createProfile();
                    profile.setId(string);
                    if (newProfilePanel.generateDependencies()) {
                        dependency = this.model.getFactory().createDependency();
                        dependency.setGroupId("foo");
                        dependency.setArtifactId("bar");
                        dependency.setVersion("1.0");
                        if (bl) {
                            plugin = this.model.getFactory().createDependencyManagement();
                            profile.setDependencyManagement((DependencyManagement)plugin);
                            plugin.addDependency(dependency);
                        } else {
                            profile.addDependency(dependency);
                        }
                    }
                    if (newProfilePanel.generatePlugins()) {
                        dependency = this.model.getFactory().createBuildBase();
                        profile.setBuildBase((BuildBase)dependency);
                        plugin = this.model.getFactory().createPlugin();
                        plugin.setGroupId("foo");
                        plugin.setArtifactId("bar");
                        plugin.setVersion("1.0");
                        if (bl) {
                            PluginManagement pluginManagement = this.model.getFactory().createPluginManagement();
                            dependency.setPluginManagement(pluginManagement);
                            pluginManagement.addPlugin(plugin);
                        } else {
                            dependency.addPlugin(plugin);
                        }
                    }
                    if (newProfilePanel.isActivation()) {
                        dependency = this.model.getFactory().createActivation();
                        profile.setActivation((Activation)dependency);
                        if (newProfilePanel.isActiovationByProperty()) {
                            plugin = this.model.getFactory().createActivationProperty();
                            dependency.setActivationProperty((ActivationProperty)plugin);
                            plugin.setName("foo");
                            plugin.setValue("bar");
                        }
                        if (newProfilePanel.isActiovationByFile()) {
                            plugin = this.model.getFactory().createActivationFile();
                            dependency.setActivationFile((ActivationFile)plugin);
                            plugin.setExists("${basedir}/foo.bar");
                        }
                        if (newProfilePanel.isActiovationByOS()) {
                            plugin = this.model.getFactory().createActivationOS();
                            if (Utilities.isMac()) {
                                plugin.setFamily("MacOS");
                            } else if (Utilities.isUnix()) {
                                plugin.setFamily("Linux");
                            } else {
                                plugin.setFamily("Windows");
                            }
                            dependency.setActivationOS((ActivationOS)plugin);
                        }
                    }
                    this.model.getProject().addProfile(profile);
                }
                finally {
                    this.model.endTransaction();
                }
                int n = profile.getModel().getAccess().findPosition((Node)profile.getPeer());
                this.component.setCaretPosition(n);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup lookup) {
            ArrayList<ProfileGenerator> arrayList = new ArrayList<ProfileGenerator>();
            POMModel pOMModel = (POMModel)lookup.lookup(POMModel.class);
            JTextComponent jTextComponent = (JTextComponent)lookup.lookup(JTextComponent.class);
            if (pOMModel != null) {
                arrayList.add(new ProfileGenerator(pOMModel, jTextComponent));
            }
            return arrayList;
        }
    }
}

