/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.format.checkstyle;

import hidden.org.codehaus.plexus.util.IOUtil;
import hidden.org.codehaus.plexus.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.openide.util.Exceptions;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleConvertor {
    private static String PROP_SPACE_BEFORE_DO_LEFT = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceBeforeDoLeftBrace";
    private static String PROP_SPACE_BEFORE_STATIC_INIT_LEFT = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceBeforeStaticInitLeftBrace";
    private static String PROP_SPACE_BEFORE_IF_PAREN = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceBeforeIfParen";
    private static String PROP_SPACE_BEFORE_TRY_LEFT = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceBeforeTryLeftBrace";
    private static String PROP_SPACE_BEFORE_ANN_PAREN = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceBeforeAnnotationParen";
    private static String PROP_SPACE_BEFORE_SYNC_PAREN = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceBeforeSynchronizedParen";
    private static String PROP_SPACE_BEFORE_ARR_INIT_LEFT = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceBeforeArrayInitLeftBrace";
    private static String PROP_SPACE_BEFORE_METHOD_DECL_PAREN = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceBeforeMethodDeclParen";
    private static String PROP_SPACE_WITHIN_ARR_BRACKETS = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceWithinArrayInitBrackets";
    private static String PROP_SPACE_BEFORE_SYNC_LEFT = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceBeforeSynchronizedLeftBrace";
    private static String PROP_SPACE_BEFORE_FINALLY = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceBeforeFinally";
    private static String PROP_SPACE_BEFORE_METHOD_DECL_LEFT = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceBeforeMethodDeclLeftBrace";
    private static String PROP_SPACE_WITHIN_BRACES = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceWithinBraces";
    private static String PROP_SPACE_BEFORE_FINALLY_LEFT = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceBeforeFinallyLeftBrace";
    private static String PROP_SPACE_BEFORE_METHOD_CALL_PAREN = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceBeforeMethodCallParen";
    private static String PROP_SPACE_BEFORE_IF_LEFT = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceBeforeIfLeftBrace";
    private static String PROP_SPACE_BEFORE_ELSE_LEFT = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceBeforeElseLeftBrace";
    private static String PROP_SPACE_BEFORE_SWITCH_PAREN = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceBeforeSwitchParen";
    private static String PROP_SPACE_BEFORE_WHILE = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceBeforeWhile";
    private static String PROP_SPACE_BEFORE_CLASS_DECL_LEFT = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceBeforeClassDeclLeftBrace";
    private static String PROP_SPACE_BEFORE_CATCH_LEFT = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceBeforeCatchLeftBrace";
    private static String PROP_SPACE_BEFORE_CATCH_PAREN = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceBeforeCatchParen";
    private static String PROP_SPACE_BEFORE_SWITCH_LEFT = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceBeforeSwitchLeftBrace";
    private static String PROP_SPACE_BEFORE_CATCH = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceBeforeCatch";
    private static String PROP_SPACE_BEFORE_ELSE = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceBeforeElse";
    private static String PROP_NEWLINE_MODIFIERS = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.placeNewLineAfterModifiers";
    private static String PROP_NEWLINE_WHILE = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.placeWhileOnNewLine";
    private static String PROP_BRACE_CLASS = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.classDeclBracePlacement";
    private static String PROP_BRACE_METHOD = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.methodDeclBracePlacement";
    private static String PROP_BRACE_OTHER = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.otherBracePlacement";
    private static String PROP_BRACE_ELSEIF_HANDLING = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.specialElseIf";
    private static String PROP_NEWLINE_ELSE = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.placeElseOnNewLine";
    private static String PROP_NEWLINE_FINALLY = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.placeFinallyOnNewLine";
    private static String PROP_NEWLINE_CATCH = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.placeCatchOnNewLine";
    private static String PROP_SPACE_WITHIN_CATCH_PAREN = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceWithinCatchParens";
    private static String PROP_SPACE_WITHIN_IF_PAREN = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceWithinIfParens";
    private static String PROP_SPACE_WITHIN_METHOD_CALL_PAREN = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceWithinMethodCallParens";
    private static String PROP_SPACE_WITHIN_SYNC_PAREN = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceWithinSynchronizedParens";
    private static String PROP_SPACE_WITHIN_FOR_PAREN = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceWithinForParens";
    private static String PROP_SPACE_WITHIN_SWITCH_PAREN = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceWithinSwitchParens";
    private static String PROP_SPACE_WITHIN_WHILE_PAREN = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceWithinWhileParens";
    private static String PROP_SPACE_WITHIN_CAST_PAREN = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceWithinTypeCastParens";
    private static String PROP_SPACE_WITHIN_ANN_PAREN = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceWithinAnnotationParens";
    private static String PROP_SPACE_WITHIN_METHOD_DECL_PAREN = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceWithinMethodDeclParens";
    private static String PROP_SPACE_AROUND_BINARY_OPS = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceAroundBinaryOps";
    private static String PROP_SPACE_AROUND_TERNARY_OPS = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceAroundTernaryOps";
    private static String PROP_SPACE_AROUND_ASSIGN_OPS = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceAroundAssignOps";
    private static String PROP_SPACE_AROUND_UNARY_OPS = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceAroundUnaryOps";
    private static String PROP_SPACE_BEFORE_FOR_PAREN = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceBeforeForParen";
    private static String PROP_SPACE_BEFORE_FOR_LEFT = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceBeforeForLeftBrace";
    private static String PROP_SPACE_BEFORE_WHILE_PAREN = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceBeforeWhileParen";
    private static String PROP_SPACE_BEFORE_WHILE_LEFT = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceBeforeWhileLeftBrace";
    private static String PROP_SPACE_WITHIN_PAREN = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceWithinParens";
    private static String PROP_SPACE_AFTER_SEMI = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceAfterSemi";
    private static String PROP_SPACE_AFTER_CAST = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceAfterTypeCast";
    private static String PROP_SPACE_AFTER_COMMA = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceAfterComma";
    private static String PROP_SPACE_AFTER_COLON = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.spaceAfterColon";
    private static String PROP_EXPAND_TABS = "org-netbeans-modules-editor-indent.CodeStyle.project.expand-tabs";
    private static String PROP_LINE_MAX = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.text-limit-width";
    private static String PROP_GENERATE_BRACE_DO = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.redundantDoWhileBraces";
    private static String PROP_GENERATE_BRACE_FOR = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.redundantForBraces";
    private static String PROP_GENERATE_BRACE_IF = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.redundantIfBraces";
    private static String PROP_GENERATE_BRACE_WHILE = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.redundantWhileBraces";
    private static String PROP_TABSIZE = "org-netbeans-modules-editor-indent.text.x-java.CodeStyle.project.tab-size";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties convert(InputStream inputStream) {
        Properties properties = new Properties();
        SAXBuilder sAXBuilder = new SAXBuilder();
        sAXBuilder.setValidation(false);
        sAXBuilder.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
                return null;
            }
        });
        try {
            Document document = sAXBuilder.build(inputStream);
            Element element = document.getRootElement();
            this.processModule(element, "", properties);
            if (properties.size() > 0) {
                properties.put("org-netbeans-modules-editor-indent.CodeStyle.usedProfile", "project");
            }
        }
        catch (JDOMException jDOMException) {
            Exceptions.printStackTrace((Throwable)jDOMException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        finally {
            IOUtil.close((InputStream)inputStream);
        }
        return properties;
    }

    private void checkRules(String string, Map<String, String> map, Properties properties) {
        if ("/Checker/TreeWalker".equals(string)) {
            this.processTreeWalker(map, properties);
        } else if ("/Checker/TreeWalker/LeftCurly".equals(string)) {
            this.processLeftBrace(map, properties);
        } else if ("/Checker/TreeWalker/RightCurly".equals(string)) {
            this.processRightBrace(map, properties);
        } else if ("/Checker/TreeWalker/LineLength".equals(string)) {
            this.processLineLength(map, properties);
        } else if ("/Checker/TreeWalker/NeedBraces".equals(string)) {
            this.processNeedBraces(map, properties);
        } else if ("/Checker/TreeWalker/WhitespaceAfter".equals(string)) {
            this.processWhiteSpaceAfter(map, properties);
        } else if ("/Checker/TreeWalker/WhitespaceAround".equals(string)) {
            this.processWhiteSpaceAround(map, properties);
        } else if ("/Checker/TreeWalker/ParenPad".equals(string)) {
            this.processParenPad(map, properties);
        } else if ("/Checker/TreeWalker/TabCharacter".equals(string)) {
            this.processTabCharacter(map, properties);
        }
    }

    private void processLeftBrace(Map<String, String> map, Properties properties) {
        String string = this.getPropertyValue(map, "option", "eol");
        List<Token> list = this.getApplicableTokens(map, "tokens");
        String string2 = "nl".equals(string) ? BracePlacement.NEW_LINE.name() : BracePlacement.SAME_LINE.name();
        int n = 0;
        if (list.contains((Object)Token.CLASS_DEF)) {
            properties.setProperty(PROP_BRACE_CLASS, string2);
            ++n;
        }
        if (list.contains((Object)Token.METHOD_DEF)) {
            properties.setProperty(PROP_BRACE_METHOD, string2);
            ++n;
        }
        if (list.size() > n) {
            properties.setProperty(PROP_BRACE_OTHER, string2);
        }
    }

    private void processRightBrace(Map<String, String> map, Properties properties) {
        String string;
        String string2 = this.getPropertyValue(map, "option", "same");
        List<Token> list = this.getApplicableTokens(map, "tokens");
        String string3 = string = "alone".equals(string2) ? "true" : "false";
        if (list.contains((Object)Token.LITERAL_ELSE)) {
            properties.setProperty(PROP_NEWLINE_ELSE, string);
        }
        if (list.contains((Object)Token.LITERAL_CATCH)) {
            properties.setProperty(PROP_NEWLINE_CATCH, "true");
        }
        if (list.contains((Object)Token.LITERAL_FINALLY)) {
            properties.setProperty(PROP_NEWLINE_FINALLY, "true");
        }
    }

    private void processParenPad(Map<String, String> map, Properties properties) {
        String string = this.getPropertyValue(map, "option", "nospace");
        String string2 = "space".equals(string) ? "true" : "false";
        List<Token> list = this.getApplicableTokens(map, "tokens");
        if (list.contains((Object)Token.METHOD_CALL)) {
            properties.setProperty(PROP_SPACE_WITHIN_METHOD_CALL_PAREN, string2);
        }
        if (list.contains((Object)Token.LPAREN) || list.contains((Object)Token.RPAREN)) {
            properties.setProperty(PROP_SPACE_WITHIN_ANN_PAREN, string2);
            properties.setProperty(PROP_SPACE_WITHIN_CAST_PAREN, string2);
            properties.setProperty(PROP_SPACE_WITHIN_CATCH_PAREN, string2);
            properties.setProperty(PROP_SPACE_WITHIN_FOR_PAREN, string2);
            properties.setProperty(PROP_SPACE_WITHIN_IF_PAREN, string2);
            properties.setProperty(PROP_SPACE_WITHIN_METHOD_DECL_PAREN, string2);
            properties.setProperty(PROP_SPACE_WITHIN_SWITCH_PAREN, string2);
            properties.setProperty(PROP_SPACE_WITHIN_SYNC_PAREN, string2);
            properties.setProperty(PROP_SPACE_WITHIN_WHILE_PAREN, string2);
        }
    }

    private void processWhiteSpaceAround(Map<String, String> map, Properties properties) {
        List<Token> list = this.getApplicableTokens(map, "tokens");
        properties.setProperty(PROP_SPACE_AROUND_ASSIGN_OPS, new Boolean(list.contains((Object)Token.ASSIGN) || list.contains((Object)Token.BAND_ASSIGN) || list.contains((Object)Token.BOR_ASSIGN) || list.contains((Object)Token.BXOR_ASSIGN) || list.contains((Object)Token.BSR_ASSIGN) || list.contains((Object)Token.DIV_ASSIGN) || list.contains((Object)Token.MINUS_ASSIGN) || list.contains((Object)Token.SR_ASSIGN) || list.contains((Object)Token.MINUS_ASSIGN) || list.contains((Object)Token.PLUS_ASSIGN) || list.contains((Object)Token.STAR_ASSIGN)).toString());
        properties.setProperty(PROP_SPACE_AROUND_BINARY_OPS, new Boolean(list.contains((Object)Token.AND) || list.contains((Object)Token.BOR) || list.contains((Object)Token.BSR) || list.contains((Object)Token.BXOR) || list.contains((Object)Token.DIV) || list.contains((Object)Token.EQUAL) || list.contains((Object)Token.NOT_EQUAL) || list.contains((Object)Token.GE) || list.contains((Object)Token.GT) || list.contains((Object)Token.LE) || list.contains((Object)Token.LT) || list.contains((Object)Token.LAND) || list.contains((Object)Token.LOR) || list.contains((Object)Token.MINUS) || list.contains((Object)Token.MOD) || list.contains((Object)Token.PLUS) || list.contains((Object)Token.SL) || list.contains((Object)Token.SR)).toString());
        properties.setProperty(PROP_SPACE_AROUND_TERNARY_OPS, new Boolean(list.contains((Object)Token.QUESTION)).toString());
        properties.setProperty(PROP_SPACE_BEFORE_FOR_LEFT, new Boolean(list.contains((Object)Token.LITERAL_FOR)).toString());
        properties.setProperty(PROP_SPACE_BEFORE_FOR_PAREN, new Boolean(list.contains((Object)Token.LITERAL_FOR)).toString());
        properties.setProperty(PROP_SPACE_BEFORE_WHILE_LEFT, new Boolean(list.contains((Object)Token.LITERAL_WHILE)).toString());
        properties.setProperty(PROP_SPACE_WITHIN_PAREN, new Boolean(list.contains((Object)Token.LPAREN) || list.contains((Object)Token.RPAREN)).toString());
    }

    private void processWhiteSpaceAfter(Map<String, String> map, Properties properties) {
        List<Token> list = this.getApplicableTokens(map, "tokens");
        properties.setProperty(PROP_SPACE_AFTER_COMMA, new Boolean(list.contains((Object)Token.COMMA)).toString());
        properties.setProperty(PROP_SPACE_AFTER_CAST, new Boolean(list.contains((Object)Token.TYPECAST)).toString());
        properties.setProperty(PROP_SPACE_AFTER_SEMI, new Boolean(list.contains((Object)Token.SEMI)).toString());
    }

    private void processTabCharacter(Map<String, String> map, Properties properties) {
        properties.setProperty(PROP_EXPAND_TABS, Boolean.TRUE.toString());
    }

    private void processLineLength(Map<String, String> map, Properties properties) {
        String string = this.getPropertyValue(map, "max", "80");
        properties.setProperty(PROP_LINE_MAX, string);
    }

    private void processNeedBraces(Map<String, String> map, Properties properties) {
        List<Token> list = this.getApplicableTokens(map, "tokens");
        properties.setProperty(PROP_GENERATE_BRACE_DO, list.contains((Object)Token.LITERAL_DO) ? BracesGenerationStyle.GENERATE.name() : BracesGenerationStyle.LEAVE_ALONE.name());
        properties.setProperty(PROP_GENERATE_BRACE_FOR, list.contains((Object)Token.LITERAL_FOR) ? BracesGenerationStyle.GENERATE.name() : BracesGenerationStyle.LEAVE_ALONE.name());
        properties.setProperty(PROP_GENERATE_BRACE_IF, list.contains((Object)Token.LITERAL_IF) || list.contains((Object)Token.LITERAL_ELSE) ? BracesGenerationStyle.GENERATE.name() : BracesGenerationStyle.LEAVE_ALONE.name());
        properties.setProperty(PROP_GENERATE_BRACE_WHILE, list.contains((Object)Token.LITERAL_WHILE) ? BracesGenerationStyle.GENERATE.name() : BracesGenerationStyle.LEAVE_ALONE.name());
    }

    private void processTreeWalker(Map<String, String> map, Properties properties) {
        String string = this.getPropertyValue(map, "tabWidth", "8");
        properties.setProperty(PROP_TABSIZE, string);
    }

    private List<Token> getApplicableTokens(Map<String, String> map, String string) {
        String string2 = map.get(string);
        if (string2 == null) {
            return Arrays.asList(Token.values());
        }
        String[] stringArray = StringUtils.split((String)string2, (String)",");
        ArrayList<Token> arrayList = new ArrayList<Token>();
        for (String string3 : stringArray) {
            try {
                arrayList.add(Token.valueOf(string3.trim()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
        }
        return arrayList;
    }

    private String getPropertyValue(Map<String, String> map, String string, String string2) {
        String string3 = map.get(string);
        string3 = string3 != null ? string3 : string2;
        return string3;
    }

    private void processModule(Element element, String string, Properties properties) {
        String string2;
        Object object;
        Object object22;
        if (!"module".equals(element.getName())) {
            return;
        }
        String string3 = element.getAttributeValue("name");
        List list = element.getChildren("property");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Object object22 : list) {
            object = object22.getAttributeValue("name");
            string2 = object22.getAttributeValue("value");
            assert (object != null && string2 != null);
            hashMap.put((String)object, string2);
        }
        String string4 = string + "/" + string3;
        this.checkRules(string4, hashMap, properties);
        object22 = element.getChildren("module");
        object = object22.iterator();
        while (object.hasNext()) {
            string2 = (Element)object.next();
            this.processModule((Element)string2, string4, properties);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WrapStyle {
        WRAP_ALWAYS,
        WRAP_IF_LONG,
        WRAP_NEVER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BracesGenerationStyle {
        GENERATE,
        LEAVE_ALONE,
        ELIMINATE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BracePlacement {
        SAME_LINE,
        NEW_LINE,
        NEW_LINE_HALF_INDENTED,
        NEW_LINE_INDENTED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Token {
        CLASS_DEF,
        CTOR_DEF,
        INTERFACE_DEF,
        LITERAL_CATCH,
        LITERAL_DO,
        LITERAL_ELSE,
        LITERAL_FINALLY,
        LITERAL_FOR,
        LITERAL_IF,
        LITERAL_SWITCH,
        LITERAL_SYNCHRONIZED,
        LITERAL_TRY,
        LITERAL_WHILE,
        METHOD_DEF,
        COMMA,
        TYPECAST,
        SEMI,
        ASSIGN,
        BAND,
        BAND_ASSIGN,
        BOR,
        BOR_ASSIGN,
        BSR,
        BSR_ASSIGN,
        BXOR,
        BXOR_ASSIGN,
        COLON,
        DIV,
        DIV_ASSIGN,
        EQUAL,
        GE,
        GT,
        LAND,
        LCURLY,
        LE,
        LITERAL_ASSERT,
        LITERAL_RETURN,
        LOR,
        LT,
        MINUS,
        MINUS_ASSIGN,
        MOD,
        MOD_ASSIGN,
        NOT_EQUAL,
        PLUS,
        PLUS_ASSIGN,
        QUESTION,
        RCURLY,
        SL,
        SLIST,
        SL_ASSIGN,
        SR,
        SR_ASSIGN,
        STAR,
        STAR_ASSIGN,
        GENERIC_START,
        GENERIC_END,
        AND,
        TYPE_EXTENSION_AND,
        WILDCARD_TYPE,
        METHOD_CALL,
        LPAREN,
        RPAREN;

    }
}

