/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.navigator;

import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.model.Model;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.build.model.ModelLineage;
import org.apache.maven.project.build.model.ModelLineageIterator;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.navigator.ROUtil;
import org.openide.actions.EditAction;
import org.openide.cookies.EditCookie;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class POMInheritancePanel
extends JPanel
implements ExplorerManager.Provider,
Runnable {
    private transient ExplorerManager explorerManager = new ExplorerManager();
    private BeanTreeView treeView;
    private DataObject current;
    private FileChangeAdapter adapter = new FileChangeAdapter(){

        public void fileChanged(FileEvent fileEvent) {
            POMInheritancePanel.this.showWaitNode();
            RequestProcessor.getDefault().post((Runnable)POMInheritancePanel.this);
        }
    };
    private JScrollPane jScrollPane1;

    public POMInheritancePanel() {
        this.initComponents();
        this.treeView = (BeanTreeView)this.jScrollPane1;
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    void navigate(DataObject dataObject) {
        if (this.current != null) {
            this.current.getPrimaryFile().removeFileChangeListener((FileChangeListener)this.adapter);
        }
        this.current = dataObject;
        this.current.getPrimaryFile().addFileChangeListener((FileChangeListener)this.adapter);
        this.showWaitNode();
        RequestProcessor.getDefault().post((Runnable)this);
    }

    public void run() {
        if (this.current != null && "text/x-maven-pom+xml".equals(this.current.getPrimaryFile().getMIMEType())) {
            File file = FileUtil.toFile((FileObject)this.current.getPrimaryFile());
            if (file != null) {
                try {
                    ModelLineage modelLineage = EmbedderFactory.createModelLineage((File)file, (MavenEmbedder)EmbedderFactory.getOnlineEmbedder(), (boolean)false);
                    PomChildren pomChildren = new PomChildren(modelLineage);
                    SwingUtilities.invokeLater(new Runnable((Children)pomChildren){
                        final /* synthetic */ Children val$ch;
                        {
                            this.val$ch = children;
                        }

                        public void run() {
                            POMInheritancePanel.this.treeView.setRootVisible(false);
                            POMInheritancePanel.this.explorerManager.setRootContext((Node)new AbstractNode(this.val$ch));
                        }
                    });
                }
                catch (ProjectBuildingException projectBuildingException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Error reading model lineage", projectBuildingException);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            POMInheritancePanel.this.treeView.setRootVisible(true);
                            POMInheritancePanel.this.explorerManager.setRootContext(POMInheritancePanel.createErrorNode());
                        }
                    });
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        POMInheritancePanel.this.treeView.setRootVisible(false);
                        POMInheritancePanel.this.explorerManager.setRootContext(POMInheritancePanel.createEmptyNode());
                    }
                });
            }
        }
    }

    void release() {
        if (this.current != null) {
            this.current.getPrimaryFile().removeFileChangeListener((FileChangeListener)this.adapter);
        }
        this.current = null;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                POMInheritancePanel.this.treeView.setRootVisible(false);
                POMInheritancePanel.this.explorerManager.setRootContext(POMInheritancePanel.createEmptyNode());
            }
        });
    }

    public void showWaitNode() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                POMInheritancePanel.this.treeView.setRootVisible(true);
                POMInheritancePanel.this.explorerManager.setRootContext(POMInheritancePanel.createWaitNode());
            }
        });
    }

    private void initComponents() {
        this.jScrollPane1 = new BeanTreeView();
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 292, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 307, Short.MAX_VALUE));
    }

    private static Node createWaitNode() {
        AbstractNode abstractNode = new AbstractNode(Children.LEAF);
        abstractNode.setIconBaseWithExtension("org/netbeans/modules/maven/navigator/wait.gif");
        abstractNode.setDisplayName(NbBundle.getMessage(POMInheritancePanel.class, (String)"LBL_Wait"));
        return abstractNode;
    }

    private static Node createEmptyNode() {
        AbstractNode abstractNode = new AbstractNode(Children.LEAF);
        return abstractNode;
    }

    private static Node createErrorNode() {
        AbstractNode abstractNode = new AbstractNode(Children.LEAF);
        abstractNode.setDisplayName(NbBundle.getMessage(POMInheritancePanel.class, (String)"LBL_Error"));
        return abstractNode;
    }

    private static class POMNode
    extends AbstractNode {
        private Image icon = ImageUtilities.loadImage((String)"org/netbeans/modules/maven/navigator/Maven2Icon.gif");
        private boolean readonly = false;

        private POMNode(File file, Model model, Lookup lookup, String string) {
            super(Children.LEAF, lookup);
            String string2 = model.getVersion();
            if (string2 == null) {
                string2 = string;
            }
            this.setDisplayName(NbBundle.getMessage(POMInheritancePanel.class, (String)"TITLE_PomNode", (Object)model.getArtifactId(), (Object)string2));
            if (file.getName().endsWith("pom")) {
                this.readonly = true;
            }
            this.setShortDescription(file.getAbsolutePath());
        }

        public Action[] getActions(boolean bl) {
            return new Action[]{new MyEditAction()};
        }

        public Action getPreferredAction() {
            return EditAction.get(EditAction.class);
        }

        public String getHtmlDisplayName() {
            if (this.readonly) {
                return NbBundle.getMessage(POMInheritancePanel.class, (String)"HTML_TITLE_PomNode", (Object)this.getDisplayName());
            }
            return null;
        }

        public Image getIcon(int n) {
            return this.icon;
        }

        public Image getOpenedIcon(int n) {
            return this.getIcon(n);
        }

        private class MyEditAction
        extends AbstractAction {
            public MyEditAction() {
                this.putValue("Name", NbBundle.getMessage(POMInheritancePanel.class, (String)"ACTION_Edit"));
                this.setEnabled(true);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                EditCookie editCookie = (EditCookie)POMNode.this.getLookup().lookup(EditCookie.class);
                if (editCookie != null) {
                    editCookie.edit();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PomChildren
    extends Children.Keys<ModelLineage> {
        public PomChildren(ModelLineage modelLineage) {
            this.setKeys(new ModelLineage[]{modelLineage});
        }

        protected Node[] createNodes(ModelLineage modelLineage) {
            ModelLineageIterator modelLineageIterator = modelLineage.reversedLineageIterator();
            ArrayList<POMNode> arrayList = new ArrayList<POMNode>();
            String string = null;
            while (modelLineageIterator.hasNext()) {
                modelLineageIterator.next();
                Model model = modelLineageIterator.getModel();
                File file = FileUtil.normalizeFile((File)modelLineageIterator.getPOMFile());
                FileObject fileObject = FileUtil.toFileObject((File)file);
                InstanceContent instanceContent = new InstanceContent();
                if (fileObject != null) {
                    try {
                        DataObject dataObject = DataObject.find((FileObject)ROUtil.checkPOMFileObjectReadOnly(fileObject, file));
                        if (dataObject != null) {
                            instanceContent.add((Object)dataObject);
                            EditCookie editCookie = (EditCookie)dataObject.getLookup().lookup(EditCookie.class);
                            if (editCookie != null) {
                                instanceContent.add((Object)editCookie);
                            }
                        }
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                    }
                }
                arrayList.add(0, new POMNode(file, model, (Lookup)new AbstractLookup((AbstractLookup.Content)instanceContent), string));
                if (model.getVersion() == null) continue;
                string = model.getVersion();
            }
            return arrayList.toArray(new Node[0]);
        }
    }
}

