/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.nio.cs.ThreadLocalCoders;

public class BufferedCharSequence
implements CharSequence {
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.search.BufferedCharSequence");
    public static final int K = 1024;
    public static final int MAX_FILE_SIZE = Integer.MAX_VALUE;
    private static final int MAX_SOURCE_BUFFER_SIZE = 4096;
    public static final int MAX_SUBSEQUENCE_LENGTH = 4096;
    private static final int MIN_SINK_BUFFER_SIZE = 16;
    private Source source;
    private Sink sink;
    private final CharsetDecoder decoder;
    private CoderResult coderResult;
    private boolean isClosed = false;
    private int position = 0;

    public BufferedCharSequence(FileInputStream fileInputStream, Charset charset) {
        this(fileInputStream.getChannel(), charset);
    }

    public BufferedCharSequence(FileChannel fileChannel, Charset charset) {
        this(fileChannel, ThreadLocalCoders.decoderFor(charset.name()).onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE));
    }

    public BufferedCharSequence(FileChannel fileChannel, CharsetDecoder charsetDecoder) {
        this.source = new Source(fileChannel);
        this.decoder = charsetDecoder;
        this.sink = new Sink(this.source);
        LOG.info("<init> " + this.source + "; decoder = " + this.decoder + "; " + this.sink);
    }

    private BufferedCharSequence(BufferedCharSequence bufferedCharSequence) {
        this.source = bufferedCharSequence.source;
        this.sink = bufferedCharSequence.sink;
        this.decoder = bufferedCharSequence.decoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public int getMaxBufferSize() {
        return this.source.maxBufferSize;
    }

    public void setMaxBufferSize(int n) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.source.maxBufferSize = n;
    }

    public BufferedCharSequence reset() throws SourceIOException {
        this.source.reset();
        this.sink.reset();
        this.decoder.reset();
        this.coderResult = CoderResult.UNDERFLOW;
        return this;
    }

    public BufferedCharSequence close() throws IOException {
        this.reset();
        this.source.close();
        this.source = null;
        this.sink = null;
        this.coderResult = null;
        this.isClosed = true;
        return this;
    }

    public BufferedCharSequence duplicate() {
        this.checkState();
        return new BufferedCharSequence(this);
    }

    public int length() {
        this.checkState();
        this.reset();
        int n = 0;
        while (this.sink.next()) {
        }
        n = this.sink.buffer.scope.end;
        return n;
    }

    public char charAt(int n) throws IndexOutOfBoundsException {
        this.checkState();
        String string = this.check(n);
        if (string != null) {
            throw new IndexOutOfBoundsException(string);
        }
        return this.getCharAt(n);
    }

    public CharSequence subSequence(int n, int n2) throws IndexOutOfBoundsException {
        this.checkState();
        String string = this.check(n, n2);
        if (string != null) {
            throw new IndexOutOfBoundsException(string);
        }
        int n3 = this.getLength(n, n2);
        if (n3 > 4096) {
            throw new IndexOutOfBoundsException("requested subSequence has a big length (" + n3 + ") > " + 4096);
        }
        CharSequence charSequence = this.getSubSequence(n, n2);
        return charSequence;
    }

    public String toString() {
        this.checkState();
        return ((Object)this.subSequence(0, this.length())).toString();
    }

    public final int position() {
        this.checkState();
        return this.position;
    }

    public final int changePosition(int n) {
        int n2 = this.position;
        this.position = n;
        return n2;
    }

    public char nextChar() throws IndexOutOfBoundsException {
        this.checkState();
        return this.charAt(this.position++);
    }

    public final BufferedCharSequence rewind() {
        this.checkState();
        this.position = 0;
        return this;
    }

    public String nextLineText() {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            while (true) {
                char c = this.nextChar();
                switch (c) {
                    case '\n': 
                    case '\f': 
                    case '\u0085': 
                    case '\u2028': 
                    case '\u2029': {
                        return stringBuilder.toString();
                    }
                    case '\r': {
                        if (this.charAt(this.position) == '\n') {
                            this.nextChar();
                        }
                        return stringBuilder.toString();
                    }
                }
                stringBuilder.append(c);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return stringBuilder.toString();
        }
    }

    public String getLineText(int n) {
        int n2 = this.changePosition(n);
        String string = this.nextLineText();
        this.changePosition(n2);
        return string;
    }

    private char getCharAt(int n) throws IndexOutOfBoundsException {
        if (this.sink.buffer.scope.isBefore(n)) {
            this.reset();
        }
        while (!this.sink.buffer.scope.isInside(n)) {
            boolean bl = this.sink.next();
            if (bl) continue;
            throw new IndexOutOfBoundsException("index is " + n + " > lenght");
        }
        return this.sink.charAt(n);
    }

    private CharSequence getSubSequence(int n, int n2) throws IndexOutOfBoundsException {
        StringBuilder stringBuilder = new StringBuilder(this.getLength(n, n2));
        for (int i = n; i < n2; ++i) {
            stringBuilder.append(this.charAt(i));
        }
        return stringBuilder.toString();
    }

    private int getLength(int n, int n2) {
        return n2 - n;
    }

    private void checkState() {
        if (this.isClosed) {
            String string = "BufferedCharSequence is closed";
            throw new IllegalStateException(string);
        }
    }

    private String check(int n) {
        if (n < 0) {
            return "index = " + n;
        }
        return null;
    }

    private String check(int n, int n2) {
        if (n < 0 || n2 < 0 || n > n2) {
            return "start = " + n + ", end = " + n2;
        }
        return null;
    }

    public static class SourceIOException
    extends RuntimeException {
        public SourceIOException(IOException iOException) {
            super(iOException);
        }
    }

    private class Sink {
        private Buffer buffer;

        public Sink(Source source) {
            int n = source.getCapacity();
            this.buffer = this.newBuffer(n);
        }

        public String toString() {
            return "sink = [" + this.buffer + "]";
        }

        public void reset() {
            this.buffer.reset();
        }

        public char charAt(int n) throws IndexOutOfBoundsException {
            assert (n >= 0);
            return this.buffer.getCharAt(n);
        }

        private boolean next() {
            CharBuffer charBuffer = this.buffer.clear();
            boolean bl = false;
            if (BufferedCharSequence.this.coderResult == CoderResult.UNDERFLOW) {
                bl = BufferedCharSequence.this.source.readNext();
            }
            while ((BufferedCharSequence.this.coderResult = BufferedCharSequence.this.decoder.decode(BufferedCharSequence.this.source.buffer, charBuffer, bl)) != CoderResult.UNDERFLOW) {
                charBuffer = this.buffer.growBuffer();
            }
            if (bl) {
                while ((BufferedCharSequence.this.coderResult = BufferedCharSequence.this.decoder.flush(charBuffer)) != CoderResult.UNDERFLOW) {
                    charBuffer = this.buffer.growBuffer();
                }
            }
            this.buffer.adjustScope();
            return !this.buffer.scope.isEmpty();
        }

        private Buffer newBuffer(int n) {
            return new Buffer(n);
        }

        private class Buffer {
            private CharBuffer charBuffer;
            private Scope scope = new Scope();

            public Buffer(int n) {
                this.allocate(n);
                this.reset();
            }

            public String toString() {
                return "buffer[capacity = " + this.charBuffer.capacity() + "]";
            }

            public CharBuffer growBuffer() {
                int n = this.charBuffer.capacity();
                CharBuffer charBuffer = CharBuffer.allocate(n << 1);
                this.charBuffer.flip();
                charBuffer.put(this.charBuffer);
                this.charBuffer = charBuffer;
                LOG.info("The sink char buffer capacity has been grown: " + n + " -> " + this.charBuffer.capacity());
                return this.charBuffer;
            }

            private void allocate(int n) {
                if (n == 0) {
                    this.charBuffer = CharBuffer.allocate(0);
                    return;
                }
                int n2 = this.bufferSize(n);
                this.charBuffer = CharBuffer.allocate(n2);
            }

            private int bufferSize(int n) {
                int n2 = (int)((float)n * BufferedCharSequence.this.decoder.averageCharsPerByte());
                return n2 < 16 ? 16 : n2;
            }

            private char getCharAt(int n) {
                int n2 = this.charBuffer.position();
                this.charBuffer.position(0);
                char c = this.charBuffer.charAt(n - this.scope.start);
                this.charBuffer.position(n2);
                return c;
            }

            private void reset() {
                this.scope.reset();
                this.charBuffer.clear();
            }

            private void flip() {
                this.charBuffer.flip();
            }

            private CharBuffer clear() {
                this.charBuffer.clear();
                return this.charBuffer;
            }

            private void adjustScope() {
                this.scope.start = this.scope.end == -1 ? 0 : this.scope.end;
                this.flip();
                this.scope.end = this.scope.start + this.charBuffer.limit();
            }

            private class Scope {
                public static final int EOF = -1;
                private int start;
                private int end;

                private Scope() {
                }

                public boolean isInside(int n) {
                    return n >= this.start && n < this.end;
                }

                public boolean isBefore(int n) {
                    return this.start == -1 || n < this.start;
                }

                public void reset() {
                    this.end = -1;
                    this.start = -1;
                }

                private boolean isEmpty() {
                    return this.start == this.end;
                }
            }
        }
    }

    private class Source {
        private int maxBufferSize = 4096;
        private ByteBuffer buffer;
        private FileChannel channel;

        public Source(FileChannel fileChannel) {
            this.channel = fileChannel;
            this.buffer = this.newBuffer();
        }

        public String toString() {
            return "source=[channel = " + this.channel + ", buffer = " + this.buffer + "]";
        }

        private ByteBuffer newBuffer() {
            return ByteBuffer.allocate(this.getBufferSize());
        }

        public void reset() {
            try {
                this.channel.position(0L);
            }
            catch (IOException iOException) {
                throw new SourceIOException(iOException);
            }
            this.buffer.clear();
        }

        private int read() {
            try {
                return this.channel.read(this.buffer);
            }
            catch (IOException iOException) {
                throw new SourceIOException(iOException);
            }
        }

        public int position() throws IOException {
            return (int)this.channel.position();
        }

        public void close() throws IOException {
            this.channel.close();
        }

        public int size() {
            try {
                return this.getSize(this.channel.size());
            }
            catch (IOException iOException) {
                throw new SourceIOException(iOException);
            }
        }

        private int getSize(long l) {
            if (l > Integer.MAX_VALUE) {
                LOG.log(Level.WARNING, "File size is " + l + "bytes. " + "Only first " + Integer.MAX_VALUE + " bytes will be processed.");
                return Integer.MAX_VALUE;
            }
            return (int)l;
        }

        private int getBufferSize() {
            int n = Math.min(this.size(), this.maxBufferSize);
            return n;
        }

        public boolean readNext() {
            this.buffer.clear();
            int n = this.read();
            this.buffer.flip();
            return n == -1;
        }

        private int getCapacity() {
            return this.buffer.capacity();
        }
    }

    static interface UnicodeLineTerminator {
        public static final char LF = '\n';
        public static final char CR = '\r';
        public static final char LS = '\u2028';
        public static final char PS = '\u2029';
        public static final char NEL = '\u0085';
        public static final char FF = '\f';
    }
}

