/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner;

import java.util.Arrays;
import java.util.List;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.Manager;
import org.netbeans.modules.gsf.testrunner.api.OutputLineHandler;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.rubyproject.rake.RakeTask;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.testrunner.RubyOutputLineHandler;
import org.netbeans.modules.ruby.testrunner.TestExecutionManager;
import org.netbeans.modules.ruby.testrunner.ui.TestRunnerInputProcessorFactory;
import org.netbeans.modules.ruby.testrunner.ui.TestRunnerLineConvertor;

public final class TestRunnerUtilities {
    private static final String TEST_JAVAC_CLASSPATH = "test.javac.classpath";
    private static final String TEST_JVM_ARGS = "test.jvm.args";
    private static final List<String> NB_RUNNER_FILES = Arrays.asList("nb_test_mediator.rb", "nb_test_runner.rb", "nb_suite_runner.rb", "nb_rspec_mediator.rb", "nb_autotest_loader.rb");

    private TestRunnerUtilities() {
    }

    static boolean useTestRunner(Project project, String string, RakeTask rakeTask, DefaultTaskEvaluator defaultTaskEvaluator) {
        PropertyEvaluator propertyEvaluator = (PropertyEvaluator)project.getLookup().lookup(PropertyEvaluator.class);
        if (propertyEvaluator == null || propertyEvaluator.getProperty(string) == null) {
            return defaultTaskEvaluator.isDefault(rakeTask);
        }
        String string2 = propertyEvaluator.getProperty(string);
        if ("".equals(string2.trim())) {
            return false;
        }
        for (String string3 : string2.split(",")) {
            if (!rakeTask.getTask().equals(string3.trim())) continue;
            return true;
        }
        return false;
    }

    static void addProperties(RubyExecutionDescriptor rubyExecutionDescriptor, Project project) {
        PropertyEvaluator propertyEvaluator = (PropertyEvaluator)project.getLookup().lookup(PropertyEvaluator.class);
        if (propertyEvaluator == null) {
            return;
        }
        rubyExecutionDescriptor.addInitialArgs(propertyEvaluator.getProperty("ruby.options"));
        rubyExecutionDescriptor.setEncoding(propertyEvaluator.getProperty("source.encoding"));
        String string = propertyEvaluator.getProperty(TEST_JAVAC_CLASSPATH);
        if (string == null) {
            string = propertyEvaluator.getProperty("javac.classpath");
        }
        rubyExecutionDescriptor.classPath(string);
        String string2 = propertyEvaluator.getProperty(TEST_JVM_ARGS);
        if (string2 == null) {
            string2 = propertyEvaluator.getProperty("jvm.args");
        }
        rubyExecutionDescriptor.jvmArguments(string2);
    }

    public static boolean filterOutFromStacktrace(String string) {
        for (String string2 : NB_RUNNER_FILES) {
            if (!string.contains(string2)) continue;
            return true;
        }
        return false;
    }

    static void setUpConvertors(TestSession testSession, RubyExecutionDescriptor rubyExecutionDescriptor, Manager manager, final TestRunnerLineConvertor testRunnerLineConvertor) {
        testSession.setOutputLineHandler((OutputLineHandler)new RubyOutputLineHandler(testSession.getFileLocator()));
        rubyExecutionDescriptor.addOutConvertor((LineConvertor)testRunnerLineConvertor);
        rubyExecutionDescriptor.addErrConvertor((LineConvertor)testRunnerLineConvertor);
        rubyExecutionDescriptor.lineBased(true);
        final TestRunnerInputProcessorFactory testRunnerInputProcessorFactory = new TestRunnerInputProcessorFactory(manager, testSession, true);
        final TestRunnerInputProcessorFactory testRunnerInputProcessorFactory2 = new TestRunnerInputProcessorFactory(manager, testSession, false);
        rubyExecutionDescriptor.setOutProcessorFactory((ExecutionDescriptor.InputProcessorFactory)testRunnerInputProcessorFactory);
        rubyExecutionDescriptor.setErrProcessorFactory((ExecutionDescriptor.InputProcessorFactory)testRunnerInputProcessorFactory2);
        rubyExecutionDescriptor.postBuild(new Runnable(){

            public void run() {
                TestExecutionManager.getInstance().finish();
                testRunnerLineConvertor.refreshSession();
                TestSession testSession = testRunnerLineConvertor.refreshSession();
                testRunnerInputProcessorFactory.refreshSession(testSession);
                testRunnerInputProcessorFactory2.refreshSession(testSession);
            }
        });
    }

    static interface DefaultTaskEvaluator {
        public boolean isDefault(RakeTask var1);
    }
}

