/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.reglib;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.netbeans.modules.reglib.StatusDocument;

public class StatusData {
    public static final String STATUS_UNKNOWN = "unknown";
    public static final String STATUS_REGISTERED = "registered";
    public static final String STATUS_LATER = "later";
    public static final String STATUS_NEVER = "never";
    public static final int DEFAULT_DELAY = 7;
    private String status;
    private Date timestamp;
    private int delay;

    public StatusData(String string, int n) {
        this.status = string;
        this.timestamp = new Date();
        this.delay = n;
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public String getStatus() {
        return this.status;
    }

    public void setTimestamp(Date date) {
        this.timestamp = date;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setDelay(int n) {
        this.delay = n;
    }

    public int getDelay() {
        return this.delay;
    }

    public static StatusData loadFromXML(InputStream inputStream) throws IOException {
        return StatusDocument.load(inputStream);
    }

    public void storeToXML(OutputStream outputStream) throws IOException {
        StatusDocument.store(outputStream, this);
    }

    public byte[] toXML() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.storeToXML(byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            return new byte[0];
        }
    }

    public String toString() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.storeToXML(byteArrayOutputStream);
            return byteArrayOutputStream.toString("UTF-8");
        }
        catch (IOException iOException) {
            return "Error creating the return string.";
        }
    }
}

