/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.dtrace.collector.support;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.acl.NotOwnerException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.execution.AttachableTarget;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.DLightTargetChangeEvent;
import org.netbeans.modules.dlight.api.execution.Validateable;
import org.netbeans.modules.dlight.api.execution.ValidationListener;
import org.netbeans.modules.dlight.api.execution.ValidationStatus;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.core.stack.storage.StackDataStorage;
import org.netbeans.modules.dlight.dtrace.collector.DTDCConfiguration;
import org.netbeans.modules.dlight.dtrace.collector.DtraceParser;
import org.netbeans.modules.dlight.dtrace.collector.impl.DTDCConfigurationAccessor;
import org.netbeans.modules.dlight.dtrace.collector.support.DTraceScriptUtils;
import org.netbeans.modules.dlight.dtrace.collector.support.DtraceDataAndStackParser;
import org.netbeans.modules.dlight.extras.api.support.CollectorRunner;
import org.netbeans.modules.dlight.management.api.DLightManager;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.netbeans.modules.dlight.spi.indicator.IndicatorNotificationsListener;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.support.DataStorageTypeFactory;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.dlight.util.Util;
import org.netbeans.modules.dlight.util.usagetracking.SunStudioUserCounter;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.AsynchronousAction;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.SolarisPrivilegesSupportProvider;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DtraceDataCollector
extends IndicatorDataProvider<DTDCConfiguration>
implements DataCollector<DTDCConfiguration> {
    private static final List<String> ultimateDTracePrivilegesList = Arrays.asList("dtrace_kernel", "dtrace_proc", "dtrace_user");
    private static final String cmd_dtrace = "/usr/sbin/dtrace";
    private static final Logger log = DLightLogger.getLogger(DtraceDataCollector.class);
    private Set<String> requiredPrivilegesSet;
    private DataTableMetadata tableMetaData = null;
    private URL localScriptUrl;
    private String extraArgs;
    private String scriptPath;
    private CollectorRunner dtraceRunner = null;
    private DTDCConfiguration configuration;
    private ValidationStatus validationStatus = ValidationStatus.initialStatus();
    private List<ValidationListener> validationListeners = Collections.synchronizedList(new ArrayList());
    private String command;
    private String argsTemplate;
    private DataStorage storage;
    private List<DataTableMetadata> dataTablesMetadata;
    private DtraceParser parser;
    private final List<DataRow> indicatorDataBuffer = new ArrayList<DataRow>();
    private int indicatorFiringFactor;
    private LineProcessor outputProcessor = new DefaultLineProcessor();
    private boolean isSlave;
    private final boolean multiScriptMode;
    private DtraceDataCollector parentCollector;
    private final Map<String, DtraceDataCollector> slaveCollectors;
    private DtraceDataCollector lastSlaveCollector;

    DtraceDataCollector(boolean bl, DTDCConfiguration dTDCConfiguration) {
        this.multiScriptMode = bl;
        this.command = cmd_dtrace;
        this.argsTemplate = null;
        DTDCConfigurationAccessor dTDCConfigurationAccessor = DTDCConfigurationAccessor.getDefault();
        if (bl) {
            this.dataTablesMetadata = new ArrayList<DataTableMetadata>();
            this.tableMetaData = null;
            this.slaveCollectors = new HashMap<String, DtraceDataCollector>();
            this.requiredPrivilegesSet = new HashSet<String>();
            this.setOutputProcessor(new DemultiplexingLineProcessor());
            this.addSlaveConfiguration(dTDCConfiguration);
        } else {
            this.dataTablesMetadata = dTDCConfigurationAccessor.getDatatableMetadata(dTDCConfiguration);
            this.slaveCollectors = Collections.emptyMap();
            DataTableMetadata dataTableMetadata = this.tableMetaData = this.dataTablesMetadata != null && this.dataTablesMetadata.size() > 0 ? this.dataTablesMetadata.get(0) : null;
            this.parser = dTDCConfigurationAccessor.isStackSupportEnabled(dTDCConfiguration) ? new DtraceDataAndStackParser(this.tableMetaData) : (dTDCConfigurationAccessor.getParser(dTDCConfiguration) == null ? (this.tableMetaData != null ? new DtraceParser(this.tableMetaData) : (DtraceParser)null) : dTDCConfigurationAccessor.getParser(dTDCConfiguration));
            this.localScriptUrl = dTDCConfigurationAccessor.getScriptUrl(dTDCConfiguration);
            this.extraArgs = dTDCConfigurationAccessor.getArgs(dTDCConfiguration);
            this.requiredPrivilegesSet = new HashSet<String>(dTDCConfigurationAccessor.getRequiredPrivileges(dTDCConfiguration) == null ? ultimateDTracePrivilegesList : dTDCConfigurationAccessor.getRequiredPrivileges(dTDCConfiguration));
            this.configuration = dTDCConfiguration;
            this.indicatorFiringFactor = dTDCConfigurationAccessor.getIndicatorFiringFactor(dTDCConfiguration);
        }
    }

    void addSlaveConfiguration(DTDCConfiguration dTDCConfiguration) {
        DtraceDataCollector dtraceDataCollector2;
        if (!this.multiScriptMode) {
            throw new IllegalStateException("addSlaveConfiguration called in single-script mode");
        }
        for (DtraceDataCollector dtraceDataCollector2 : this.slaveCollectors.values()) {
            if (dtraceDataCollector2.configuration != dTDCConfiguration) continue;
            return;
        }
        DTDCConfigurationAccessor dTDCConfigurationAccessor = DTDCConfigurationAccessor.getDefault();
        dtraceDataCollector2 = new DtraceDataCollector(false, dTDCConfiguration);
        dtraceDataCollector2.setSlave(true);
        dtraceDataCollector2.setParentCollector(this);
        this.slaveCollectors.put(dTDCConfigurationAccessor.getOutputPrefix(dTDCConfiguration), dtraceDataCollector2);
        this.requiredPrivilegesSet.addAll(dTDCConfigurationAccessor.getRequiredPrivileges(dTDCConfiguration) == null ? ultimateDTracePrivilegesList : dTDCConfigurationAccessor.getRequiredPrivileges(dTDCConfiguration));
    }

    void setParentCollector(DtraceDataCollector dtraceDataCollector) {
        this.parentCollector = dtraceDataCollector;
    }

    public String getName() {
        return "DTrace";
    }

    void setOutputProcessor(LineProcessor lineProcessor) {
        this.outputProcessor = lineProcessor;
    }

    void setSlave(boolean bl) {
        this.isSlave = bl;
    }

    URL getLocalScriptUrl() {
        return this.localScriptUrl;
    }

    void setLocalScriptUrl(URL uRL) {
        this.localScriptUrl = uRL;
    }

    LineProcessor getOutputProcessor() {
        return this.outputProcessor;
    }

    protected DataStorage getStorage() {
        return this.storage;
    }

    public Collection<DataStorageType> getRequiredDataStorageTypes() {
        DataStorageTypeFactory dataStorageTypeFactory = DataStorageTypeFactory.getInstance();
        DataStorageType dataStorageType = dataStorageTypeFactory.getDataStorageType("db:sql");
        DataStorageType dataStorageType2 = dataStorageTypeFactory.getDataStorageType("stack");
        return Arrays.asList(dataStorageType, dataStorageType2);
    }

    public boolean isAttachable() {
        return true;
    }

    public void init(Map<DataStorageType, DataStorage> map, DLightTarget dLightTarget) {
        File file;
        DtraceDataCollector dtraceDataCollector2;
        if (this.multiScriptMode) {
            for (DtraceDataCollector dtraceDataCollector2 : this.slaveCollectors.values()) {
                dtraceDataCollector2.init(map, dLightTarget);
            }
            try {
                this.setLocalScriptUrl(this.mergeScripts().toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        DataStorageTypeFactory dataStorageTypeFactory = DataStorageTypeFactory.getInstance();
        this.storage = map.get(dataStorageTypeFactory.getDataStorageType("db:sql"));
        dtraceDataCollector2 = (StackDataStorage)map.get(dataStorageTypeFactory.getDataStorageType("stack"));
        if (this.parser instanceof DtraceDataAndStackParser) {
            ((DtraceDataAndStackParser)this.parser).setStackDataStorage((StackDataStorage)dtraceDataCollector2);
        }
        if (this.isSlave) {
            return;
        }
        try {
            file = Util.copyToTempDir((URL)this.localScriptUrl);
            DTraceScriptUtils.insertEOFMarker(file);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            this.scriptPath = null;
            return;
        }
        ExecutionEnvironment executionEnvironment = dLightTarget.getExecEnv();
        if (executionEnvironment.isLocal()) {
            this.scriptPath = file.getAbsolutePath();
            Util.setExecutionPermissions(Arrays.asList(this.scriptPath));
        } else {
            String string = Util.getBriefName((URL)this.localScriptUrl);
            try {
                HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)executionEnvironment);
                this.scriptPath = hostInfo.getTempDir() + "/" + string;
                Future future = CommonTasksSupport.uploadFile((String)file.getAbsolutePath(), (ExecutionEnvironment)executionEnvironment, (String)this.scriptPath, (int)511, null);
                future.get();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            catch (CancellationException cancellationException) {
                Exceptions.printStackTrace((Throwable)cancellationException);
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
            catch (ExecutionException executionException) {
                Exceptions.printStackTrace((Throwable)executionException);
            }
        }
    }

    public String getCmd() {
        return this.command;
    }

    public String[] getArgs() {
        return null;
    }

    public List<DataTableMetadata> getDataTablesMetadata() {
        ArrayList<DataTableMetadata> arrayList = new ArrayList<DataTableMetadata>();
        arrayList.addAll(this.dataTablesMetadata);
        for (DtraceDataCollector dtraceDataCollector : this.slaveCollectors.values()) {
            arrayList.addAll(dtraceDataCollector.getDataTablesMetadata());
        }
        return arrayList;
    }

    protected String getCollectorTaskExtraParams() {
        return this.extraArgs;
    }

    void packageVisibleSuggestIndicatorsRepaint() {
        super.suggestIndicatorsRepaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void targetFinished(DLightTarget dLightTarget) {
        if (!this.isSlave && this.dtraceRunner != null) {
            log.fine("Stopping DtraceDataCollector: " + this.dtraceRunner.toString());
            this.dtraceRunner.shutdown();
        }
        List<DataRow> list = this.indicatorDataBuffer;
        synchronized (list) {
            if (!this.indicatorDataBuffer.isEmpty()) {
                if (this.isSlave) {
                    if (this.parentCollector != null) {
                        this.parentCollector.notifyIndicators(this.indicatorDataBuffer);
                    }
                } else {
                    this.notifyIndicators(this.indicatorDataBuffer);
                }
                this.indicatorDataBuffer.clear();
            }
        }
    }

    private static String loc(String string, String ... stringArray) {
        return NbBundle.getMessage(DtraceDataCollector.class, (String)string, (Object[])stringArray);
    }

    private ValidationStatus doValidation(DLightTarget dLightTarget) {
        Object object;
        ConnectionManager connectionManager;
        DLightLogger.assertNonUiThread();
        ExecutionEnvironment executionEnvironment = dLightTarget.getExecEnv();
        ValidationStatus validationStatus = null;
        boolean bl = false;
        boolean bl2 = true;
        String string = "";
        HostInfo hostInfo = null;
        try {
            hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)executionEnvironment);
        }
        catch (IOException iOException) {
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        if (hostInfo == null || hostInfo.getOSFamily() != HostInfo.OSFamily.SUNOS) {
            return ValidationStatus.invalidStatus((String)NbBundle.getMessage(DtraceDataCollector.class, (String)"DtraceDataCollector.DtraceIsSupportedOnSunOSOnly"));
        }
        try {
            bl = HostInfoUtils.fileExists((ExecutionEnvironment)executionEnvironment, (String)this.command);
        }
        catch (IOException iOException) {
            string = iOException.getMessage();
            bl2 = false;
        }
        if (bl2) {
            validationStatus = bl ? ValidationStatus.validStatus() : ValidationStatus.invalidStatus((String)DtraceDataCollector.loc("ValidationStatus.CommandNotFound", this.command));
        } else {
            connectionManager = ConnectionManager.getInstance();
            Runnable runnable = new Runnable(){

                public void run() {
                    DLightManager.getDefault().revalidateSessions();
                }
            };
            object = connectionManager.getConnectToAction(executionEnvironment, runnable);
            validationStatus = ValidationStatus.unknownStatus((String)DtraceDataCollector.loc("ValidationStatus.ErrorWhileValidation", string), (AsynchronousAction)object);
        }
        if (!validationStatus.isValid()) {
            return validationStatus;
        }
        connectionManager = SolarisPrivilegesSupportProvider.getSupportFor((ExecutionEnvironment)executionEnvironment);
        if (connectionManager == null) {
            return ValidationStatus.invalidStatus((String)NbBundle.getMessage(DtraceDataCollector.class, (String)"DtraceDataCollector.NoPrivSupport", (Object)executionEnvironment.toString()));
        }
        boolean bl3 = connectionManager.hasPrivileges(this.requiredPrivilegesSet);
        if (!bl3) {
            try {
                connectionManager.requestPrivileges(this.requiredPrivilegesSet, false);
                bl3 = true;
            }
            catch (NotOwnerException notOwnerException) {
                // empty catch block
            }
        }
        if (!bl3) {
            object = new Runnable(){

                public void run() {
                    DLightManager.getDefault().revalidateSessions();
                }
            };
            AsynchronousAction asynchronousAction = connectionManager.getRequestPrivilegesAction(this.requiredPrivilegesSet, (Runnable)object);
            validationStatus = validationStatus.merge(ValidationStatus.unknownStatus((String)DtraceDataCollector.loc("DTraceDataCollector_Status_NotEnoughPrivileges", new String[0]), (AsynchronousAction)asynchronousAction));
        }
        return validationStatus;
    }

    public ValidationStatus validate(DLightTarget dLightTarget) {
        ValidationStatus validationStatus = this.validate(dLightTarget, (Validateable<DLightTarget>)this, true);
        if (validationStatus.isValid()) {
            SunStudioUserCounter.countDLight((ExecutionEnvironment)dLightTarget.getExecEnv());
        }
        return validationStatus;
    }

    ValidationStatus validate(DLightTarget dLightTarget, Validateable<DLightTarget> validateable, boolean bl) {
        if (this.validationStatus.isValid()) {
            return this.validationStatus;
        }
        ValidationStatus validationStatus = this.validationStatus;
        ValidationStatus validationStatus2 = this.doValidation(dLightTarget);
        if (bl) {
            this.notifyStatusChanged(validateable, validationStatus, validationStatus2);
        }
        this.validationStatus = validationStatus2;
        return validationStatus2;
    }

    public void invalidate() {
        this.validationStatus = ValidationStatus.initialStatus();
    }

    public ValidationStatus getValidationStatus() {
        return this.validationStatus;
    }

    private void targetStarted(DLightTarget dLightTarget) {
        Object object;
        if (this.isSlave || this.scriptPath == null) {
            return;
        }
        String string = this.scriptPath;
        if (dLightTarget instanceof AttachableTarget) {
            object = (AttachableTarget)dLightTarget;
            string = string + " " + Integer.toString(object.getPID());
        }
        if ((object = this.getCollectorTaskExtraParams()) != null) {
            string = string + " " + (String)object;
        }
        NativeProcessBuilder nativeProcessBuilder = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)dLightTarget.getExecEnv());
        nativeProcessBuilder.setCommandLine(string);
        this.dtraceRunner = new CollectorRunner((IndicatorNotificationsListener)new FakeIndicatorNotificationListener(), nativeProcessBuilder, this.getOutputProcessor(), "__EOF_MARKER__", "DTrace");
        log.fine("DtraceDataCollector (" + this.dtraceRunner.toString() + ") for " + string + " STARTED");
    }

    public void addValidationListener(ValidationListener validationListener) {
        if (!this.validationListeners.contains(validationListener)) {
            this.validationListeners.add(validationListener);
        }
    }

    public void removeValidationListener(ValidationListener validationListener) {
        this.validationListeners.remove(validationListener);
    }

    void notifyStatusChanged(Validateable<DLightTarget> object, ValidationStatus validationStatus, ValidationStatus validationStatus2) {
        if (validationStatus.equals((Object)validationStatus2)) {
            return;
        }
        ValidationListener[] validationListenerArray = this.validationListeners.toArray(new ValidationListener[0]);
        if (object == null) {
            object = this;
        }
        for (ValidationListener validationListener : validationListenerArray) {
            validationListener.validationStateChanged(object, validationStatus, validationStatus2);
        }
    }

    protected void notifyStatusChanged(ValidationStatus validationStatus, ValidationStatus validationStatus2) {
        this.notifyStatusChanged((Validateable<DLightTarget>)this, validationStatus, validationStatus2);
    }

    public void targetStateChanged(DLightTargetChangeEvent dLightTargetChangeEvent) {
        switch (dLightTargetChangeEvent.state) {
            case RUNNING: {
                this.targetStarted(dLightTargetChangeEvent.target);
                break;
            }
            case FAILED: {
                this.targetFinished(dLightTargetChangeEvent.target);
                break;
            }
            case TERMINATED: {
                this.targetFinished(dLightTargetChangeEvent.target);
                break;
            }
            case DONE: {
                this.targetFinished(dLightTargetChangeEvent.target);
                break;
            }
            case STOPPED: {
                this.targetFinished(dLightTargetChangeEvent.target);
                return;
            }
        }
        for (DtraceDataCollector dtraceDataCollector : this.slaveCollectors.values()) {
            dtraceDataCollector.targetStateChanged(dLightTargetChangeEvent);
        }
    }

    public void dataFiltersChanged(List<DataFilter> list, boolean bl) {
    }

    private File mergeScripts() {
        try {
            HashMap<String, URL> hashMap = new HashMap<String, URL>();
            for (Map.Entry<String, DtraceDataCollector> entry : this.slaveCollectors.entrySet()) {
                hashMap.put(entry.getKey(), entry.getValue().getLocalScriptUrl());
            }
            return DTraceScriptUtils.mergeScripts(hashMap);
        }
        catch (IOException iOException) {
            DLightLogger.getLogger(DtraceDataCollector.class).log(Level.SEVERE, null, iOException);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FakeIndicatorNotificationListener
    implements IndicatorNotificationsListener {
        private FakeIndicatorNotificationListener() {
        }

        public void reset() {
            DtraceDataCollector.this.resetIndicators();
        }

        public void suggestRepaint() {
            DtraceDataCollector.this.suggestIndicatorsRepaint();
        }

        public void updated(List<DataRow> list) {
            DtraceDataCollector.this.notifyIndicators(list);
        }
    }

    private class DemultiplexingLineProcessor
    implements LineProcessor {
        private DemultiplexingLineProcessor() {
        }

        public void processLine(String string) {
            DtraceDataCollector dtraceDataCollector = DtraceDataCollector.this.lastSlaveCollector;
            for (Map.Entry entry : DtraceDataCollector.this.slaveCollectors.entrySet()) {
                String string2 = (String)entry.getKey();
                if (!string.startsWith(string2)) continue;
                string = string.substring(string2.length());
                dtraceDataCollector = (DtraceDataCollector)((Object)entry.getValue());
                break;
            }
            if (dtraceDataCollector != null) {
                dtraceDataCollector.getOutputProcessor().processLine(string);
            }
            DtraceDataCollector.this.lastSlaveCollector = dtraceDataCollector;
        }

        public void reset() {
            for (Map.Entry entry : DtraceDataCollector.this.slaveCollectors.entrySet()) {
                ((DtraceDataCollector)((Object)entry.getValue())).getOutputProcessor().reset();
            }
        }

        public void close() {
            for (Map.Entry entry : DtraceDataCollector.this.slaveCollectors.entrySet()) {
                ((DtraceDataCollector)((Object)entry.getValue())).getOutputProcessor().close();
            }
            DtraceDataCollector.this.suggestIndicatorsRepaint();
        }
    }

    private final class DefaultLineProcessor
    implements LineProcessor {
        private DefaultLineProcessor() {
        }

        public void processLine(String string) {
            DataRow dataRow = DtraceDataCollector.this.parser.process(string);
            this.addDataRow(dataRow);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addDataRow(DataRow dataRow) {
            if (dataRow != null) {
                if (DtraceDataCollector.this.storage != null && DtraceDataCollector.this.tableMetaData != null) {
                    DtraceDataCollector.this.storage.addData(DtraceDataCollector.this.tableMetaData.getName(), Arrays.asList(dataRow));
                }
                List list = DtraceDataCollector.this.indicatorDataBuffer;
                synchronized (list) {
                    DtraceDataCollector.this.indicatorDataBuffer.add(dataRow);
                    if (DtraceDataCollector.this.indicatorDataBuffer.size() >= DtraceDataCollector.this.indicatorFiringFactor) {
                        if (DtraceDataCollector.this.isSlave) {
                            if (DtraceDataCollector.this.parentCollector != null) {
                                DtraceDataCollector.this.parentCollector.notifyIndicators(DtraceDataCollector.this.indicatorDataBuffer);
                            }
                        } else {
                            DtraceDataCollector.this.notifyIndicators(DtraceDataCollector.this.indicatorDataBuffer);
                        }
                        DtraceDataCollector.this.indicatorDataBuffer.clear();
                    }
                }
            }
        }

        public void reset() {
        }

        public void close() {
            DataRow dataRow = DtraceDataCollector.this.parser.processClose();
            this.addDataRow(dataRow);
            DtraceDataCollector.this.suggestIndicatorsRepaint();
        }
    }
}

