/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.core.ui.top;

import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.cnd.asm.core.dataobjects.AsmObjectUtilities;
import org.netbeans.modules.cnd.asm.core.ui.top.InstructionInfoPanel;
import org.netbeans.modules.cnd.asm.core.ui.top.NavigatorTab;
import org.netbeans.modules.cnd.asm.model.AsmModel;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class InstructionListPanel
extends JPanel
implements NavigatorTab {
    private static NavigatorTab instance;
    private AsmModel model;
    private final InstructionInfoPanel info = new InstructionInfoPanel();
    private JList jInstructionList;
    private JScrollPane jInstructionListScrollPane;

    public static synchronized NavigatorTab getInstance() {
        if (instance == null) {
            instance = new InstructionListPanel();
        }
        return instance;
    }

    private InstructionListPanel() {
        this.initComponents();
        this.add(this.info);
        this.setEnabled(false);
        this.jInstructionList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = listSelectionEvent.getFirstIndex();
                InstructionListPanel.this.info.setInstruction(InstructionListPanel.this.model.getInstructionSet().get(n));
            }
        });
    }

    public void setDocument(DataObject dataObject) {
        this.model = AsmObjectUtilities.getModel(dataObject);
        if (this.model != null) {
            this.setEnabled(true);
        }
        this.jInstructionList.setModel(new InstructionListModel());
    }

    public String getName() {
        return NbBundle.getMessage(InstructionListPanel.class, (String)"CTL_INSTR_NAME");
    }

    public JPanel getPanel() {
        return this;
    }

    private void initComponents() {
        this.jInstructionListScrollPane = new JScrollPane();
        this.jInstructionList = new JList();
        this.setLayout(new BoxLayout(this, 1));
        this.jInstructionListScrollPane.setAutoscrolls(true);
        this.jInstructionList.setSelectionMode(0);
        this.jInstructionList.setVisibleRowCount(10);
        this.jInstructionListScrollPane.setViewportView(this.jInstructionList);
        this.add(this.jInstructionListScrollPane);
    }

    private class InstructionListModel
    extends AbstractListModel {
        private InstructionListModel() {
        }

        public int getSize() {
            if (InstructionListPanel.this.model == null) {
                return 0;
            }
            return InstructionListPanel.this.model.getInstructionSet().size();
        }

        public Object getElementAt(int n) {
            return InstructionListPanel.this.model.getInstructionSet().get(n);
        }
    }
}

