/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.attach;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.cnd.debugger.gdb.DebuggerStartException;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.attach.GdbAttachPanel;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class GdbServerAttachPanel
extends JPanel {
    private final Controller controller = new GdbServerAttachController();
    private static final String HOST_KEY = "last-gdbserver-host";
    private static final String PORT_KEY = "last-gdbserver-port";
    private JTextField hostTF;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField portTF;
    private JComboBox projectCB;
    private JLabel projectLabel;

    public GdbServerAttachPanel() {
        this.initComponents();
        GdbAttachPanel.fillProjectsCombo(this.projectCB);
        this.hostTF.setText(NbPreferences.forModule(GdbServerAttachPanel.class).get(HOST_KEY, ""));
        this.portTF.setText(NbPreferences.forModule(GdbServerAttachPanel.class).get(PORT_KEY, ""));
    }

    Controller getController() {
        return this.controller;
    }

    private void initComponents() {
        this.projectLabel = new JLabel();
        this.projectCB = new JComboBox();
        this.jLabel1 = new JLabel();
        this.hostTF = new JTextField();
        this.jLabel2 = new JLabel();
        this.portTF = new JTextField();
        this.projectLabel.setText(NbBundle.getMessage(GdbServerAttachPanel.class, (String)"GdbServerAttachPanel.projectLabel.text"));
        this.jLabel1.setText(NbBundle.getMessage(GdbServerAttachPanel.class, (String)"GdbServerAttachPanel.jLabel1.text"));
        this.jLabel2.setText(NbBundle.getMessage(GdbServerAttachPanel.class, (String)"GdbServerAttachPanel.jLabel2.text"));
        this.portTF.setText(NbBundle.getMessage(GdbServerAttachPanel.class, (String)"GdbServerAttachPanel.portTF.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.projectLabel).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.portTF, -1, 335, Short.MAX_VALUE).add((Component)this.hostTF, -1, 335, Short.MAX_VALUE).add((Component)this.projectCB, 0, 335, Short.MAX_VALUE))));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.hostTF, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.portTF, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectLabel).add((Component)this.projectCB, -2, -1, -2))));
    }

    private class GdbServerAttachController
    implements Controller {
        private GdbServerAttachController() {
        }

        public boolean cancel() {
            return true;
        }

        public boolean ok() {
            String string = GdbServerAttachPanel.this.hostTF.getText();
            if (string.length() == 0) {
                return false;
            }
            String string2 = GdbServerAttachPanel.this.portTF.getText();
            if (string2.length() == 0) {
                return false;
            }
            NbPreferences.forModule(GdbServerAttachPanel.class).put(GdbServerAttachPanel.HOST_KEY, string);
            NbPreferences.forModule(GdbServerAttachPanel.class).put(GdbServerAttachPanel.PORT_KEY, string2);
            GdbAttachPanel.ProjectCBItem projectCBItem = (GdbAttachPanel.ProjectCBItem)GdbServerAttachPanel.this.projectCB.getSelectedItem();
            if (projectCBItem != null) {
                String string3 = string + ':' + string2;
                try {
                    GdbDebugger.attachGdbServer(string3, projectCBItem.getProjectInformation());
                }
                catch (DebuggerStartException debuggerStartException) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbServerAttachPanel.class, (String)"ERR_UnexpecedAttachGdbServerFailure", (Object)string3)));
                }
            }
            return true;
        }

        public boolean isValid() {
            return GdbServerAttachPanel.this.projectCB.getItemCount() > 0;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }
    }
}

