/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.attach;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import org.netbeans.modules.cnd.api.compilers.CompilerSetUtils;
import org.netbeans.modules.cnd.debugger.gdb.actions.AttachTableColumn;
import org.netbeans.modules.cnd.debugger.gdb.attach.ProcessListReader;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProcessList {
    private PTYPE ptype = PTYPE.UNINITIALIZED;
    private String executable;
    private final List<String> argsSimple = new ArrayList<String>();
    private final ExecutionEnvironment exEnv;

    protected ProcessList(ExecutionEnvironment executionEnvironment) {
        this.exEnv = executionEnvironment;
    }

    private void init() throws IllegalStateException {
        String string = "";
        try {
            HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.exEnv);
            if (!hostInfo.getOSFamily().isUnix()) {
                if (this.exEnv.isRemote()) {
                    throw new IllegalStateException("Remote windows machines are not supported yet");
                }
                File file = new File(CompilerSetUtils.getCygwinBase() + "/bin", "ps.exe");
                if (!file.exists()) {
                    file = new File(CompilerSetUtils.getMSysBase() + "/bin", "ps.exe");
                }
                if (file.exists()) {
                    string = file.getAbsolutePath();
                    this.ptype = PTYPE.WINDOWS;
                } else {
                    this.ptype = PTYPE.NONE;
                }
            } else {
                if (HostInfoUtils.fileExists((ExecutionEnvironment)this.exEnv, (String)"/bin/ps")) {
                    string = "/bin/ps";
                } else if (HostInfoUtils.fileExists((ExecutionEnvironment)this.exEnv, (String)"/usr/bin/ps")) {
                    string = "/usr/bin/ps";
                } else {
                    this.ptype = PTYPE.NONE;
                }
                if (string.length() > 0) {
                    String string2 = this.exEnv.getUser();
                    if (string2 != null && string2.length() > 0) {
                        this.argsSimple.add("-u");
                        this.argsSimple.add(string2);
                    } else {
                        this.argsSimple.add("-a");
                    }
                    this.argsSimple.add("-o");
                    if (hostInfo.getOSFamily() == HostInfo.OSFamily.MACOSX) {
                        this.argsSimple.add("user,pid,ppid,stime,time,command");
                    } else {
                        this.argsSimple.add("user,pid,ppid,stime,time,args");
                    }
                    this.ptype = PTYPE.STD;
                }
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            this.ptype = PTYPE.NONE;
        }
        catch (CancellationException cancellationException) {
            this.ptype = PTYPE.NONE;
        }
        this.executable = string;
    }

    private void request(final ProcessListReader processListReader, final boolean bl) {
        if (this.ptype != PTYPE.NONE) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        String string;
                        if (ProcessList.this.ptype == PTYPE.UNINITIALIZED) {
                            ProcessList.this.init();
                        }
                        if (ProcessList.this.ptype == PTYPE.NONE) {
                            processListReader.processListCallback(Collections.<String>emptyList());
                            return;
                        }
                        ArrayList<String> arrayList = new ArrayList<String>(ProcessList.this.argsSimple);
                        if (bl) {
                            if (ProcessList.this.ptype == PTYPE.WINDOWS) {
                                arrayList.add("-W");
                            } else if (ProcessList.this.ptype == PTYPE.STD) {
                                arrayList.add("-A");
                            }
                        }
                        NativeProcessBuilder nativeProcessBuilder = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)ProcessList.this.exEnv);
                        nativeProcessBuilder.setExecutable(ProcessList.this.executable);
                        nativeProcessBuilder.setArguments(arrayList.toArray(new String[arrayList.size()]));
                        nativeProcessBuilder.redirectError();
                        NativeProcess nativeProcess = nativeProcessBuilder.call();
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(nativeProcess.getInputStream()));
                        bufferedReader.readLine();
                        ArrayList<String> arrayList2 = new ArrayList<String>();
                        while ((string = bufferedReader.readLine()) != null) {
                            arrayList2.add(string);
                        }
                        processListReader.processListCallback(arrayList2);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        } else {
            processListReader.processListCallback(Collections.<String>emptyList());
        }
    }

    void requestSimple(ProcessListReader processListReader) {
        this.request(processListReader, false);
    }

    void requestFull(ProcessListReader processListReader) {
        this.request(processListReader, true);
    }

    protected boolean isStd() {
        return this.ptype == PTYPE.STD;
    }

    protected boolean isWindowsPsFound() {
        return this.ptype == PTYPE.WINDOWS;
    }

    protected List<AttachTableColumn> getColumnHeaders() {
        ArrayList<AttachTableColumn> arrayList = new ArrayList<AttachTableColumn>();
        if (this.ptype == PTYPE.STD) {
            arrayList.add(new AttachTableColumn("user", NbBundle.getMessage(ProcessList.class, (String)"HDR_USER")));
            arrayList.add(new AttachTableColumn("pid", NbBundle.getMessage(ProcessList.class, (String)"HDR_PID")));
            arrayList.add(new AttachTableColumn("ppid", NbBundle.getMessage(ProcessList.class, (String)"HDR_PPID")));
            arrayList.add(new AttachTableColumn("stime", NbBundle.getMessage(ProcessList.class, (String)"HDR_STIME")));
            arrayList.add(new AttachTableColumn("time", NbBundle.getMessage(ProcessList.class, (String)"HDR_TIME")));
            arrayList.add(new AttachTableColumn("args", NbBundle.getMessage(ProcessList.class, (String)"HDR_ARGS")));
        } else if (this.ptype == PTYPE.WINDOWS) {
            arrayList.add(new AttachTableColumn("uid", NbBundle.getMessage(ProcessList.class, (String)"HDR_UID")));
            arrayList.add(new AttachTableColumn("winpid", NbBundle.getMessage(ProcessList.class, (String)"HDR_WINPID")));
            arrayList.add(new AttachTableColumn("pid", NbBundle.getMessage(ProcessList.class, (String)"HDR_PID")));
            arrayList.add(new AttachTableColumn("ppid", NbBundle.getMessage(ProcessList.class, (String)"HDR_PPID")));
            arrayList.add(new AttachTableColumn("stime", NbBundle.getMessage(ProcessList.class, (String)"HDR_STIME")));
            arrayList.add(new AttachTableColumn("args", NbBundle.getMessage(ProcessList.class, (String)"HDR_ARGS")));
        }
        return arrayList;
    }

    protected String getArgsHeader() {
        return NbBundle.getMessage(ProcessList.class, (String)"HDR_ARGS");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PTYPE {
        UNINITIALIZED,
        NONE,
        STD,
        WINDOWS;

    }
}

