/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.modules.cnd.debugger.common.ui.VariablesViewButtons;
import org.netbeans.modules.cnd.debugger.gdb.GdbCallStackFrame;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.models.AbstractVariable;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class LocalsTreeModel
implements TreeModel,
PropertyChangeListener {
    private GdbDebugger debugger;
    private Listener listener;
    private final List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();
    private static final Logger log = Logger.getLogger("gdb.logger");
    private Preferences preferences = NbPreferences.forModule(VariablesViewButtons.class).node("variables_view");
    private VariablesPreferenceChangeListener prefListener = new VariablesPreferenceChangeListener();
    private PropertyChangeListener[] varListeners;

    public LocalsTreeModel(ContextProvider contextProvider) {
        this.debugger = (GdbDebugger)contextProvider.lookupFirst(null, GdbDebugger.class);
        this.preferences.addPreferenceChangeListener(this.prefListener);
    }

    public Object getRoot() {
        return "Root";
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("var_value".equals(propertyChangeEvent.getPropertyName())) {
            this.fireNodeChanged(propertyChangeEvent.getSource());
        }
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        Object[] objectArray;
        for (Object object2 : objectArray = this.getChildrenImpl(object)) {
            if (!(object2 instanceof AbstractVariable)) continue;
            ((AbstractVariable)object2).addPropertyChangeListener(this);
        }
        return objectArray;
    }

    public Object[] getChildrenImpl(Object object) throws UnknownTypeException {
        if (object.equals("Root")) {
            Object[] objectArray = VariablesViewButtons.isShowAutos() ? this.getAutos() : this.getLocalVariables();
            this.updateVarListeners((AbstractVariable[])objectArray);
            return objectArray;
        }
        if (object instanceof AbstractVariable) {
            AbstractVariable abstractVariable = (AbstractVariable)object;
            return abstractVariable.getFields();
        }
        return new AbstractVariable[0];
    }

    private void updateVarListeners(AbstractVariable[] abstractVariableArray) {
        this.varListeners = new PropertyChangeListener[abstractVariableArray.length];
        for (int i = 0; i < abstractVariableArray.length; ++i) {
            PropertyChangeListener propertyChangeListener;
            AbstractVariable abstractVariable = abstractVariableArray[i];
            this.varListeners[i] = propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    LocalsTreeModel.this.fireNodeChanged(propertyChangeEvent.getSource());
                }
            };
            abstractVariable.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)propertyChangeListener, (Object)abstractVariable));
        }
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (object.equals("Root")) {
            return Integer.MAX_VALUE;
        }
        if (object instanceof AbstractVariable) {
            return Integer.MAX_VALUE;
        }
        return 0;
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object.equals("Root")) {
            return false;
        }
        if (object instanceof AbstractVariable) {
            int n = ((AbstractVariable)object).getFieldsCount();
            return n == 0;
        }
        if (object.equals("NoInfo")) {
            return true;
        }
        if (object.equals("No current thread")) {
            return true;
        }
        if (object instanceof AbstractVariable.ErrorField) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
        if (this.listener == null) {
            this.listener = new Listener(this, this.debugger);
        }
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
        if (this.listeners.isEmpty()) {
            this.listener.destroy();
            this.listener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireTreeChanged() {
        ArrayList<ModelListener> arrayList;
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            arrayList = new ArrayList<ModelListener>(this.listeners);
        }
        for (ModelListener modelListener : arrayList) {
            modelListener.modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTableValueChanged(Object object, String string) {
        ArrayList<ModelListener> arrayList;
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            arrayList = new ArrayList<ModelListener>(this.listeners);
        }
        for (ModelListener modelListener : arrayList) {
            modelListener.modelChanged((ModelEvent)new ModelEvent.TableValueChanged((Object)this, object, string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNodeChanged(Object object) {
        ArrayList<ModelListener> arrayList;
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            arrayList = new ArrayList<ModelListener>(this.listeners);
        }
        for (ModelListener modelListener : arrayList) {
            modelListener.modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractVariable[] getLocalVariables() {
        Object object = this.debugger.LOCK;
        synchronized (object) {
            GdbCallStackFrame gdbCallStackFrame = this.debugger.getCurrentCallStackFrame();
            if (gdbCallStackFrame == null) {
                return new AbstractVariable[0];
            }
            return gdbCallStackFrame.getLocalVariables();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractVariable[] getAutos() {
        Object object = this.debugger.LOCK;
        synchronized (object) {
            GdbCallStackFrame gdbCallStackFrame = this.debugger.getCurrentCallStackFrame();
            if (gdbCallStackFrame == null) {
                return new AbstractVariable[0];
            }
            AbstractVariable[] abstractVariableArray = gdbCallStackFrame.getAutos();
            if (abstractVariableArray != null) {
                return abstractVariableArray;
            }
            return new AbstractVariable[0];
        }
    }

    GdbDebugger getDebugger() {
        return this.debugger;
    }

    private class VariablesPreferenceChangeListener
    implements PreferenceChangeListener {
        private VariablesPreferenceChangeListener() {
        }

        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            String string = preferenceChangeEvent.getKey();
            if ("show_autos".equals(string)) {
                this.refresh();
            }
        }

        private void refresh() {
            try {
                LocalsTreeModel.this.fireTableValueChanged("Root", null);
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                Exceptions.printStackTrace((Throwable)throwable);
            }
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private final GdbDebugger debugger;
        private final WeakReference<LocalsTreeModel> model;
        private RequestProcessor.Task task;

        public Listener(LocalsTreeModel localsTreeModel, GdbDebugger gdbDebugger) {
            this.debugger = gdbDebugger;
            this.model = new WeakReference<LocalsTreeModel>(localsTreeModel);
            gdbDebugger.addPropertyChangeListener(this);
        }

        void destroy() {
            this.debugger.removePropertyChangeListener(this);
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }

        private LocalsTreeModel getModel() {
            LocalsTreeModel localsTreeModel = (LocalsTreeModel)this.model.get();
            if (localsTreeModel == null) {
                this.destroy();
            }
            return localsTreeModel;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ((propertyChangeEvent.getPropertyName().equals("currentCallStackFrame") || propertyChangeEvent.getPropertyName().equals("currentThread")) && this.debugger.isStopped()) {
                log.fine("LTM.propertyChange: Change for " + propertyChangeEvent.getPropertyName());
                final LocalsTreeModel localsTreeModel = this.getModel();
                if (localsTreeModel == null) {
                    return;
                }
                if (this.task != null) {
                    this.task.cancel();
                    this.task = null;
                }
                this.task = RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        if (Listener.this.debugger.isStopped()) {
                            localsTreeModel.fireTreeChanged();
                        }
                    }
                }, 500);
            } else if (propertyChangeEvent.getPropertyName().equals("state") && !this.debugger.isStopped() && this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }
    }
}

