/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.proxy;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.Signal;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ExternalTerminal
implements PropertyChangeListener {
    private final String tty;
    private final long pid;
    private File gdbHelperLog = null;
    private File gdbHelperScript = null;
    private final GdbDebugger debugger;
    private static final Logger log = Logger.getLogger("gdb.logger");
    private static final int RETRY_LIMIT = 200;

    public static String create(GdbDebugger gdbDebugger, String string, String[] stringArray) throws IOException {
        return new ExternalTerminal((GdbDebugger)gdbDebugger, (String)string, (String[])stringArray).tty;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ExternalTerminal(GdbDebugger gdbDebugger, String string, String[] stringArray) throws IOException {
        Object object;
        this.debugger = gdbDebugger;
        gdbDebugger.addPropertyChangeListener(this);
        this.initGdbHelpers();
        TerminalProfile terminalProfile = this.getTermProfile(string);
        ProcessBuilder processBuilder = new ProcessBuilder(terminalProfile.options);
        if (Utilities.getOperatingSystem() == 4096 && (object = processBuilder.environment()).get("DISPLAY") == null) {
            String string2 = ":0.0";
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith("DISPLAY=") || stringArray[i].length() < 8) continue;
                string2 = stringArray[i].substring(8);
            }
            object.put("DISPLAY", string2);
        }
        processBuilder.redirectErrorStream(true);
        object = processBuilder.start();
        int n = 0;
        String string3 = null;
        String string4 = null;
        try {
            while (n++ < 200) {
                if (!terminalProfile.terminates) {
                    try {
                        int n2 = ((Process)object).exitValue();
                        String string5 = ProcessUtils.readProcessOutputLine((Process)object);
                        throw new IllegalStateException(NbBundle.getMessage(ExternalTerminal.class, (String)"ERR_ExternalTerminalFailedMessageDetails", (Object)Arrays.toString(terminalProfile.options), (Object)n2, (Object)string5));
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        // empty catch block
                    }
                }
                BufferedReader bufferedReader = new BufferedReader(new FileReader(this.gdbHelperLog));
                string3 = bufferedReader.readLine();
                string4 = bufferedReader.readLine();
                bufferedReader.close();
                if (string4 != null) break;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            if (n >= 200) {
                log.warning("Retry limit reached for " + this.gdbHelperLog + ", giving up");
            }
        }
        catch (IOException iOException) {
            log.warning("Failed to read external terminal helper");
        }
        this.tty = string3;
        log.finest("ExternalTerminal: tty=" + this.tty);
        long l = 0L;
        try {
            l = Long.valueOf(string4);
        }
        catch (Exception exception) {
            log.warning("Error parsing pid: " + string4);
        }
        this.pid = l;
        log.finest("ExternalTerminal: pid=" + this.pid);
    }

    private void initGdbHelpers() {
        try {
            this.gdbHelperLog = File.createTempFile("gdb_helper_", ".log");
            this.gdbHelperScript = File.createTempFile("gdb_helper_", ".sh");
        }
        catch (IOException iOException) {
            this.gdbHelperLog = new File("/tmp/gdb_helper.log");
            this.gdbHelperScript = new File("/tmp/gdb_helper.sh");
        }
        String string = NbBundle.getMessage(ExternalTerminal.class, (String)"GdbHelperScript", (Object)this.gdbHelperLog.getAbsolutePath());
        this.gdbHelperLog.deleteOnExit();
        this.gdbHelperScript.deleteOnExit();
        try {
            FileWriter fileWriter = new FileWriter(this.gdbHelperScript);
            fileWriter.write(string);
            fileWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            CommonTasksSupport.chmod((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal(), (String)this.gdbHelperScript.getAbsolutePath(), (int)493, null).get(30L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    String getTty() {
        return this.tty;
    }

    private TerminalProfile getTermProfile(String string) {
        if (string.contains("gnome-terminal")) {
            return new TerminalProfile(false, new String[]{string, "--hide-menubar", "--disable-factory", "--command", this.gdbHelperScript.getAbsolutePath()});
        }
        if (string.contains("xterm")) {
            return new TerminalProfile(false, new String[]{string, "-e", this.gdbHelperScript.getAbsolutePath()});
        }
        return new TerminalProfile(true, new String[]{string, "-e", this.gdbHelperScript.getAbsolutePath()});
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("state")) {
            Object object = propertyChangeEvent.getNewValue();
            if (object == GdbDebugger.State.EXITED) {
                this.gdbHelperScript.delete();
                this.gdbHelperLog.delete();
                this.debugger.removePropertyChangeListener(this);
            }
        } else if (propertyChangeEvent.getPropertyName().equals("killTerm")) {
            if (this.pid == 0L) {
                log.warning("Killing zero pid detected from log: " + this.gdbHelperLog);
            }
            this.debugger.kill(Signal.TERM, this.pid);
        }
    }

    private static class TerminalProfile {
        private final String[] options;
        private final boolean terminates;

        private TerminalProfile(boolean bl, String ... stringArray) {
            this.options = stringArray;
            this.terminates = bl;
        }
    }
}

