/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.proxy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.Signal;
import org.netbeans.modules.cnd.debugger.gdb.proxy.CommandBuffer;
import org.netbeans.modules.cnd.debugger.gdb.proxy.GdbLogger;
import org.netbeans.modules.cnd.debugger.gdb.proxy.GdbProxyEngine;
import org.netbeans.modules.cnd.debugger.gdb.proxy.MICommand;
import org.netbeans.modules.cnd.debugger.gdb.utils.GdbUtils;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GdbProxy {
    private static final boolean GDBINIT = Boolean.getBoolean("gdb.init.enable");
    private final GdbDebugger debugger;
    private final GdbProxyEngine engine;
    private final GdbLogger gdbLogger;
    private final Map<Integer, CommandBuffer> map = Collections.synchronizedMap(new HashMap());
    public static final int MEMORY_READ_WIDTH = 16;

    public GdbProxy(GdbDebugger gdbDebugger, String string, String[] stringArray, String string2, String string3, String string4) throws IOException {
        this.debugger = gdbDebugger;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        if (!GDBINIT) {
            arrayList.add("-nx");
        }
        arrayList.add("--nw");
        arrayList.add("--silent");
        arrayList.add("--interpreter=mi");
        this.gdbLogger = new GdbLogger(gdbDebugger, this);
        this.engine = new GdbProxyEngine(gdbDebugger, this, arrayList, stringArray, string2, string3, string4);
    }

    public GdbProxyEngine getProxyEngine() {
        return this.engine;
    }

    public GdbLogger getLogger() {
        return this.gdbLogger;
    }

    public CommandBuffer getCommandBuffer(Integer n) {
        return this.map.get(n);
    }

    public void removeCB(int n) {
        this.map.remove(n);
    }

    public void putCB(int n, CommandBuffer commandBuffer) {
        this.map.put(n, commandBuffer);
    }

    public void file_exec_and_symbols(String string) {
        this.engine.sendCommand("-file-exec-and-symbols \"" + string + '\"');
    }

    public void addSymbolFile(String string, String string2) {
        this.engine.sendCommand("add-symbol-file \"" + string + "\" " + string2);
    }

    public CommandBuffer core(String string) {
        return this.engine.sendCommandEx("core " + string);
    }

    public CommandBuffer attach(String string) {
        return this.engine.sendCommandEx("attach " + string);
    }

    public CommandBuffer attachRemote(String string) {
        return this.engine.sendCommandEx("target remote " + string);
    }

    public void target_detach() {
        this.engine.sendCommand("detach");
    }

    public void file_symbol_file(String string) {
        this.engine.sendCommand("-file-symbol-file \"" + string + '\"');
    }

    public CommandBuffer gdb_version() {
        return this.engine.sendCommandEx("-gdb-version");
    }

    public void gdb_show(String string) {
        this.engine.sendCommand("-gdb-show " + string);
    }

    public void environment_cd(String string) {
        this.engine.sendCommand(this.debugger.getVersionPeculiarity().environmentCdCommand() + " \"" + string + '\"');
    }

    public void environment_directory(String string) {
        this.environment_directory(Collections.singletonList(string));
    }

    public void environment_directory(List<String> list) {
        assert (!list.isEmpty());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.debugger.getVersionPeculiarity().environmentDirectoryCommand());
        for (String string : list) {
            stringBuilder.append(" \"");
            stringBuilder.append(string);
            stringBuilder.append("\"");
        }
        this.engine.sendCommand(stringBuilder.toString());
    }

    public CommandBuffer info_threads() {
        return this.engine.sendCommandEx("info threads");
    }

    public CommandBuffer info_files() {
        return this.engine.sendCommandEx("info files");
    }

    public void thread_select(String string) {
        this.engine.sendCommand("-thread-select " + string);
    }

    public void info_proc() {
        this.engine.sendCommand("info proc");
    }

    public CommandBuffer info_share(boolean bl) {
        return this.engine.sendCommandEx("info share", bl);
    }

    public CommandBuffer data_evaluate_expressionEx(String string) {
        return this.engine.sendCommandEx("-data-evaluate-expression " + string);
    }

    public void data_evaluate_expression(String string) {
        this.engine.sendCommand("-data-evaluate-expression " + string);
    }

    public void data_list_register_names(String string) {
        this.engine.sendCommand("-data-list-register-names " + string);
    }

    public void data_list_register_values(String string) {
        this.engine.sendCommand("-data-list-register-values x " + string);
    }

    public void data_list_changed_registers() {
        this.engine.sendCommand("-data-list-changed-registers");
    }

    public void data_disassemble(String string, int n, boolean bl) {
        int n2 = bl ? 1 : 0;
        this.engine.sendCommand("-data-disassemble -f \"" + string + "\" -l " + n + " -- " + n2);
    }

    public void data_disassemble(int n, boolean bl) {
        int n2 = bl ? 1 : 0;
        this.engine.sendCommand("-data-disassemble -s $pc -e \"$pc+" + n + "\" -- " + n2);
    }

    public CommandBuffer data_read_memory(String string, int n) {
        return this.engine.sendCommandEx("-data-read-memory " + string + " x 1 " + n + " " + 16 + " .");
    }

    public CommandBuffer print(String string) {
        return this.engine.sendCommandEx("print " + string);
    }

    public CommandBuffer file_list_exec_source_file() {
        return this.engine.sendCommandEx("-file-list-exec-source-file");
    }

    public CommandBuffer exec_run(String string) {
        return this.engine.sendCommandEx("-exec-run " + string);
    }

    public void exec_run() {
        this.exec_run("");
    }

    public void exec_step() {
        this.debugger.setLastGo(GdbDebugger.LastGoState.STEP);
        this.engine.sendCommand("-exec-step");
    }

    public void exec_next() {
        this.debugger.setLastGo(GdbDebugger.LastGoState.NEXT);
        this.engine.sendCommand("-exec-next");
    }

    public void exec_step_instruction() {
        this.engine.sendCommand("-exec-step-instruction");
    }

    public void exec_next_instruction() {
        this.engine.sendCommand("-exec-next-instruction");
    }

    public void exec_finish() {
        this.debugger.setLastGo(GdbDebugger.LastGoState.FINISH);
        this.engine.sendCommand("-exec-finish");
    }

    public void exec_continue() {
        this.debugger.setLastGo(GdbDebugger.LastGoState.CONTINUE);
        this.engine.sendCommand("-exec-continue");
    }

    public void exec_interrupt() {
        if (this.debugger.getState() == GdbDebugger.State.RUNNING || this.debugger.getState() == GdbDebugger.State.SILENT_STOP) {
            if (this.debugger.getPlatform() == 4) {
                this.debugger.kill(Signal.TRAP);
            } else {
                this.debugger.kill(Signal.INT);
            }
        }
    }

    public void exec_abort() {
        this.engine.sendCommand(this.debugger.getVersionPeculiarity().execAbortCommand());
    }

    public MICommand break_insertCMD(int n, boolean bl, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (GdbUtils.isMultiByte(string)) {
            if (bl) {
                stringBuilder.append("tbreak ");
            } else {
                stringBuilder.append("break ");
            }
        } else {
            stringBuilder.append("-break-insert ");
            if (bl) {
                stringBuilder.append("-t ");
            }
            stringBuilder.append(this.debugger.getVersionPeculiarity().breakPendingFlag());
        }
        if (Utilities.isWindows() && string.indexOf(47) == 0 && string.indexOf(58) == 2) {
            string = string.substring(1);
        } else if (this.debugger.getPlatform() == 4) {
            stringBuilder.append("-l 1 ");
        }
        if (n == 1) {
            stringBuilder.append("-p " + string2 + " ");
        }
        stringBuilder.append(string);
        return this.engine.createMICommand(stringBuilder.toString());
    }

    public void break_insert(String string) {
        this.break_insertCMD(0, false, string, null).send();
    }

    public void break_insert_temporary(String string) {
        this.break_insertCMD(0, true, string, null).send();
    }

    public MICommand break_deleteCMD(Object object) {
        return this.engine.createMICommand("-break-delete " + object);
    }

    public MICommand break_enableCMD(Integer ... integerArray) {
        StringBuilder stringBuilder = new StringBuilder("-break-enable");
        Integer[] integerArray2 = integerArray;
        int n = integerArray2.length;
        for (int i = 0; i < n; ++i) {
            int n2 = integerArray2[i];
            stringBuilder.append(' ');
            stringBuilder.append(n2);
        }
        return this.engine.createMICommand(stringBuilder.toString());
    }

    public MICommand break_disableCMD(Integer ... integerArray) {
        StringBuilder stringBuilder = new StringBuilder("-break-disable");
        Integer[] integerArray2 = integerArray;
        int n = integerArray2.length;
        for (int i = 0; i < n; ++i) {
            int n2 = integerArray2[i];
            stringBuilder.append(' ');
            stringBuilder.append(n2);
        }
        return this.engine.createMICommand(stringBuilder.toString());
    }

    public MICommand break_conditionCMD(int n, String string) {
        return this.engine.createMICommand("-break-condition " + Integer.toString(n) + " " + string);
    }

    public MICommand break_afterCMD(int n, int n2) {
        return this.engine.createMICommand("-break-after " + Integer.toString(n) + " " + Integer.toString(n2));
    }

    public void stack_list_locals() {
        this.stack_list_locals("");
    }

    public void stack_list_locals(String string) {
        this.engine.sendCommand("-stack-list-locals " + string);
    }

    public void stack_list_arguments(int n, int n2, int n3) {
        this.engine.sendCommand("-stack-list-arguments " + n + " " + n2 + " " + n3);
    }

    public void stack_list_arguments(int n) {
        this.engine.sendCommand("-stack-list-arguments " + n);
    }

    public void stack_select_frame(int n) {
        this.engine.sendCommand("-stack-select-frame " + n);
    }

    public void up_silently(int n) {
        this.engine.sendCommand("up-silently " + n);
    }

    public void stack_info_frame() {
        this.engine.sendCommand("-stack-info-frame ");
    }

    public void stack_list_frames() {
        this.engine.sendCommand("-stack-list-frames ");
    }

    public CommandBuffer stack_list_framesEx() {
        return this.engine.sendCommandEx("-stack-list-frames ");
    }

    public void gdb_set(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("-gdb-set ");
        stringBuilder.append(string);
        stringBuilder.append(' ');
        stringBuilder.append(string2);
        this.engine.sendCommand(stringBuilder.toString());
    }

    public void set_new_console() {
        this.engine.sendCommand("set new-console");
    }

    public void set_unwindonsignal(String string) {
        this.engine.sendCommand("set unwindonsignal " + string);
    }

    public CommandBuffer symbol_type(String string) {
        return this.engine.sendCommandEx("ptype " + string);
    }

    public CommandBuffer whatis(String string) {
        return this.engine.sendCommandEx("whatis " + string);
    }

    public void handle(String string, HandleAction handleAction) {
        this.engine.sendCommand("handle " + string + " " + (Object)((Object)handleAction));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gdb_exit() {
        this.engine.sendCommand("-gdb-exit ");
        this.engine.stopSending();
        Map<Integer, CommandBuffer> map = this.map;
        synchronized (map) {
            for (CommandBuffer commandBuffer : this.map.values()) {
                commandBuffer.error("gdb finished");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HandleAction {
        nostop,
        stop,
        print,
        noprint,
        pass,
        nopass;

    }
}

