/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.metadata.model.jdbc;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.netbeans.modules.db.metadata.model.api.ForeignKeyColumn;
import org.netbeans.modules.db.metadata.model.api.Table;
import org.netbeans.modules.db.metadata.model.spi.ForeignKeyImplementation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCForeignKey
extends ForeignKeyImplementation {
    private final Table parent;
    private final String name;
    private final Map<String, ForeignKeyColumn> columns = new LinkedHashMap<String, ForeignKeyColumn>();
    private final String internalName;
    private static AtomicLong fkeyCounter = new AtomicLong(0L);

    public JDBCForeignKey(Table table, String string) {
        this.parent = table;
        this.name = string;
        this.internalName = table.getName() + "_FKEY_" + fkeyCounter.incrementAndGet();
    }

    public void addColumn(ForeignKeyColumn foreignKeyColumn) {
        this.columns.put(foreignKeyColumn.getName(), foreignKeyColumn);
    }

    @Override
    public final Table getParent() {
        return this.parent;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public String toString() {
        return "JDBCForeignKey[name='" + this.name + "']";
    }

    @Override
    public Collection<ForeignKeyColumn> getColumns() {
        return this.columns.values();
    }

    @Override
    public ForeignKeyColumn getColumn(String string) {
        return this.columns.get(string);
    }

    @Override
    public String getInternalName() {
        return this.internalName;
    }
}

