/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.classpath;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.project.ui.ClassPathUiSupport;
import org.netbeans.spi.java.project.classpath.ProjectClassPathModifierImplementation;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathModifierSupport {
    public static final int ADD = 1;
    public static final int ADD_NO_HEURISTICS = 3;
    public static final int REMOVE = 2;
    private static final Logger LOG = Logger.getLogger(ClassPathModifierSupport.class.getName());

    public static boolean handleRoots(final Project project, final AntProjectHelper antProjectHelper, final ClassPathSupport classPathSupport, final PropertyEvaluator propertyEvaluator, final ClassPathUiSupport.Callback callback, final URI[] uRIArray, final String string, final String string2, final int n) throws IOException {
        assert (uRIArray != null) : "The classPathRoots cannot be null";
        assert (string != null);
        try {
            return (Boolean)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                public Boolean run() throws Exception {
                    EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                    String string3 = editableProperties.getProperty(string);
                    List<ClassPathSupport.Item> list = classPathSupport.itemsList(string3, string2);
                    boolean bl = false;
                    File file = FileUtil.toFile((FileObject)antProjectHelper.getProjectDirectory());
                    for (int i = 0; i < uRIArray.length; ++i) {
                        String string22;
                        Object object;
                        if (3 == n || 2 == n || !uRIArray[i].isAbsolute()) {
                            object = LibrariesSupport.getArchiveFile((URI)uRIArray[i]);
                            if (object == null) {
                                object = uRIArray[i];
                            }
                            string22 = LibrariesSupport.convertURIToFilePath((URI)object);
                        } else {
                            string22 = Accessor.performHeuristics(uRIArray[i], antProjectHelper);
                        }
                        object = string22;
                        if (((String)object).startsWith("${var.")) {
                            object = propertyEvaluator.evaluate(string22);
                        }
                        ClassPathSupport.Item item = ClassPathSupport.Item.create((String)object, file, null, string22.startsWith("${var.") ? string22 : null);
                        if (callback != null) {
                            callback.initItem(item);
                        }
                        if (!(n != 1 && n != 3 || list.contains(item))) {
                            list.add(item);
                            bl = true;
                            continue;
                        }
                        if (n != 2) continue;
                        if (list.remove(item)) {
                            bl = true;
                            continue;
                        }
                        Iterator<ClassPathSupport.Item> iterator = list.iterator();
                        while (iterator.hasNext()) {
                            ClassPathSupport.Item item2 = iterator.next();
                            if (!item2.isBroken() || item2.getType() != 0 || !string22.equals(item2.getFilePath()) && !string22.equals(item2.getVariableBasedProperty())) continue;
                            iterator.remove();
                            bl = true;
                        }
                    }
                    if (bl) {
                        String[] stringArray = classPathSupport.encodeToStrings(list, string2);
                        editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                        editableProperties.setProperty(string, stringArray);
                        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                        ProjectManager.getDefault().saveProject(project);
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            IOException iOException = new IOException();
            iOException.initCause(exception);
            throw iOException;
        }
    }

    public static boolean handleAntArtifacts(final Project project, final AntProjectHelper antProjectHelper, final ClassPathSupport classPathSupport, PropertyEvaluator propertyEvaluator, final ClassPathUiSupport.Callback callback, final AntArtifact[] antArtifactArray, final URI[] uRIArray, final String string, final String string2, final int n) throws IOException, UnsupportedOperationException {
        assert (antArtifactArray != null) : "Artifacts cannot be null";
        assert (uRIArray != null) : "ArtifactElements cannot be null";
        assert (antArtifactArray.length == uRIArray.length) : "Each artifact has to have corresponding artifactElement";
        assert (string != null);
        try {
            return (Boolean)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                public Boolean run() throws Exception {
                    EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                    String string3 = editableProperties.getProperty(string);
                    List<ClassPathSupport.Item> list = classPathSupport.itemsList(string3, string2);
                    boolean bl = false;
                    for (int i = 0; i < antArtifactArray.length; ++i) {
                        assert (antArtifactArray[i] != null);
                        assert (uRIArray[i] != null);
                        ClassPathSupport.Item item = ClassPathSupport.Item.create(antArtifactArray[i], uRIArray[i], null);
                        if (callback != null) {
                            callback.initItem(item);
                        }
                        if (n == 1 && !list.contains(item)) {
                            list.add(item);
                            bl = true;
                            continue;
                        }
                        if (n != 2 || !list.contains(item)) continue;
                        list.remove(item);
                        bl = true;
                    }
                    if (bl) {
                        String[] stringArray = classPathSupport.encodeToStrings(list, string2);
                        editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                        editableProperties.setProperty(string, stringArray);
                        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                        ProjectManager.getDefault().saveProject(project);
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            IOException iOException = new IOException();
            iOException.initCause(exception);
            throw iOException;
        }
    }

    public static boolean handleLibraries(Project project, AntProjectHelper antProjectHelper, ClassPathSupport classPathSupport, PropertyEvaluator propertyEvaluator, ClassPathUiSupport.Callback callback, ReferenceHelper referenceHelper, Library[] libraryArray, String string, String string2, int n) throws IOException, UnsupportedOperationException {
        ArrayList<ClassPathSupport.Item> arrayList = new ArrayList<ClassPathSupport.Item>(libraryArray.length);
        for (int i = 0; i < libraryArray.length; ++i) {
            Library library = ClassPathModifierSupport.checkLibrarySharability(project, antProjectHelper, referenceHelper, libraryArray[i]);
            ClassPathSupport.Item item = ClassPathSupport.Item.create(library, null);
            if (callback != null) {
                callback.initItem(item);
            }
            arrayList.add(item);
        }
        return ClassPathModifierSupport.handleLibraryClassPathItems(project, antProjectHelper, classPathSupport, arrayList, string, string2, n, true);
    }

    private static Library checkLibrarySharability(Project project, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper, Library library) throws IOException {
        if (antProjectHelper.isSharableProject()) {
            if (library.getManager().getLocation() == null) {
                LOG.log(Level.FINE, "Client is adding global library [" + library + "] to sharable project.", new Exception());
                Library library2 = referenceHelper.getProjectLibraryManager().getLibrary(library.getName());
                library = library2 != null ? library2 : referenceHelper.copyLibrary(library);
            } else if (!library.getManager().getLocation().equals(referenceHelper.getProjectLibraryManager().getLocation())) {
                throw new UnsupportedOperationException("Adding library '" + library.getName() + "' from '" + library.getManager().getLocation() + "' to project '" + project.getProjectDirectory() + "' is not supported because project libraries are defined in '" + referenceHelper.getProjectLibraryManager().getLocation() + "'");
            }
        }
        return library;
    }

    public static boolean handleLibraryClassPathItems(final Project project, final AntProjectHelper antProjectHelper, final ClassPathSupport classPathSupport, final List<ClassPathSupport.Item> list, final String string, final String string2, final int n, final boolean bl) throws IOException {
        assert (list != null) : "Libraries cannot be null";
        assert (string != null);
        assert (bl || ProjectManager.mutex().isWriteAccess());
        try {
            return (Boolean)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                public Boolean run() throws IOException {
                    EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                    String string3 = editableProperties.getProperty(string);
                    List<ClassPathSupport.Item> list2 = classPathSupport.itemsList(string3, string2);
                    ArrayList<ClassPathSupport.Item> arrayList = new ArrayList<ClassPathSupport.Item>(list.size());
                    for (ClassPathSupport.Item item : list) {
                        assert (item != null);
                        assert (item.getType() == 1);
                        if (n == 1 && !list2.contains(item)) {
                            list2.add(item);
                            arrayList.add(item);
                            continue;
                        }
                        if (n != 2 || !list2.contains(item)) continue;
                        list2.remove(item);
                        arrayList.add(item);
                    }
                    if (!arrayList.isEmpty()) {
                        String[] stringArray = classPathSupport.encodeToStrings(list2, string2);
                        editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
                        editableProperties.setProperty(string, stringArray);
                        antProjectHelper.putProperties("nbproject/project.properties", editableProperties);
                        if (bl) {
                            ProjectManager.getDefault().saveProject(project);
                        }
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    private static class Accessor
    extends ProjectClassPathModifierImplementation {
        private Accessor() {
        }

        public static String performHeuristics(URI uRI, AntProjectHelper antProjectHelper) throws URISyntaxException, IOException {
            Accessor accessor = new Accessor();
            return accessor.performSharabilityHeuristics(uRI, antProjectHelper);
        }

        protected SourceGroup[] getExtensibleSourceGroups() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected String[] getExtensibleClassPathTypes(SourceGroup sourceGroup) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected boolean addLibraries(Library[] libraryArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected boolean removeLibraries(Library[] libraryArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected boolean addRoots(URL[] uRLArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected boolean removeRoots(URL[] uRLArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected boolean addAntArtifacts(AntArtifact[] antArtifactArray, URI[] uRIArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected boolean removeAntArtifacts(AntArtifact[] antArtifactArray, URI[] uRIArray, SourceGroup sourceGroup, String string) throws IOException, UnsupportedOperationException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

