/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.BinaryForSourceQuery;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.spi.java.queries.BinaryForSourceQueryImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;

final class BinaryForSourceQueryImpl
implements BinaryForSourceQueryImplementation {
    private final Map<URL, BinaryForSourceQuery.Result> cache = new HashMap<URL, BinaryForSourceQuery.Result>();
    private final SourceRoots src;
    private final SourceRoots test;
    private final PropertyEvaluator eval;
    private final AntProjectHelper helper;
    private String[] sourceProps;
    private String[] testProps;

    BinaryForSourceQueryImpl(SourceRoots sourceRoots, SourceRoots sourceRoots2, AntProjectHelper antProjectHelper, PropertyEvaluator propertyEvaluator, String[] stringArray, String[] stringArray2) {
        assert (sourceRoots != null);
        assert (sourceRoots2 != null);
        assert (antProjectHelper != null);
        assert (propertyEvaluator != null);
        assert (stringArray != null && stringArray.length > 0);
        assert (stringArray2 != null && stringArray2.length > 0);
        this.src = sourceRoots;
        this.test = sourceRoots2;
        this.eval = propertyEvaluator;
        this.helper = antProjectHelper;
        this.sourceProps = stringArray;
        this.testProps = stringArray2;
    }

    public BinaryForSourceQuery.Result findBinaryRoots(URL uRL) {
        assert (uRL != null);
        BinaryForSourceQuery.Result result = this.cache.get(uRL);
        if (result == null) {
            for (URL uRL2 : this.src.getRootURLs()) {
                if (!uRL2.equals(uRL)) continue;
                result = new R(this.sourceProps);
                this.cache.put(uRL, result);
                return result;
            }
            for (URL uRL2 : this.test.getRootURLs()) {
                if (!uRL2.equals(uRL)) continue;
                result = new R(this.testProps);
                this.cache.put(uRL, result);
                return result;
            }
            String string = this.eval.getProperty("build.generated.sources.dir");
            if (string != null) {
                String string2 = this.helper.resolveFile(string).toURI().toString();
                if (uRL.toString().startsWith(string2)) {
                    result = new R(this.sourceProps);
                    this.cache.put(uRL, result);
                    return result;
                }
            }
        }
        return result;
    }

    class R
    implements BinaryForSourceQuery.Result,
    PropertyChangeListener {
        private final String[] propNames;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

        R(String[] stringArray) {
            assert (stringArray != null && stringArray.length > 0);
            this.propNames = stringArray;
            BinaryForSourceQueryImpl.this.eval.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public URL[] getRoots() {
            ArrayList<URL> arrayList = new ArrayList<URL>();
            for (String string : this.propNames) {
                String string2 = BinaryForSourceQueryImpl.this.eval.getProperty(string);
                if (string2 == null) continue;
                arrayList.add(FileUtil.urlForArchiveOrDir((File)BinaryForSourceQueryImpl.this.helper.resolveFile(string2)));
            }
            return arrayList.toArray(new URL[arrayList.size()]);
        }

        public void addChangeListener(ChangeListener changeListener) {
            assert (changeListener != null);
            this.changeSupport.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            assert (changeListener != null);
            this.changeSupport.removeChangeListener(changeListener);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.changeSupport.fireChange();
        }
    }
}

