/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output;

import java.awt.Dimension;
import java.awt.Toolkit;
import org.netbeans.modules.db.dataview.output.DataView;
import org.netbeans.modules.db.dataview.output.DataViewPageContext;
import org.netbeans.modules.db.dataview.output.DataViewTableUI;
import org.netbeans.modules.db.dataview.output.DataViewUI;
import org.netbeans.modules.db.dataview.output.InsertRecordDialog;
import org.netbeans.modules.db.dataview.output.SQLExecutionHelper;
import org.netbeans.modules.db.dataview.output.UpdatedRowContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

class DataViewActionHandler {
    private final DataViewPageContext dataPage;
    private final SQLExecutionHelper execHelper;
    private final DataViewUI dataViewUI;
    private final DataView dataView;

    DataViewActionHandler(DataViewUI dataViewUI, DataView dataView) {
        this.dataView = dataView;
        this.dataViewUI = dataViewUI;
        this.dataPage = dataView.getDataViewPageContext();
        this.execHelper = dataView.getSQLExecutionHelper();
    }

    private boolean rejectModifications() {
        String string;
        boolean bl = true;
        if (this.dataViewUI.isCommitEnabled() && DataViewActionHandler.showYesAllDialog(string = NbBundle.getMessage(DataViewActionHandler.class, (String)"MSG_confirm_commit_changes"), NbBundle.getMessage(DataViewActionHandler.class, (String)"MSG_confirm_navigation")).equals(NotifyDescriptor.NO_OPTION)) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelEditPerformed(boolean bl) {
        DataView dataView = this.dataView;
        synchronized (dataView) {
            if (bl) {
                DataViewTableUI dataViewTableUI = this.dataViewUI.getDataViewTableUI();
                UpdatedRowContext updatedRowContext = this.dataView.getUpdatedRowContext();
                int[] nArray = dataViewTableUI.getSelectedRows();
                for (int i = 0; i < nArray.length; ++i) {
                    int n = nArray[i];
                    int n2 = dataViewTableUI.getColumnCount();
                    for (int j = 0; j < n2; ++j) {
                        this.dataViewUI.resetValueAt(n, j);
                    }
                    updatedRowContext.removeUpdateForSelectedRow(n);
                }
                if (updatedRowContext.getUpdateKeys().isEmpty()) {
                    this.dataViewUI.setCancelEnabled(false);
                    this.dataViewUI.setCommitEnabled(false);
                }
            } else {
                this.dataView.getUpdatedRowContext().removeAllUpdates();
                this.dataView.setRowsInTableModel();
                this.dataViewUI.setCancelEnabled(false);
                this.dataViewUI.setCommitEnabled(false);
            }
        }
    }

    void setMaxActionPerformed() {
        if (this.rejectModifications()) {
            int n = this.dataViewUI.getPageSize();
            this.dataPage.setPageSize(n);
            this.dataPage.first();
            this.dataPage.setTotalRows(-1);
            this.execHelper.executeQuery();
        }
    }

    void firstActionPerformed() {
        if (this.rejectModifications()) {
            this.dataPage.first();
            this.execHelper.executeQuery();
        }
    }

    void previousActionPerformed() {
        if (this.rejectModifications()) {
            this.dataPage.previous();
            this.execHelper.executeQuery();
        }
    }

    void nextActionPerformed() {
        if (this.rejectModifications()) {
            this.dataPage.next();
            this.execHelper.executeQuery();
        }
    }

    void lastActionPerformed() {
        if (this.rejectModifications()) {
            this.dataPage.last();
            this.execHelper.executeQuery();
        }
    }

    void commitActionPerformed(boolean bl) {
        if (this.dataViewUI.isDirty()) {
            this.execHelper.executeUpdateRow(this.dataViewUI.getDataViewTableUI(), bl);
        }
    }

    void insertActionPerformed() {
        InsertRecordDialog insertRecordDialog = new InsertRecordDialog(this.dataView);
        insertRecordDialog.setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        insertRecordDialog.setMinimumSize(new Dimension((dimension.width - 50) / 2, (dimension.height - 50) / 2));
        insertRecordDialog.setVisible(true);
    }

    void truncateActionPerformed() {
        String string = NbBundle.getMessage(DataViewActionHandler.class, (String)"MSG_confirm_truncate_table") + this.dataView.getDataViewDBTable().geTable(0).getDisplayName();
        if (DataViewActionHandler.showYesAllDialog(string, string).equals(NotifyDescriptor.YES_OPTION)) {
            this.execHelper.executeTruncate();
        }
    }

    void deleteRecordActionPerformed() {
        DataViewTableUI dataViewTableUI = this.dataViewUI.getDataViewTableUI();
        if (dataViewTableUI.getSelectedRowCount() == 0) {
            String string = NbBundle.getMessage(DataViewActionHandler.class, (String)"MSG_select_delete_rows");
            this.dataView.setInfoStatusText(string);
        } else {
            String string = NbBundle.getMessage(DataViewActionHandler.class, (String)"MSG_confirm_permanent_delete");
            if (DataViewActionHandler.showYesAllDialog(string, NbBundle.getMessage(DataViewActionHandler.class, (String)"MSG_confirm_delete")).equals(NotifyDescriptor.YES_OPTION)) {
                this.execHelper.executeDeleteRow(dataViewTableUI);
            }
        }
    }

    void refreshActionPerformed() {
        this.dataPage.setTotalRows(-1);
        this.execHelper.executeQuery();
    }

    private static Object showYesAllDialog(Object object, String string) {
        NotifyDescriptor notifyDescriptor = new NotifyDescriptor(object, string, 0, 3, null, NotifyDescriptor.NO_OPTION);
        DialogDisplayer.getDefault().notify(notifyDescriptor);
        return notifyDescriptor.getValue();
    }
}

