/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.border.IconBorder;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.decorator.PipelineEvent;
import org.jdesktop.swingx.decorator.PipelineListener;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.jdesktop.swingx.table.TableColumnExt;
import org.netbeans.modules.db.dataview.table.JXTableDecorator;
import org.netbeans.modules.db.dataview.table.ResultSetJXTable;

public class JXTableRowHeader
extends JComponent {
    private static Icon rightArrow = new Icon(){

        public int getIconWidth() {
            return 8;
        }

        public int getIconHeight() {
            return 8;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.drawLine(n + 4, n2 + 4, n + 4, n2 + 4);
            graphics.translate(n + 4, n2 + 4);
            graphics.fillPolygon(new Polygon(new int[]{0, 5, 0}, new int[]{-5, 0, 5}, 3));
        }
    };
    private IconBorder iconBorder = new IconBorder();
    private final JXTableDecorator headerTable;
    private JTable table;

    public JTableHeader getTableHeader() {
        JTableHeader jTableHeader = this.headerTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setResizingAllowed(false);
        return jTableHeader;
    }

    public JXTableRowHeader(JTable jTable) {
        this.table = jTable;
        this.headerTable = new JXTableDecorator(jTable.getModel(), new InternalTableColumnModel(), jTable.getSelectionModel()){

            public Object getValueAt(int n, int n2) {
                return JXTableRowHeader.this.getRowName(n);
            }
        };
        this.setLayout(new GridLayout(1, 1));
        this.headerTable.getModel().addTableModelListener(new HeaderResizeListener());
        this.headerTable.setAutoResizeMode(0);
        this.headerTable.getTableHeader().setReorderingAllowed(false);
        this.headerTable.getTableHeader().setResizingAllowed(false);
        this.headerTable.setSortable(false);
        this.add((Component)((Object)this.headerTable));
        TableColumn tableColumn = this.headerTable.getColumnModel().getColumn(0);
        this.headerTable.packAll();
        tableColumn.setPreferredWidth(tableColumn.getPreferredWidth() + 20);
        tableColumn.setCellRenderer(this.createDefaultRenderer());
        this.headerTable.setPreferredScrollableViewportSize(new Dimension(tableColumn.getPreferredWidth(), 0));
        this.headerTable.setInheritsPopupMenu(true);
        this.headerTable.setRowHeight(jTable.getRowHeight());
        this.headerTable.setShowGrid(true, true);
        this.headerTable.setGridColor(ResultSetJXTable.GRID_COLOR);
        this.headerTable.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)Color.WHITE, (Color)ResultSetJXTable.ALTERNATE_ROW_COLOR)});
        JXTable jXTable = (JXTable)jTable;
        jXTable.getFilters().addPipelineListener(new PipelineListener(){

            public void contentsChanged(PipelineEvent pipelineEvent) {
                FilterPipeline filterPipeline = (FilterPipeline)pipelineEvent.getSource();
                JXTableRowHeader.this.headerTable.getFilters().getSortController().setSortKeys(filterPipeline.getSortController().getSortKeys());
                JXTableRowHeader.this.headerTable.getTableHeader().repaint();
            }
        });
    }

    protected TableCellRenderer createDefaultRenderer() {
        return new RowHeaderColumnRenderer();
    }

    public void setDefaultRenderer(TableCellRenderer tableCellRenderer) {
        this.headerTable.getColumn(0).setCellRenderer(tableCellRenderer);
    }

    public TableCellRenderer getDefaultRenderer() {
        return this.headerTable.getColumn(0).getCellRenderer();
    }

    public Rectangle getHeaderRect(int n) {
        return this.headerTable.getCellRect(n, 0, true);
    }

    public void setTable(JTable jTable) {
        this.table = jTable;
        this.headerTable.setModel(jTable.getModel());
        this.headerTable.setSelectionModel(jTable.getSelectionModel());
    }

    public JTable getTable() {
        return this.table;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        return this.headerTable.getToolTipText(mouseEvent);
    }

    public int rowAtPoint(Point point) {
        return this.headerTable.rowAtPoint(point);
    }

    public String getRowName(int n) {
        return Integer.toString(n + 1);
    }

    private class RowHeaderColumnRenderer
    extends DefaultTableRenderer {
        private RowHeaderColumnRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (bl) {
                JXTableRowHeader.this.iconBorder.setIcon(rightArrow);
                Border border = ((JComponent)component).getBorder();
                CompoundBorder compoundBorder = new CompoundBorder(border, (Border)JXTableRowHeader.this.iconBorder);
                ((JComponent)component).setBorder(compoundBorder);
                component.setBackground(UIManager.getColor("Table.selectionBackground"));
                component.setForeground(UIManager.getColor("Table.selectionForeground"));
            }
            return component;
        }
    }

    private class HeaderResizeListener
    implements TableModelListener {
        private HeaderResizeListener() {
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            JXTableRowHeader.this.headerTable.packAll();
            TableColumn tableColumn = JXTableRowHeader.this.headerTable.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(tableColumn.getPreferredWidth() + 20);
            if (tableColumn.getPreferredWidth() != JXTableRowHeader.this.getWidth()) {
                JXTableRowHeader.this.headerTable.setPreferredScrollableViewportSize(new Dimension(tableColumn.getPreferredWidth(), 0));
            }
        }
    }

    private static class InternalTableColumnModel
    extends DefaultTableColumnModel {
        public InternalTableColumnModel() {
            TableColumnExt tableColumnExt = new TableColumnExt(0, 75);
            tableColumnExt.setEditable(false);
            tableColumnExt.setHeaderValue((Object)"#");
            tableColumnExt.setToolTipText("Row Number");
            tableColumnExt.setSortable(false);
            this.addColumn((TableColumn)tableColumnExt);
        }
    }
}

