/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import javax.swing.table.DefaultTableModel;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.table.ResultSetJXTable;
import org.netbeans.modules.db.dataview.util.DBReadWriteHelper;
import org.netbeans.modules.db.dataview.util.DataViewUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class ResultSetTableModel
extends DefaultTableModel {
    private Class[] collumnClasses;
    protected ResultSetJXTable table;

    public static Class getTypeClass(DBColumn dBColumn) {
        int n = dBColumn.getJdbcType();
        if (n == -7 && dBColumn.getPrecision() <= 1) {
            n = 16;
        }
        switch (n) {
            case 16: {
                return Boolean.class;
            }
            case 92: {
                return Time.class;
            }
            case 91: {
                return Date.class;
            }
            case -100: 
            case 93: {
                return Timestamp.class;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return Number.class;
            }
            case -16: 
            case -15: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                return String.class;
            }
        }
        return Object.class;
    }

    public ResultSetTableModel(ResultSetJXTable resultSetJXTable) {
        this.table = resultSetJXTable;
        this.collumnClasses = new Class[resultSetJXTable.getRSColumnCount()];
        int n = resultSetJXTable.getRSColumnCount();
        for (int i = 0; i < n; ++i) {
            this.collumnClasses[i] = ResultSetTableModel.getTypeClass(resultSetJXTable.getDBColumn(i));
        }
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (this.table.dView.getDataViewDBTable() == null) {
            return;
        }
        Object object2 = this.getValueAt(n, n2);
        if (this.noUpdateRequired(object2, object)) {
            return;
        }
        try {
            if (!DataViewUtils.isSQLConstantString(object)) {
                object = DBReadWriteHelper.validate(object, this.table.getDBColumn(n2));
            }
            super.setValueAt(object, n, n2);
            this.handleColumnUpdated(n, n2, object);
            this.fireTableDataChanged();
        }
        catch (Exception exception) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)exception.getMessage(), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
        this.table.revalidate();
        this.table.repaint();
    }

    public Class getColumnClass(int n) {
        if (this.collumnClasses[n] == null) {
            return super.getColumnClass(n);
        }
        return this.collumnClasses[n];
    }

    protected boolean noUpdateRequired(Object object, Object object2) {
        return object != null && object.toString().equals(object2 == null ? "" : object2.toString()) || object == null && object2 == null;
    }

    protected void handleColumnUpdated(int n, int n2, Object object) {
    }
}

