/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.util;

import org.netbeans.modules.db.dataview.meta.DBException;

public class BinaryToStringConverter {
    public static final int BINARY = 2;
    public static final int DECIMAL = 10;
    public static final int HEX = 16;
    public static final int OCTAL = 8;
    static ConversionConstants decimal = new ConversionConstants(3, 10);
    static ConversionConstants hex = new ConversionConstants(2, 16);
    private static ConversionConstants binary = new ConversionConstants(8, 2);
    private static ConversionConstants octal = new ConversionConstants(3, 8);
    private static String printable = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ`~!@#$%^&*()-_=+[{]}\\|;:'\",<.>/? ";

    public static String convertToString(Byte[] byteArray, int n, boolean bl) {
        if (byteArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(20);
        ConversionConstants conversionConstants = BinaryToStringConverter.getConstants(n);
        for (int i = 0; i < byteArray.length; ++i) {
            int n2 = byteArray[i].byteValue();
            String string = null;
            if (bl && printable.indexOf((char)n2) > -1) {
                string = new Character((char)n2) + "          ".substring(10 - (conversionConstants.width - 1));
            }
            if (string == null) {
                switch (n) {
                    case 10: {
                        if (n2 < 0) {
                            n2 = 256 + n2;
                        }
                        string = Integer.toString(n2);
                        break;
                    }
                    case 8: {
                        string = Integer.toOctalString(n2);
                        break;
                    }
                    case 2: {
                        string = Integer.toBinaryString(n2);
                        break;
                    }
                    default: {
                        string = Integer.toHexString(n2);
                    }
                }
                if (string.length() > conversionConstants.width) {
                    string = string.substring(string.length() - conversionConstants.width);
                }
                if (string.length() < conversionConstants.width) {
                    stringBuilder.append("00000000".substring(8 - (conversionConstants.width - string.length())));
                }
            }
            stringBuilder.append(bl ? string.trim() : string);
        }
        return stringBuilder.toString();
    }

    private static ConversionConstants getConstants(int n) {
        switch (n) {
            case 10: {
                return decimal;
            }
            case 8: {
                return octal;
            }
            case 2: {
                return binary;
            }
        }
        return hex;
    }

    public static byte[] convertBitStringToBytes(String string) throws DBException {
        int n = string.length() % 8;
        string = n > 0 ? "00000000".substring(0, 8 - n) + string : string;
        byte[] byArray = new byte[string.length() / 8];
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if ('1' == string.charAt(i)) {
                int n4 = 1 << 7 - n2;
                int n5 = n3;
                byArray[n5] = (byte)(byArray[n5] | n4);
            } else if ('0' != string.charAt(i)) {
                throw new DBException(string.charAt(i) + "found at character " + i + "; 0 or 1 expected. ");
            }
            if (++n2 <= 7) continue;
            n2 = 0;
            ++n3;
        }
        return byArray;
    }

    private BinaryToStringConverter() {
    }

    static class ConversionConstants {
        int radix;
        int width;

        ConversionConstants(int n, int n2) {
            this.width = n;
            this.radix = n2;
        }
    }
}

