/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.util;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.meta.DBForeignKey;
import org.netbeans.modules.db.dataview.meta.DBTable;
import org.openide.util.NbBundle;

public class DataViewUtils {
    public static final String[] HTML_ALLOWABLES = new String[]{"&amp;", "&quot;", "&lt;", "&gt;"};
    public static final String[] HTML_ILLEGALS = new String[]{"&", "\"", "<", ">"};

    public static boolean isNumeric(int n) {
        switch (n) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    public static boolean isPrecisionRequired(int n, boolean bl) {
        if (bl && n == 2004 || n == 2005) {
            return true;
        }
        return DataViewUtils.isPrecisionRequired(n);
    }

    public static boolean isPrecisionRequired(int n) {
        switch (n) {
            case -6: 
            case -5: 
            case -4: 
            case -1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 70: 
            case 91: 
            case 93: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: {
                return false;
            }
        }
        return true;
    }

    public static boolean isScaleRequired(int n) {
        switch (n) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBinary(int n) {
        switch (n) {
            case -4: 
            case -3: 
            case -2: {
                return true;
            }
        }
        return false;
    }

    public static boolean isString(int n) {
        switch (n) {
            case -16: 
            case -15: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSQLConstantString(Object object) {
        return object == null || object instanceof String && ((String)object).startsWith("<") && ((String)object).endsWith(">");
    }

    public static boolean isNullString(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static void closeResources(PreparedStatement preparedStatement) {
        try {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void closeResources(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeResources(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static String getColumnToolTip(DBColumn dBColumn) {
        boolean bl = dBColumn.isPrimaryKey();
        boolean bl2 = dBColumn.isForeignKey();
        boolean bl3 = dBColumn.isNullable();
        boolean bl4 = dBColumn.isGenerated();
        StringBuilder stringBuilder = new StringBuilder("<html> <table border=0 cellspacing=0 cellpadding=0 >");
        stringBuilder.append("<tr> <td>&nbsp;").append(NbBundle.getMessage(DataViewUtils.class, (String)"TOOLTIP_column_name")).append("</td> <td> &nbsp; : &nbsp; <b>");
        stringBuilder.append(dBColumn.getName()).append("</b> </td> </tr>");
        stringBuilder.append("<tr> <td>&nbsp;").append(NbBundle.getMessage(DataViewUtils.class, (String)"TOOLTIP_column_type")).append("</td> <td> &nbsp; : &nbsp; <b>");
        stringBuilder.append(dBColumn.getTypeName()).append("</b> </td> </tr>");
        if (DataViewUtils.isString(dBColumn.getJdbcType())) {
            stringBuilder.append("<tr> <td>&nbsp;").append(NbBundle.getMessage(DataViewUtils.class, (String)"TOOLTIP_column_length")).append("</td> <td> &nbsp; : &nbsp; <b>");
        } else {
            stringBuilder.append("<tr> <td>&nbsp;").append(NbBundle.getMessage(DataViewUtils.class, (String)"TOOLTIP_column_precision")).append("</td> <td> &nbsp; : &nbsp; <b>");
        }
        stringBuilder.append(dBColumn.getPrecision()).append("</b> </td> </tr>");
        if (DataViewUtils.isScaleRequired(dBColumn.getJdbcType())) {
            stringBuilder.append("<tr> <td>&nbsp;").append(NbBundle.getMessage(DataViewUtils.class, (String)"TOOLTIP_column_scale")).append("</td> <td> &nbsp; : &nbsp; <b>");
            stringBuilder.append(dBColumn.getScale()).append("</b> </td> </tr>");
        }
        if (bl) {
            stringBuilder.append("<tr> <td>&nbsp;").append(NbBundle.getMessage(DataViewUtils.class, (String)"TOOLTIP_column_PK")).append("</td> <td> &nbsp; : &nbsp; <b> Yes </b> </td> </tr>");
        }
        if (bl2) {
            stringBuilder.append("<tr> <td>&nbsp;").append(NbBundle.getMessage(DataViewUtils.class, (String)"TOOLTIP_column_FK")).append("</td> <td> &nbsp; : &nbsp; <b>" + DataViewUtils.getForeignKeyString(dBColumn)).append("</b>").append("</td> </tr>");
        }
        if (!bl3) {
            stringBuilder.append("<tr> <td>&nbsp;").append(NbBundle.getMessage(DataViewUtils.class, (String)"TOOLTIP_column_nullable")).append("</td> <td> &nbsp; : &nbsp; <b> No </b> </td> </tr>");
        }
        if (bl4) {
            stringBuilder.append("<tr> <td>&nbsp;").append(NbBundle.getMessage(DataViewUtils.class, (String)"TOOLTIP_column_generated")).append("</td> <td> &nbsp; : &nbsp; <b> Yes </b> </td> </tr>");
        }
        if (dBColumn.hasDefault()) {
            stringBuilder.append("<tr> <td>&nbsp;").append(NbBundle.getMessage(DataViewUtils.class, (String)"TOOLTIP_column_default")).append("</td> <td> &nbsp; : &nbsp; <b>").append(dBColumn.getDefaultValue()).append("</b> </td> </tr>");
        }
        stringBuilder.append("</table> </html>");
        return stringBuilder.toString();
    }

    public static String getForeignKeyString(DBColumn dBColumn) {
        String string = dBColumn.getName() + " --> ";
        StringBuilder stringBuilder = new StringBuilder(string);
        DBTable dBTable = (DBTable)dBColumn.getParentObject();
        List<DBForeignKey> list = dBTable.getForeignKeys();
        for (DBForeignKey dBForeignKey : list) {
            if (!dBForeignKey.contains(dBColumn)) continue;
            List<String> list2 = dBForeignKey.getPKColumnNames();
            Iterator<String> iterator = list2.iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                stringBuilder.append(string2);
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
        }
        return stringBuilder.toString();
    }

    public static String escapeHTML(String string) {
        return DataViewUtils.replaceInString(string, HTML_ILLEGALS, HTML_ALLOWABLES);
    }

    public static String replaceInString(String string, String[] stringArray, String[] stringArray2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            for (int j = 0; !bl && j < stringArray.length; ++j) {
                if (!string.startsWith(stringArray[j], i)) continue;
                stringBuffer.append(stringArray2[j]);
                bl = true;
                i += stringArray[j].length() - 1;
            }
            if (!bl) {
                stringBuffer.append(string.charAt(i));
                continue;
            }
            bl = false;
        }
        return stringBuffer.toString();
    }

    private DataViewUtils() {
    }
}

