/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.web.WebAppMetadata;
import org.netbeans.modules.j2ee.dd.api.web.model.ServletInfo;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.project.ProjectWebModule;
import org.netbeans.modules.web.project.WebAppMetadataHelper;
import org.netbeans.modules.web.project.ui.ServletScanObserver;
import org.netbeans.modules.web.project.ui.ServletUriPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SetExecutionUriAction
extends NodeAction {
    private static final String IS_SERVLET_FILE = "org.netbeans.modules.web.IsServletFile";
    public static final String ATTR_EXECUTION_URI = "execution.uri";
    private static final MarkerClass MARKER = new MarkerClass();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void performAction(Node[] nodeArray) {
        DataObject dataObject;
        if (nodeArray == null || nodeArray.length != 1 || nodeArray[0] == null || (dataObject = (DataObject)nodeArray[0].getCookie(DataObject.class)) == null) return;
        FileObject fileObject = dataObject.getPrimaryFile();
        WebModule webModule = WebModule.getWebModule((FileObject)fileObject);
        String[] stringArray = SetExecutionUriAction.getServletMappings(webModule, fileObject);
        if (stringArray != null && stringArray.length > 0) {
            String string = (String)fileObject.getAttribute(ATTR_EXECUTION_URI);
            ServletUriPanel servletUriPanel = new ServletUriPanel(stringArray, string, false);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)servletUriPanel, NbBundle.getMessage(SetExecutionUriAction.class, (String)"TTL_setServletExecutionUri"));
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (!object.equals(NotifyDescriptor.YES_OPTION)) return;
            try {
                fileObject.setAttribute(ATTR_EXECUTION_URI, (Object)servletUriPanel.getServletUri());
                return;
            }
            catch (IOException iOException) {}
            return;
        } else {
            String string = MessageFormat.format(NbBundle.getMessage(SetExecutionUriAction.class, (String)"TXT_missingServletMappings"), fileObject.getName());
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
    }

    protected boolean enable(Node[] nodeArray) {
        DataObject dataObject;
        if (nodeArray != null && nodeArray.length == 1 && nodeArray[0] != null && (dataObject = (DataObject)nodeArray[0].getCookie(DataObject.class)) != null) {
            FileObject fileObject = dataObject.getPrimaryFile();
            WebModule webModule = WebModule.getWebModule((FileObject)fileObject);
            if (SetExecutionUriAction.servletFilesScanning(webModule, fileObject)) {
                return false;
            }
            String string = fileObject.getMIMEType();
            if (!"text/x-java".equals(string)) {
                return false;
            }
            Boolean bl = (Boolean)fileObject.getAttribute(IS_SERVLET_FILE);
            if (!Boolean.TRUE.equals(bl)) {
                boolean bl2 = SetExecutionUriAction.isServletFile(webModule, fileObject, false);
                if (bl2) {
                    try {
                        fileObject.setAttribute(IS_SERVLET_FILE, (Object)Boolean.TRUE);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                bl = bl2;
            }
            return Boolean.TRUE.equals(bl);
        }
        return false;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(SetExecutionUriAction.class);
    }

    public String getName() {
        return NbBundle.getMessage(SetExecutionUriAction.class, (String)"LBL_serveltExecutionUriAction");
    }

    protected String iconResource() {
        return "org/netbeans/modules/web/project/ui/resources/servletUri.gif";
    }

    protected boolean asynchronous() {
        return false;
    }

    public static boolean isScanInProgress(WebModule webModule, FileObject fileObject, final ServletScanObserver servletScanObserver) {
        boolean bl;
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        ProjectWebModule projectWebModule = null;
        if (project != null) {
            projectWebModule = (ProjectWebModule)project.getLookup().lookup(ProjectWebModule.class);
        }
        boolean bl2 = bl = project != null;
        if (bl) {
            bl = SetExecutionUriAction.servletFilesScanning(webModule, fileObject);
            if (!bl) {
                return false;
            }
            final ProjectWebModule projectWebModule2 = projectWebModule;
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    MarkerClass markerClass;
                    String string = propertyChangeEvent.getPropertyName();
                    if ("lookup.item".equals(string) && propertyChangeEvent.getNewValue() != null && propertyChangeEvent.getNewValue() != MARKER && (markerClass = (MarkerClass)projectWebModule2.getLookup().lookup(MarkerClass.class)) != null && markerClass != MARKER && servletScanObserver != null) {
                        servletScanObserver.scanFinished();
                        projectWebModule2.removePropertyChangeListener(this);
                    }
                }
            };
            projectWebModule.addPropertyChangeListener(propertyChangeListener);
            bl = SetExecutionUriAction.servletFilesScanning(webModule, fileObject);
            if (!bl) {
                projectWebModule.removePropertyChangeListener(propertyChangeListener);
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static String[] getServletMappings(WebModule webModule, FileObject fileObject) {
        assert (SetExecutionUriAction.checkScanFinished(webModule, fileObject));
        if (webModule == null) {
            return null;
        }
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        String string = classPath.getResourceName(fileObject, '.', false);
        try {
            List<ServletInfo> list = WebAppMetadataHelper.getServlets((MetadataModel<WebAppMetadata>)webModule.getMetadataModel());
            ArrayList arrayList = new ArrayList();
            for (ServletInfo servletInfo : list) {
                if (!string.equals(servletInfo.getServletClass())) continue;
                arrayList.addAll(servletInfo.getUrlPatterns());
            }
            String[] stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            return stringArray;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private static boolean checkScanFinished(WebModule webModule, FileObject fileObject) {
        ProjectWebModule projectWebModule;
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null && (projectWebModule = (ProjectWebModule)project.getLookup().lookup(ProjectWebModule.class)) != null) {
            MarkerClass markerClass = (MarkerClass)projectWebModule.getLookup().lookup(MarkerClass.class);
            return markerClass != null && markerClass != MARKER;
        }
        return true;
    }

    private static boolean servletFilesScanning(final WebModule webModule, final FileObject fileObject) {
        ProjectWebModule projectWebModule;
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null && (projectWebModule = (ProjectWebModule)project.getLookup().lookup(ProjectWebModule.class)) != null) {
            MarkerClass markerClass = (MarkerClass)projectWebModule.getLookup().lookup(MarkerClass.class);
            if (markerClass == null) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        SetExecutionUriAction.isServletFile(webModule, fileObject, true);
                        projectWebModule.removeCookie(MARKER);
                        projectWebModule.addCookie(new MarkerClass());
                    }
                };
                if (projectWebModule.getLookup().lookup(MarkerClass.class) == null) {
                    RequestProcessor.getDefault().post(runnable);
                    projectWebModule.addCookie(MARKER);
                }
                return true;
            }
            return markerClass == MARKER;
        }
        return false;
    }

    private static boolean isServletFile(WebModule webModule, FileObject fileObject, boolean bl) {
        if (webModule == null) {
            return false;
        }
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        if (classPath == null) {
            return false;
        }
        String string = classPath.getResourceName(fileObject, '.', false);
        if (string == null) {
            return false;
        }
        try {
            MetadataModel metadataModel = webModule.getMetadataModel();
            boolean bl2 = false;
            if (bl || metadataModel.isReady()) {
                List<ServletInfo> list = WebAppMetadataHelper.getServlets((MetadataModel<WebAppMetadata>)metadataModel);
                ArrayList<String> arrayList = new ArrayList<String>(list.size());
                for (ServletInfo servletInfo : list) {
                    if (string.equals(servletInfo.getServletClass())) {
                        bl2 = true;
                        continue;
                    }
                    arrayList.add(servletInfo.getServletClass());
                }
                SetExecutionUriAction.setServletClasses(arrayList, fileObject, bl);
            }
            return bl2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    private static void setServletClasses(final List<String> list, final FileObject fileObject, boolean bl) {
        if (bl) {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            if (javaSource == null) {
                return;
            }
            try {
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        for (String string : list) {
                            ElementHandle elementHandle;
                            FileObject fileObject;
                            TypeElement typeElement = compilationController.getElements().getTypeElement(string);
                            if (typeElement == null || (fileObject = SourceUtils.getFile((ElementHandle)(elementHandle = ElementHandle.create((Element)typeElement)), (ClasspathInfo)compilationController.getClasspathInfo())) == null || Boolean.TRUE.equals(fileObject.getAttribute(SetExecutionUriAction.IS_SERVLET_FILE))) continue;
                            fileObject.setAttribute(SetExecutionUriAction.IS_SERVLET_FILE, (Object)Boolean.TRUE);
                        }
                    }
                }, true);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    SetExecutionUriAction.setServletClasses(list, fileObject, true);
                }
            };
            RequestProcessor.getDefault().post(runnable);
        }
    }

    private static class MarkerClass {
        private MarkerClass() {
        }
    }
}

