/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.modules.web.api.webmodule.ExtenderController;
import org.netbeans.modules.web.api.webmodule.WebFrameworks;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.modules.web.project.ui.customizer.AddFrameworkPanel;
import org.netbeans.modules.web.project.ui.customizer.WebProjectProperties;
import org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider;
import org.netbeans.modules.web.spi.webmodule.WebModuleExtender;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class CustomizerFrameworks
extends JPanel
implements HelpCtx.Provider,
ListSelectionListener {
    private final ProjectCustomizer.Category category;
    private WebProject project;
    private WebProjectProperties uiProperties;
    private List<WebModuleExtender> newExtenders = new LinkedList<WebModuleExtender>();
    private List<WebFrameworkProvider> usedFrameworks = new LinkedList<WebFrameworkProvider>();
    private Map<WebFrameworkProvider, WebModuleExtender> extenders = new IdentityHashMap<WebFrameworkProvider, WebModuleExtender>();
    private ExtenderController controller = ExtenderController.create();
    private boolean initialized = false;
    private JButton jButtonAdd;
    private JLabel jLabelConfig;
    private JLabel jLabelFrameworks;
    private JList jListFrameworks;
    private JPanel jPanelConfig;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;

    public CustomizerFrameworks(ProjectCustomizer.Category category, WebProjectProperties webProjectProperties) {
        this.category = category;
        this.uiProperties = webProjectProperties;
        this.initComponents();
        this.project = webProjectProperties.getProject();
        this.jListFrameworks.setModel(new DefaultListModel());
        ((DefaultListModel)this.jListFrameworks.getModel()).addElement(NbBundle.getMessage(CustomizerFrameworks.class, (String)"LBL_CustomizerFrameworks_Loading"));
        webProjectProperties.getLoadingFrameworksTask().addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        CustomizerFrameworks.this.initFrameworksList(CustomizerFrameworks.this.project.getAPIWebModule());
                    }
                });
            }
        });
        if (webProjectProperties.getLoadingFrameworksTask().isFinished()) {
            this.initFrameworksList(this.project.getAPIWebModule());
        }
    }

    private void initFrameworksList(WebModule webModule) {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        Profile profile = Profile.fromPropertiesString((String)this.uiProperties.getProject().evaluator().getProperty("j2ee.platform"));
        if (profile == null) {
            profile = Profile.JAVA_EE_6_WEB;
        }
        String string = this.uiProperties.getProject().evaluator().getProperty("j2ee.server.instance");
        ExtenderController.Properties properties = this.controller.getProperties();
        properties.setProperty("j2eeLevel", (Object)profile.toPropertiesString());
        properties.setProperty("serverInstanceID", (Object)string);
        this.jListFrameworks.setModel(new DefaultListModel());
        for (WebFrameworkProvider webFrameworkProvider : this.uiProperties.getCurrentFrameworks()) {
            this.usedFrameworks.add(webFrameworkProvider);
            ((DefaultListModel)this.jListFrameworks.getModel()).addElement(webFrameworkProvider.getName());
            WebModuleExtender webModuleExtender = webFrameworkProvider.createWebModuleExtender(webModule, this.controller);
            this.extenders.put(webFrameworkProvider, webModuleExtender);
            webModuleExtender.addChangeListener((ChangeListener)new ExtenderListener(webModuleExtender));
        }
        this.jListFrameworks.getSelectionModel().setSelectionMode(0);
        this.jListFrameworks.addListSelectionListener(this);
        if (this.usedFrameworks.size() > 0) {
            this.jListFrameworks.setSelectedIndex(0);
        }
        if (WebFrameworks.getFrameworks().size() == this.jListFrameworks.getModel().getSize()) {
            this.jButtonAdd.setEnabled(false);
        }
    }

    private void initComponents() {
        this.jLabelFrameworks = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jListFrameworks = new JList();
        this.jButtonAdd = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jPanelConfig = new JPanel();
        this.jLabelConfig = new JLabel();
        this.jLabelFrameworks.setDisplayedMnemonic(NbBundle.getMessage(CustomizerFrameworks.class, (String)"LBL_CustomizerFrameworks_ListMnemonic").charAt(0));
        this.jLabelFrameworks.setLabelFor(this.jListFrameworks);
        this.jLabelFrameworks.setText(NbBundle.getMessage(CustomizerFrameworks.class, (String)"LBL_UsedFrameworks"));
        this.jScrollPane1.setViewportView(this.jListFrameworks);
        this.jListFrameworks.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerFrameworks.class, (String)"ACS_Frameworks_FrameworksList_A11YDesc"));
        this.jButtonAdd.setMnemonic(NbBundle.getMessage(CustomizerFrameworks.class, (String)"LBL_CustomizerFrameworks_AddButton_LabelMnemonic").charAt(0));
        this.jButtonAdd.setText(NbBundle.getMessage(CustomizerFrameworks.class, (String)"LBL_AddFramework"));
        this.jButtonAdd.setActionCommand("Add...");
        this.jButtonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerFrameworks.this.jButtonAddActionPerformed(actionEvent);
            }
        });
        this.jPanelConfig.setLayout(new GridBagLayout());
        this.jLabelConfig.setLabelFor(this.jPanelConfig);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 373, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButtonAdd)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabelFrameworks).addContainerGap()).add((Component)this.jSeparator1, -1, 432, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabelConfig).addContainerGap()).add((Component)this.jPanelConfig, -1, 432, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabelFrameworks).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.jButtonAdd).add((Component)this.jScrollPane1, -2, 253, -2)).add(9, 9, 9).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabelConfig).add(18, 18, 18).add((Component)this.jPanelConfig, -1, 171, Short.MAX_VALUE)));
        this.jButtonAdd.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerFrameworks.class, (String)"ACS_Frameworks_AddButton_A11YDesc"));
    }

    private void jButtonAddActionPerformed(ActionEvent actionEvent) {
        AddFrameworkPanel addFrameworkPanel = new AddFrameworkPanel(this.usedFrameworks);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.getAccessibleContext().setAccessibleDescription(addFrameworkPanel.getAccessibleContext().getAccessibleDescription());
        jPanel.getAccessibleContext().setAccessibleName(addFrameworkPanel.getAccessibleContext().getAccessibleName());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        jPanel.add((Component)addFrameworkPanel, gridBagConstraints);
        LinkedList<String> linkedList = new LinkedList<String>();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)jPanel, NbBundle.getMessage(CustomizerFrameworks.class, (String)"LBL_SelectWebExtension_DialogTitle"));
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (object.equals(NotifyDescriptor.YES_OPTION)) {
            List<WebFrameworkProvider> list = addFrameworkPanel.getSelectedFrameworks();
            WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
            for (int i = 0; i < list.size(); ++i) {
                WebModuleExtender webModuleExtender;
                WebFrameworkProvider webFrameworkProvider = list.get(i);
                if (!((DefaultListModel)this.jListFrameworks.getModel()).contains(webFrameworkProvider.getName())) {
                    ((DefaultListModel)this.jListFrameworks.getModel()).addElement(webFrameworkProvider.getName());
                }
                boolean bl = false;
                if (this.usedFrameworks.size() == 0) {
                    this.usedFrameworks.add(webFrameworkProvider);
                    bl = true;
                } else {
                    for (int j = 0; j < this.usedFrameworks.size(); ++j) {
                        if (this.usedFrameworks.get(j).getName().equals(webFrameworkProvider.getName())) continue;
                        this.usedFrameworks.add(webFrameworkProvider);
                        bl = true;
                        break;
                    }
                }
                if (bl && (webModuleExtender = webFrameworkProvider.createWebModuleExtender(webModule, this.controller)) != null) {
                    this.extenders.put(webFrameworkProvider, webModuleExtender);
                    this.newExtenders.add(webModuleExtender);
                    webModuleExtender.addChangeListener((ChangeListener)new ExtenderListener(webModuleExtender));
                    linkedList.add(webFrameworkProvider.getName());
                }
                this.jListFrameworks.setSelectedValue(webFrameworkProvider.getName(), true);
            }
            this.uiProperties.setNewExtenders(this.newExtenders);
            this.uiProperties.setNewFrameworksNames(linkedList);
        }
        if (WebFrameworks.getFrameworks().size() == this.jListFrameworks.getModel().getSize()) {
            this.jButtonAdd.setEnabled(false);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerFrameworks.class);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        String string = (String)this.jListFrameworks.getSelectedValue();
        int n = this.jListFrameworks.getSelectedIndex();
        if (n != -1 && n < this.usedFrameworks.size()) {
            WebFrameworkProvider webFrameworkProvider = this.usedFrameworks.get(n);
            if (webFrameworkProvider.getName().equals(string)) {
                WebModuleExtender webModuleExtender = this.extenders.get(webFrameworkProvider);
                if (webModuleExtender != null) {
                    String string2 = MessageFormat.format(NbBundle.getMessage(CustomizerFrameworks.class, (String)"LBL_FrameworkConfiguration"), string);
                    this.jLabelConfig.setText(string2);
                    this.jPanelConfig.removeAll();
                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.gridwidth = 0;
                    gridBagConstraints.gridheight = 0;
                    gridBagConstraints.fill = 1;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.weighty = 1.0;
                    this.jPanelConfig.add((Component)webModuleExtender.getComponent(), gridBagConstraints);
                    this.jPanelConfig.repaint();
                    this.jPanelConfig.revalidate();
                } else {
                    this.hideConfigPanel();
                }
            }
        } else {
            this.hideConfigPanel();
        }
    }

    private void hideConfigPanel() {
        this.jLabelConfig.setText("");
        this.jPanelConfig.removeAll();
        this.jPanelConfig.repaint();
        this.jPanelConfig.revalidate();
    }

    private final class ExtenderListener
    implements ChangeListener {
        private final WebModuleExtender extender;

        public ExtenderListener(WebModuleExtender webModuleExtender) {
            this.extender = webModuleExtender;
            webModuleExtender.update();
            this.stateChanged(new ChangeEvent(this));
        }

        public void stateChanged(ChangeEvent changeEvent) {
            CustomizerFrameworks.this.controller.setErrorMessage(null);
            if (this.extender.isValid()) {
                if (!CustomizerFrameworks.this.category.isValid()) {
                    CustomizerFrameworks.this.category.setValid(true);
                    CustomizerFrameworks.this.category.setErrorMessage(null);
                }
            } else {
                CustomizerFrameworks.this.category.setValid(false);
                CustomizerFrameworks.this.category.setErrorMessage(CustomizerFrameworks.this.controller.getErrorMessage());
            }
        }
    }
}

