/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.pluginimporter;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.pluginimporter.Installer;
import org.netbeans.modules.autoupdate.pluginimporter.PluginImporter;
import org.netbeans.modules.autoupdate.ui.api.PluginManager;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportManager
extends Panel {
    private final File srcCluster;
    private final File dest;
    private final PluginImporter importer;
    private static ImportManager INSTANCE = null;
    private List<Boolean> checkedToInstall = Collections.emptyList();
    private List<Boolean> checkedToImport = Collections.emptyList();
    private List<UpdateElement> toInstall = Collections.emptyList();
    private List<UpdateElement> toImport = Collections.emptyList();
    private Notification currentNotification = null;
    private JButton bImport;
    private JButton bNo;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JTextPane jTextPane1;
    private JLabel lBroken;
    private JLabel lDesc;
    private JLabel lToImport;
    private JLabel lToInstall;
    private JPanel pProgress;
    private JTable tToImport;
    private JTable tToInstall;
    private JTextPane tpBroken;

    public ImportManager(File file, File file2, PluginImporter pluginImporter) {
        this.srcCluster = file;
        this.dest = file2;
        this.importer = pluginImporter;
        this.initialize();
        INSTANCE = this;
    }

    public PluginImporter getPluginImporter() {
        return this.importer;
    }

    private void initialize() {
        this.toInstall = new ArrayList<UpdateElement>(this.importer.getPluginsAvailableToInstall());
        Collections.sort(this.toInstall, new Comparator<UpdateElement>(){

            @Override
            public int compare(UpdateElement updateElement, UpdateElement updateElement2) {
                return updateElement.getDisplayName().compareTo(updateElement2.getDisplayName());
            }
        });
        this.checkedToInstall = new ArrayList<Boolean>(Collections.nCopies(this.importer.getPluginsAvailableToInstall().size(), Boolean.TRUE));
        this.toImport = new ArrayList<UpdateElement>(this.importer.getPluginsToImport());
        Collections.sort(this.toImport, new Comparator<UpdateElement>(){

            @Override
            public int compare(UpdateElement updateElement, UpdateElement updateElement2) {
                return updateElement.getDisplayName().compareTo(updateElement2.getDisplayName());
            }
        });
        this.checkedToImport = new ArrayList<Boolean>(Collections.nCopies(this.toImport.size(), Boolean.FALSE));
        this.initComponents();
        this.tpBroken.setEnabled(!this.importer.getBrokenPlugins().isEmpty());
        this.lBroken.setEnabled(!this.importer.getBrokenPlugins().isEmpty());
        if (!this.importer.getBrokenPlugins().isEmpty()) {
            this.tpBroken.setText(this.importer.getBrokenPlugins().toString());
        }
        this.refreshUI();
    }

    public static ImportManager getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAvailable() {
        this.remindLater();
        String string = NbBundle.getMessage(ImportManager.class, (String)"ImportNotifier_PluginAvailableForImport", (Object)(this.toImport.size() + this.toInstall.size()));
        String string2 = NbBundle.getMessage(ImportManager.class, (String)"ImportNotifier_PluginAvailableForImport_Details", (Object)this.srcCluster);
        MyAction myAction = new MyAction();
        ImportManager importManager = this;
        synchronized (importManager) {
            if (null != this.currentNotification) {
                this.currentNotification.clear();
            }
            Notification notification = NotificationDisplayer.getDefault().notify(string, (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/autoupdate/pluginimporter/resources/import.png", (boolean)false), string2, (ActionListener)myAction);
            myAction.notification = notification;
            this.currentNotification = notification;
        }
    }

    public void attachButtons(JButton jButton, JButton jButton2) {
        this.bImport = jButton;
        this.bNo = jButton2;
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object instanceof JButton) {
                    final JButton jButton = (JButton)object;
                    jButton.setEnabled(false);
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            try {
                                final boolean bl = ImportManager.this.doImport();
                                SwingUtilities.invokeAndWait(new Runnable(){

                                    public void run() {
                                        if (bl) {
                                            ImportManager.this.doClose();
                                        } else {
                                            jButton.setEnabled(true);
                                        }
                                    }
                                });
                            }
                            catch (InterruptedException interruptedException) {
                                Exceptions.printStackTrace((Throwable)interruptedException);
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                Exceptions.printStackTrace((Throwable)invocationTargetException);
                            }
                        }
                    });
                }
            }
        });
        this.refreshUI();
    }

    public void remindLater() {
        Preferences preferences = NbPreferences.forModule(Installer.class);
        preferences.put("import-from", this.srcCluster.toString());
    }

    public void dontRemind() {
        Preferences preferences = NbPreferences.forModule(Installer.class);
        try {
            preferences.clear();
        }
        catch (BackingStoreException backingStoreException) {
            Exceptions.printStackTrace((Throwable)backingStoreException);
        }
    }

    private void doClose() {
        this.bNo.doClick();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doImport() {
        boolean bl;
        block26: {
            JLabel jLabel;
            Object object;
            OperationContainer operationContainer;
            bl = true;
            if (this.checkedToImport.indexOf(Boolean.TRUE) != -1) {
                operationContainer = new HashSet();
                for (Object object2 : this.toImport) {
                    if (!this.checkedToImport.get(this.toImport.indexOf(object2)).booleanValue()) continue;
                    operationContainer.add(object2);
                }
                if (operationContainer.size() > 0) {
                    Object object2;
                    object = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(ImportManager.class, (String)"ImportManager.Progress.Name"));
                    object2 = ProgressHandleFactory.createProgressComponent((ProgressHandle)object);
                    jLabel = new JLabel(NbBundle.getMessage(ImportManager.class, (String)"ImportManager.Progress.Label"));
                    jLabel.setHorizontalAlignment(2);
                    this.setProgressComponent(jLabel, (JComponent)object2);
                    try {
                        this.importer.importPlugins((Collection<UpdateElement>)operationContainer, this.srcCluster, this.dest, (ProgressHandle)object);
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                    finally {
                        this.toImport.clear();
                        this.checkedToImport.clear();
                    }
                    try {
                        SwingUtilities.invokeAndWait(new Runnable((JComponent)object2){
                            final /* synthetic */ JComponent val$progressComp;
                            {
                                this.val$progressComp = jComponent;
                            }

                            public void run() {
                                jLabel.setVisible(false);
                                this.val$progressComp.setVisible(false);
                                ImportManager.this.tToImport.setModel(ImportManager.this.getModel(ImportManager.this.toImport, ImportManager.this.checkedToImport));
                                ImportManager.this.refreshUI();
                            }
                        });
                    }
                    catch (InterruptedException interruptedException) {
                        Exceptions.printStackTrace((Throwable)interruptedException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Exceptions.printStackTrace((Throwable)invocationTargetException);
                    }
                }
            }
            try {
                this.dontRemind();
                if (this.checkedToInstall.indexOf(Boolean.TRUE) == -1) break block26;
                operationContainer = OperationContainer.createForInstall();
                for (Object object2 : this.toInstall) {
                    if (!this.checkedToInstall.get(this.toInstall.indexOf(object2)).booleanValue() || (jLabel = operationContainer.add(object2)) == null) continue;
                    for (UpdateElement updateElement : jLabel.getRequiredElements()) {
                        if (updateElement.getUpdateUnit().isPending()) continue;
                        operationContainer.add(updateElement);
                    }
                }
                try {
                    object = new ArrayList();
                    SwingUtilities.invokeAndWait(new Runnable((List)object){
                        final /* synthetic */ List val$list;
                        {
                            this.val$list = list;
                        }

                        public void run() {
                            boolean bl = PluginManager.openInstallWizard((OperationContainer)operationContainer);
                            if (bl) {
                                ImportManager.this.toInstall.clear();
                                ImportManager.this.checkedToInstall.clear();
                            } else {
                                this.val$list.add(new Object());
                            }
                        }
                    });
                    if (!object.isEmpty()) {
                        bl = false;
                    }
                }
                catch (InterruptedException interruptedException) {
                    Exceptions.printStackTrace((Throwable)interruptedException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Exceptions.printStackTrace((Throwable)invocationTargetException);
                }
            }
            catch (Throwable throwable) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            ImportManager.this.tToInstall.setModel(ImportManager.this.getModel(ImportManager.this.toInstall, ImportManager.this.checkedToInstall));
                            ImportManager.this.refreshUI();
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    Exceptions.printStackTrace((Throwable)interruptedException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Exceptions.printStackTrace((Throwable)invocationTargetException);
                }
                throw throwable;
            }
        }
        try {
            SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Exceptions.printStackTrace((Throwable)invocationTargetException);
        }
        return bl;
    }

    private void setProgressComponent(final JLabel jLabel, final JComponent jComponent) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setProgressComponentInAwt(jLabel, jComponent);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ImportManager.this.setProgressComponentInAwt(jLabel, jComponent);
                }
            });
        }
    }

    private void setProgressComponentInAwt(JLabel jLabel, JComponent jComponent) {
        assert (this.pProgress != null);
        assert (SwingUtilities.isEventDispatchThread()) : "Must be called in EQ.";
        jComponent.setMinimumSize(jComponent.getPreferredSize());
        this.pProgress.setVisible(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.pProgress.add((Component)jComponent, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.pProgress.add((Component)jLabel, gridBagConstraints);
        this.validate();
    }

    private TableModel getModel(final List<UpdateElement> list, final List<Boolean> list2) {
        return new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return list.size();
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                switch (n2) {
                    case 0: {
                        return list2.get(n);
                    }
                    case 1: {
                        return ((UpdateElement)list.get(n)).getDisplayName();
                    }
                }
                return null;
            }

            @Override
            public Class<?> getColumnClass(int n) {
                switch (n) {
                    case 0: {
                        return Boolean.class;
                    }
                    case 1: {
                        return String.class;
                    }
                }
                return null;
            }

            @Override
            public String getColumnName(int n) {
                switch (n) {
                    case 0: {
                        return NbBundle.getMessage(ImportManager.class, (String)"ImportNotifier_Install");
                    }
                    case 1: {
                        return NbBundle.getMessage(ImportManager.class, (String)"ImportNotifier_Plugin");
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                switch (n2) {
                    case 0: {
                        return true;
                    }
                    case 1: {
                        return false;
                    }
                }
                return false;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                switch (n2) {
                    case 0: {
                        list2.set(n, (Boolean)object);
                        ImportManager.this.refreshUI();
                        break;
                    }
                    case 1: {
                        assert (false) : "Name is not editable.";
                        break;
                    }
                }
            }
        };
    }

    private void initComponents() {
        this.jScrollPane3 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.lToInstall = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tToInstall = new JTable();
        this.lToImport = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.tToImport = new JTable();
        this.lBroken = new JLabel();
        this.jScrollPane4 = new JScrollPane();
        this.tpBroken = new JTextPane();
        this.lDesc = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.pProgress = new JPanel();
        this.jScrollPane3.setViewportView(this.jTextPane1);
        this.lToInstall.setLabelFor(this.lToInstall);
        Mnemonics.setLocalizedText((JLabel)this.lToInstall, (String)NbBundle.getMessage(ImportManager.class, (String)"ImportManager.lToInstall.text"));
        this.tToInstall.setModel(this.getModel(this.toInstall, this.checkedToInstall));
        this.tToInstall.setAutoResizeMode(4);
        this.tToInstall.setOpaque(false);
        this.jScrollPane1.setViewportView(this.tToInstall);
        this.lToImport.setLabelFor(this.tToImport);
        Mnemonics.setLocalizedText((JLabel)this.lToImport, (String)NbBundle.getMessage(ImportManager.class, (String)"ImportManager.lToImport.text"));
        this.tToImport.setModel(this.getModel(this.toImport, this.checkedToImport));
        this.tToImport.setAutoResizeMode(4);
        this.tToImport.setOpaque(false);
        this.jScrollPane2.setViewportView(this.tToImport);
        this.lBroken.setLabelFor(this.tpBroken);
        Mnemonics.setLocalizedText((JLabel)this.lBroken, (String)NbBundle.getMessage(ImportManager.class, (String)"ImportManager.lBroken.text"));
        this.tpBroken.setEnabled(false);
        this.tpBroken.setOpaque(false);
        this.jScrollPane4.setViewportView(this.tpBroken);
        this.lDesc.setFont(this.lDesc.getFont().deriveFont(this.lDesc.getFont().getStyle() | 1));
        Mnemonics.setLocalizedText((JLabel)this.lDesc, (String)NbBundle.getMessage(ImportManager.class, (String)"ImportManager.lDesc.text", (Object[])new Object[]{this.srcCluster}));
        this.pProgress.setLayout(new GridBagLayout());
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.pProgress, -1, 574, Short.MAX_VALUE).add((Component)this.jScrollPane4, -1, 574, Short.MAX_VALUE).add(1, (Component)this.lToImport, -1, 574, Short.MAX_VALUE).add(1, (Component)this.jSeparator2, -1, 574, Short.MAX_VALUE).add(1, (Component)this.lToInstall).add(1, (Component)this.lDesc).add(1, (Component)this.jScrollPane1, -1, 574, Short.MAX_VALUE).add(1, (Component)this.jSeparator1, -1, 574, Short.MAX_VALUE).add(1, (Component)this.jScrollPane2, -1, 574, Short.MAX_VALUE).add(1, (Component)this.lBroken, -2, 565, -2)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lDesc).add(7, 7, 7).add((Component)this.lToInstall).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 123, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((Component)this.lToImport).addPreferredGap(0).add((Component)this.jScrollPane2, -1, 158, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jSeparator2, -2, 10, -2).addPreferredGap(0).add((Component)this.lBroken).addPreferredGap(0).add((Component)this.jScrollPane4, -1, 75, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.pProgress, -2, 21, -2).addContainerGap()));
    }

    private void refreshUI() {
        this.lToImport.setEnabled(this.toImport.size() > 0);
        this.tToImport.setEnabled(this.toImport.size() > 0);
        this.lToInstall.setEnabled(this.toInstall.size() > 0);
        this.tToInstall.setEnabled(this.toInstall.size() > 0);
        TableColumn tableColumn = this.tToImport.getColumnModel().getColumn(0);
        tableColumn.setMaxWidth(this.tToImport.getTableHeader().getHeaderRect((int)0).width);
        tableColumn = this.tToInstall.getColumnModel().getColumn(0);
        tableColumn.setMaxWidth(this.tToInstall.getTableHeader().getHeaderRect((int)0).width);
        if (this.bImport != null) {
            this.bImport.setEnabled(this.checkedToInstall.indexOf(Boolean.TRUE) != -1 || this.checkedToImport.indexOf(Boolean.TRUE) != -1);
        }
    }

    private class MyAction
    extends AbstractAction {
        final JButton bRemindLaterButton = new JButton();
        final JButton bImportButton = new JButton();
        final JButton bNoButton = new JButton();
        private Notification notification;

        public MyAction() {
            Mnemonics.setLocalizedText((AbstractButton)this.bRemindLaterButton, (String)NbBundle.getMessage(ImportManager.class, (String)"ImportNotifier_bRemindLater"));
            Mnemonics.setLocalizedText((AbstractButton)this.bImportButton, (String)NbBundle.getMessage(ImportManager.class, (String)"ImportNotifier_bImport"));
            Mnemonics.setLocalizedText((AbstractButton)this.bNoButton, (String)NbBundle.getMessage(ImportManager.class, (String)"ImportNotifier_bNo"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImportManager importManager = ImportManager.getInstance();
            importManager.getPluginImporter().reinspect();
            importManager.initialize();
            importManager.attachButtons(this.bImportButton, this.bNoButton);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)importManager, NbBundle.getMessage(Installer.class, (String)"Installer_DialogTitle"), true, new Object[]{this.bImportButton, this.bNoButton, this.bRemindLaterButton}, NotifyDescriptor.OK_OPTION, 0, null, null);
            dialogDescriptor.setClosingOptions(new Object[]{this.bNoButton, this.bRemindLaterButton});
            DialogDisplayer.getDefault().createDialog(dialogDescriptor).setVisible(true);
            if (this.bImportButton.equals(dialogDescriptor.getValue()) || this.bNoButton.equals(dialogDescriptor.getValue())) {
                importManager.dontRemind();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (null != MyAction.this.notification) {
                            MyAction.this.notification.clear();
                        }
                    }
                });
            } else if (this.bRemindLaterButton.equals(dialogDescriptor.getValue())) {
                importManager.remindLater();
            }
        }
    }
}

