/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.ruby.platform;

import java.io.File;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.Util;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class RubyPlatformValidator {
    private final RubyPlatform platform;

    RubyPlatformValidator(RubyPlatform rubyPlatform) {
        this.platform = rubyPlatform;
    }

    boolean hasRubyGemsInstalled(boolean bl) {
        String string = this.getRubyGemsProblems();
        if (string != null && bl) {
            Util.notifyLocalized(RubyPlatform.class, "RubyPlatformValidator.DoesNotHaveRubyGems", 2, new Object[]{this.platform.getLabel(), string});
        }
        return string == null;
    }

    String getRubyGemsProblems() {
        String string = this.platform.getGemTool();
        if (string == null) {
            return this.getGemMissingMessage();
        }
        String string2 = this.platform.getInfo().getGemHome();
        if (string2 == null) {
            return NbBundle.getMessage(RubyPlatformValidator.class, (String)"RubyPlatformValidator.CannotFindGemRepository");
        }
        File file = new File(string2);
        if (!file.isDirectory()) {
            return null;
        }
        return null;
    }

    boolean checkAndReportRubyGemsProblems() {
        String string = this.getRubyGemsProblems();
        if (string != null) {
            this.reportRubyGemsProblem();
        }
        return string == null;
    }

    private String getGemMissingMessage() {
        String string;
        if (Utilities.isMac() && "/usr/bin/ruby".equals(this.platform.getInterpreter()) && ((string = System.getProperty("os.version")) == null || string.startsWith("10.4"))) {
            return NbBundle.getMessage(RubyPlatformValidator.class, (String)"RubyPlatformValidator.GemMissingMac");
        }
        return NbBundle.getMessage(RubyPlatformValidator.class, (String)"RubyPlatformValidator.GemMissing");
    }

    void reportRubyGemsProblem() {
        String string = this.getRubyGemsProblems();
        assert (string != null) : "cannot report RubyGems problems when there not any";
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
    }
}

