/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;

public final class RubyPreferences {
    private static final String FIRST_TIME_KEY = "platform-manager-called-first-time";
    private static final String FETCH_ALL_VERSIONS = "gem-manager-fetch-all-versions";
    private static final String FETCH_GEM_DESCRIPTIONS = "gem-manager-fetch-descriptions";
    private static final String GEM_VERBOSE_OUTPUT = "gem-manager-verbose-output";
    private static final String INDEX_VENDOR_GEMS_ONLY = "rails-index-vendor-gems-only";
    public static final String VENDOR_GEMS_PROPERTY = "vendor-gems";
    private static final RubyPreferences INSTANCE = new RubyPreferences();
    private static final PropertyChangeSupport changeSupport = new PropertyChangeSupport(INSTANCE);

    private RubyPreferences() {
    }

    public static RubyPreferences getInstance() {
        return INSTANCE;
    }

    public static Preferences getPreferences() {
        return NbPreferences.forModule(RubyPreferences.class);
    }

    public static void setFirstPlatformTouch(boolean bl) {
        RubyPreferences.getPreferences().putBoolean(FIRST_TIME_KEY, bl);
    }

    public static boolean isFirstPlatformTouch() {
        return RubyPreferences.getPreferences().getBoolean(FIRST_TIME_KEY, true);
    }

    public static boolean shallFetchAllVersions() {
        return RubyPreferences.getPreferences().getBoolean(FETCH_ALL_VERSIONS, false);
    }

    public static void setFetchAllVersions(boolean bl) {
        RubyPreferences.getPreferences().putBoolean(FETCH_ALL_VERSIONS, bl);
    }

    public static boolean shallFetchGemDescriptions() {
        return RubyPreferences.getPreferences().getBoolean(FETCH_GEM_DESCRIPTIONS, false);
    }

    public static void setFetchGemDescriptions(boolean bl) {
        RubyPreferences.getPreferences().putBoolean(FETCH_GEM_DESCRIPTIONS, bl);
    }

    public static boolean isGemVerboseOutput() {
        return RubyPreferences.getPreferences().getBoolean(GEM_VERBOSE_OUTPUT, true);
    }

    public static void setGemVerboseOutput(boolean bl) {
        RubyPreferences.getPreferences().putBoolean(GEM_VERBOSE_OUTPUT, bl);
    }

    public static boolean isIndexVendorGemsOnly() {
        return RubyPreferences.getPreferences().getBoolean(INDEX_VENDOR_GEMS_ONLY, false);
    }

    public static void setIndexVendorGemsOnly(boolean bl) {
        boolean bl2 = RubyPreferences.isIndexVendorGemsOnly();
        RubyPreferences.getPreferences().putBoolean(INDEX_VENDOR_GEMS_ONLY, bl);
        if (bl2 != bl) {
            changeSupport.firePropertyChange(VENDOR_GEMS_PROPERTY, bl2, bl);
        }
    }

    public static void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public static void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        changeSupport.removePropertyChangeListener(propertyChangeListener);
    }
}

