/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.execution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RubyLineConvertorFactory
implements ExecutionDescriptor.LineConvertorFactory {
    private static final Logger LOGGER = Logger.getLogger(RubyLineConvertorFactory.class.getName());
    private static final String WINDOWS_DRIVE = "(?:\\S{1}:[\\\\/])";
    private static final String FILE_CHAR = "[^\\s\\[\\]\\:\\\"]";
    private static final String FILE = "((?:[^\\s\\[\\]\\:\\\"]*))";
    private static final String FILE_WIN = "((?:\\S{1}:[\\\\/])(?:[^\\s\\[\\]\\:\\\"].*))";
    private static final String LINE = "([1-9][0-9]*)";
    private static final String ROL = ".*\\s?";
    private static final String SEP = "\\:";
    private static final String STD_SUFFIX = "((?:[^\\s\\[\\]\\:\\\"]*))\\:([1-9][0-9]*).*\\s?";
    static final Pattern RUBY_COMPILER = Pattern.compile(".*?((?:[^\\s\\[\\]\\:\\\"]*))\\:([1-9][0-9]*).*\\s?");
    static final Pattern JRUBY_COMPILER = Pattern.compile(":.*:\\s.*?((?:[^\\s\\[\\]\\:\\\"]*))\\:([1-9][0-9]*).*\\s?");
    static final Pattern RUBY_COMPILER_WIN_MY = Pattern.compile(".*?((?:\\S{1}:[\\\\/])(?:[^\\s\\[\\]\\:\\\"].*))\\:([1-9][0-9]*).*\\s?");
    private static final String TIME_PATTERN = "(\\d{1,2}:\\d{1,2}:\\d{1,2})";
    private static final String NUMERIC_URL_PATTERN = "(?:\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}.\\d{1,3})";
    private static final String HTTP_URL_PATTERN = "(?:https?://.*?)";
    private static final String URL_PORT = "(?::(\\d{1,5}))";
    static final Pattern TIME_MATCHER = Pattern.compile("(\\d{1,2}:\\d{1,2}:\\d{1,2})");
    static final Pattern URL_MATCHER = Pattern.compile("((?:https?://.*?)|(?:\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}.\\d{1,3}))(?::(\\d{1,5}))");
    static final Pattern RUBY_COMPILER_WIN = Pattern.compile("^(?:(?:\\[|\\]|\\-|\\:|[0-9]|\\s|\\,)*)(?:\\s*from )?((?:\\S{1}:[\\\\/])(?:[^\\s\\[\\]\\:\\\"].*))\\:([1-9][0-9]*).*\\s?");
    public static final Pattern RAILS_RECOGNIZER = Pattern.compile(".*#\\{RAILS_ROOT\\}/((?:[^\\s\\[\\]\\:\\\"]*))\\:([1-9][0-9]*).*\\s?");
    public static final Pattern RUBY_TEST_OUTPUT = Pattern.compile("\\s*test.*\\[((?:[^\\s\\[\\]\\:\\\"]*))\\:([1-9][0-9]*).*\\s?");
    public static final Pattern EXT_RE = Pattern.compile(".*\\.(rb|rake|mab|rjs|rxml|builder|erb)");
    private final LineConvertors.FileLocator locator;
    private final LineConvertor[] convertors;
    private final boolean stdConvertors;

    public static RubyLineConvertorFactory create(LineConvertors.FileLocator fileLocator, LineConvertor ... lineConvertorArray) {
        return new RubyLineConvertorFactory(fileLocator, false, lineConvertorArray);
    }

    public static RubyLineConvertorFactory withStandardConvertors(LineConvertors.FileLocator fileLocator, LineConvertor ... lineConvertorArray) {
        return new RubyLineConvertorFactory(fileLocator, true, lineConvertorArray);
    }

    private RubyLineConvertorFactory(LineConvertors.FileLocator fileLocator, boolean bl, LineConvertor ... lineConvertorArray) {
        this.locator = fileLocator;
        this.convertors = lineConvertorArray;
        this.stdConvertors = bl;
    }

    public static List<LineConvertor> getStandardConvertors(LineConvertors.FileLocator fileLocator) {
        ArrayList<LineConvertor> arrayList = new ArrayList<LineConvertor>(4);
        arrayList.add(new ShortCircuitConvertor(TIME_MATCHER));
        arrayList.add(new ShortCircuitConvertor(URL_MATCHER));
        arrayList.add(LineConvertors.filePattern((LineConvertors.FileLocator)fileLocator, (Pattern)RAILS_RECOGNIZER, null, (int)1, (int)2));
        arrayList.add(LineConvertors.filePattern((LineConvertors.FileLocator)fileLocator, (Pattern)RUBY_COMPILER_WIN_MY, null, (int)1, (int)2));
        arrayList.add(LineConvertors.filePattern((LineConvertors.FileLocator)fileLocator, (Pattern)JRUBY_COMPILER, null, (int)1, (int)2));
        arrayList.add(LineConvertors.filePattern((LineConvertors.FileLocator)fileLocator, (Pattern)RUBY_COMPILER, null, (int)1, (int)2));
        arrayList.add(LineConvertors.filePattern((LineConvertors.FileLocator)fileLocator, (Pattern)RUBY_COMPILER_WIN, null, (int)1, (int)2));
        return arrayList;
    }

    public LineConvertor newLineConvertor() {
        ArrayList<LineConvertor> arrayList = new ArrayList<LineConvertor>();
        if (this.convertors != null) {
            for (LineConvertor lineConvertor : this.convertors) {
                if (lineConvertor == null) continue;
                arrayList.add(lineConvertor);
            }
        }
        if (this.stdConvertors) {
            arrayList.addAll(RubyLineConvertorFactory.getStandardConvertors(this.locator));
        }
        return LineConvertors.proxy((LineConvertor[])arrayList.toArray(new LineConvertor[arrayList.size()]));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ShortCircuitConvertor
    implements LineConvertor {
        private final Pattern linePattern;

        public ShortCircuitConvertor(Pattern pattern) {
            this.linePattern = pattern;
        }

        public List<ConvertedLine> convert(String string) {
            if (string.length() > 400) {
                return null;
            }
            Matcher matcher = this.linePattern.matcher(string);
            if (matcher.find()) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    StringBuilder stringBuilder = new StringBuilder(string.length());
                    stringBuilder.append("[ ");
                    for (int i = 1; i < matcher.groupCount(); ++i) {
                        String string2 = matcher.group(i);
                        if (string2 == null) continue;
                        if (stringBuilder.length() > 2) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append(string2);
                    }
                    stringBuilder.append(" ]");
                    LOGGER.log(Level.FINEST, "ShortCircuitConvertor matched {0}.", stringBuilder.toString());
                }
                return Collections.singletonList(ConvertedLine.forText((String)string, null));
            }
            return null;
        }
    }
}

