/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.layers;

import java.awt.EventQueue;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.layers.LayerFileSystem;
import org.netbeans.modules.apisupport.project.layers.PlatformLayersCacheManager;
import org.netbeans.modules.apisupport.project.layers.WritableXMLFileSystem;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.URLMapper;
import org.openide.filesystems.XMLFileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.CookieAction;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OpenLayerFilesAction
extends CookieAction {
    protected void performAction(final Node[] nodeArray) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                try {
                    FileObject fileObject = ((DataObject)nodeArray[0].getCookie(DataObject.class)).getPrimaryFile();
                    OpenLayerFilesAction.this.openLayersForFile(fileObject);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    Exceptions.printStackTrace((Throwable)fileStateInvalidException);
                }
            }
        });
    }

    private void openLayersForFile(FileObject fileObject) throws FileStateInvalidException {
        FileSystem fileSystem = fileObject.getFileSystem();
        while (fileSystem instanceof LayerFileSystem) {
            try {
                FileSystem[] fileSystemArray = ((LayerFileSystem)fileSystem).getLayerFileSystems();
                if (fileSystemArray == null || fileSystemArray.length <= 0 || (fileSystem = fileSystemArray[0]) instanceof LayerFileSystem || !(fileSystem instanceof WritableXMLFileSystem)) continue;
                for (int i = 0; i < fileSystemArray.length; ++i) {
                    URI uRI;
                    XMLFileSystem xMLFileSystem;
                    String string;
                    boolean bl;
                    URL[] uRLArray;
                    URL[] uRLArray2;
                    fileSystem = fileSystemArray[i];
                    if (fileSystem == null) continue;
                    FileObject fileObject2 = fileSystem.findResource(fileObject.getPath());
                    if (fileSystem instanceof WritableXMLFileSystem) {
                        FileObject fileObject3;
                        if (fileObject2 == null || (fileObject3 = URLMapper.findFileObject((URL)(uRLArray2 = (URL[])fileObject.getAttribute("WritableXMLFileSystem.location")))) == null) continue;
                        try {
                            uRLArray = DataObject.find((FileObject)fileObject3);
                            OpenLayerFilesAction.openLayerFileAndFind((DataObject)uRLArray, fileObject2);
                        }
                        catch (DataObjectNotFoundException dataObjectNotFoundException) {
                            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                        }
                        continue;
                    }
                    uRLArray2 = null;
                    boolean bl2 = bl = fileObject2 != null;
                    if (fileSystem instanceof XMLFileSystem) {
                        uRLArray = (XMLFileSystem)fileSystem;
                        uRLArray2 = uRLArray.getXmlUrls();
                    } else if (bl && (uRLArray = PlatformLayersCacheManager.findOriginatingJar(fileSystem)) != null) {
                        ManifestManager manifestManager = ManifestManager.getInstanceFromJAR((File)uRLArray, true);
                        String string2 = manifestManager.getLayer();
                        string = manifestManager.getGeneratedLayer();
                        xMLFileSystem = new ArrayList(2);
                        uRI = uRLArray.toURI();
                        if (string2 != null) {
                            xMLFileSystem.add(new URL("jar:" + uRI + "!/" + string2));
                        }
                        if (string != null) {
                            xMLFileSystem.add(new URL("jar:" + uRI + "!/" + string));
                        }
                        uRLArray2 = xMLFileSystem.toArray(new URL[xMLFileSystem.size()]);
                    }
                    if (uRLArray2 == null) continue;
                    uRLArray = uRLArray2;
                    int n = uRLArray.length;
                    for (int j = 0; j < n; ++j) {
                        string = uRLArray[j];
                        try {
                            xMLFileSystem = new XMLFileSystem((URL)((Object)string));
                            fileObject2 = xMLFileSystem.findResource(fileObject.getPath());
                            if (fileObject2 == null || (uRI = URLMapper.findFileObject((URL)((Object)string))) == null) continue;
                            try {
                                DataObject dataObject = DataObject.find((FileObject)uRI);
                                OpenLayerFilesAction.openLayerFileAndFind(dataObject, fileObject2);
                            }
                            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
                            }
                            continue;
                        }
                        catch (SAXException sAXException) {
                            Exceptions.printStackTrace((Throwable)sAXException);
                        }
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Exceptions.printStackTrace((Throwable)illegalArgumentException);
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
        }
    }

    private static void openLayerFileAndFind(DataObject dataObject, FileObject fileObject) {
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie != null) {
            editorCookie.open();
            final LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            if (lineCookie != null) {
                LinkedList<FileObject> linkedList = new LinkedList<FileObject>();
                for (FileObject fileObject2 = fileObject; fileObject2 != null; fileObject2 = fileObject2.getParent()) {
                    if (fileObject2.getParent() == null) continue;
                    linkedList.add(0, fileObject2);
                }
                try {
                    InputSource inputSource = new InputSource(dataObject.getPrimaryFile().getURL().toExternalForm());
                    SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                    SAXParser sAXParser = sAXParserFactory.newSAXParser();
                    final int[] nArray = new int[1];
                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    class Handler
                    extends DefaultHandler {
                        private Locator locator;
                        private Iterator<FileObject> lineageIterator;
                        private FileObject lookingFor;
                        final /* synthetic */ int[] val$line;

                        Handler(List<FileObject> list) {
                            this.val$line = (int[])list;
                            this.lineageIterator = var1_1.iterator();
                            this.lookingFor = this.lineageIterator.next();
                        }

                        @Override
                        public void setDocumentLocator(Locator locator) {
                            this.locator = locator;
                        }

                        @Override
                        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                            if (this.val$line[0] == 0 && (this.lookingFor.isFolder() ? "folder".equals(string3) : "file".equals(string3)) && this.lookingFor.getNameExt().equals(attributes.getValue("name"))) {
                                if (this.lineageIterator.hasNext()) {
                                    this.lookingFor = this.lineageIterator.next();
                                } else {
                                    this.val$line[0] = this.locator.getLineNumber();
                                }
                            }
                        }
                    }
                    sAXParser.parse(inputSource, (DefaultHandler)new Handler(linkedList, nArray));
                    if (nArray[0] < 1) {
                        return;
                    }
                    EventQueue.invokeLater(new Runnable(){

                        public void run() {
                            lineCookie.getLineSet().getCurrent(nArray[0] - 1).show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                        }
                    });
                }
                catch (Exception exception) {
                    return;
                }
            }
        }
    }

    public String getName() {
        return NbBundle.getMessage(OpenLayerFilesAction.class, (String)"LBL_open_layer_files_action");
    }

    protected Class[] cookieClasses() {
        return new Class[]{DataObject.class};
    }

    protected int mode() {
        return 8;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }
}

