/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.SuiteProvider;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.universe.ClusterUtils;

public final class ClusterInfo {
    private File clusterDir;
    private boolean isPlatformCluster;
    private Project project;
    private boolean enabled;
    private URL[] sourceRoots;
    private URL[] javadocRoots;

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ClusterInfo clusterInfo = (ClusterInfo)object;
        if (!(this.clusterDir == clusterInfo.clusterDir || this.clusterDir != null && this.clusterDir.equals(clusterInfo.clusterDir))) {
            return false;
        }
        if (this.isPlatformCluster != clusterInfo.isPlatformCluster) {
            return false;
        }
        if (!(this.project == clusterInfo.project || this.project != null && this.project.equals(clusterInfo.project))) {
            return false;
        }
        if (this.enabled != clusterInfo.enabled) {
            return false;
        }
        if (!Arrays.deepEquals(this.sourceRoots, clusterInfo.sourceRoots)) {
            return false;
        }
        return Arrays.deepEquals(this.javadocRoots, clusterInfo.javadocRoots);
    }

    public int hashCode() {
        int n = 7;
        n = 47 * n + (this.clusterDir != null ? this.clusterDir.hashCode() : 0);
        n = 47 * n + (this.isPlatformCluster ? 1 : 0);
        n = 47 * n + (this.project != null ? this.project.hashCode() : 0);
        n = 47 * n + (this.enabled ? 1 : 0);
        n = 47 * n + Arrays.deepHashCode(this.sourceRoots);
        n = 47 * n + Arrays.deepHashCode(this.javadocRoots);
        return n;
    }

    public String toString() {
        return this.clusterDir.getAbsolutePath() + (this.isEnabled() ? "" : " (DISABLED)");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isPlatformCluster() {
        return this.isPlatformCluster;
    }

    public boolean isExternalCluster() {
        return !this.isPlatformCluster && this.project == null;
    }

    public File getClusterDir() {
        return this.clusterDir;
    }

    private ClusterInfo(File file) {
        this.clusterDir = file;
    }

    public static ClusterInfo createFromCP(File file, Project project, boolean bl, URL[] uRLArray, URL[] uRLArray2, boolean bl2) {
        ClusterInfo clusterInfo = new ClusterInfo(file);
        clusterInfo.isPlatformCluster = bl;
        clusterInfo.project = project;
        clusterInfo.enabled = bl2;
        clusterInfo.sourceRoots = uRLArray;
        clusterInfo.javadocRoots = uRLArray2;
        return clusterInfo;
    }

    public static ClusterInfo create(File file, boolean bl, boolean bl2) {
        ClusterInfo clusterInfo = new ClusterInfo(file);
        clusterInfo.isPlatformCluster = bl;
        clusterInfo.enabled = bl2;
        return clusterInfo;
    }

    public static ClusterInfo createExternal(File file, URL[] uRLArray, URL[] uRLArray2, boolean bl) {
        ClusterInfo clusterInfo = new ClusterInfo(file);
        clusterInfo.isPlatformCluster = false;
        clusterInfo.enabled = bl;
        clusterInfo.sourceRoots = uRLArray;
        clusterInfo.javadocRoots = uRLArray2;
        return clusterInfo;
    }

    public static QueryResult canCreate(Project project) {
        NbModuleProvider nbModuleProvider = (NbModuleProvider)project.getLookup().lookup(NbModuleProvider.class);
        SuiteProvider suiteProvider = (SuiteProvider)project.getLookup().lookup(SuiteProvider.class);
        if (suiteProvider != null) {
            if (nbModuleProvider == null) {
                return QueryResult.OK;
            }
            assert (nbModuleProvider.getModuleType() == NbModuleProvider.SUITE_COMPONENT);
            return QueryResult.SUITE_COMP_NOT_ALLOWED;
        }
        if (nbModuleProvider != null) {
            if (nbModuleProvider.getModuleType() == NbModuleProvider.STANDALONE) {
                return QueryResult.OK;
            }
            return QueryResult.NBORG_PROJECT_NOT_ALLOWED;
        }
        return QueryResult.NOT_A_NBM_PROJECT;
    }

    public static ClusterInfo create(Project project, boolean bl) {
        QueryResult queryResult = ClusterInfo.canCreate(project);
        if (queryResult != QueryResult.OK) {
            throw new IllegalArgumentException(queryResult.getExceptionMessage());
        }
        NbModuleProvider nbModuleProvider = (NbModuleProvider)project.getLookup().lookup(NbModuleProvider.class);
        SuiteProvider suiteProvider = (SuiteProvider)project.getLookup().lookup(SuiteProvider.class);
        assert (nbModuleProvider != null || suiteProvider != null);
        File file = nbModuleProvider != null ? ClusterUtils.getClusterDirectory(project) : suiteProvider.getClusterDirectory();
        ClusterInfo clusterInfo = new ClusterInfo(file);
        clusterInfo.project = project;
        clusterInfo.enabled = bl;
        return clusterInfo;
    }

    public Project getProject() {
        return this.project;
    }

    public URL[] getSourceRoots() {
        return this.sourceRoots;
    }

    public URL[] getJavadocRoots() {
        return this.javadocRoots;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum QueryResult {
        OK("OK"),
        NOT_A_NBM_PROJECT("Not a NetBeans Module project"),
        NBORG_PROJECT_NOT_ALLOWED("NB.org projects are not allowed"),
        SUITE_COMP_NOT_ALLOWED("Suite component projects are not allowed, call for suite project instead");

        private String msg;

        private QueryResult(String string2) {
            this.msg = string2;
        }

        public String getExceptionMessage() {
            return this.msg;
        }
    }
}

