/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.ui.ModuleUISettings;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicVisualPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.NewModuleProjectData;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class LibraryStartVisualPanel
extends BasicVisualPanel.NewTemplatePanel {
    static final String PROP_LIBRARY_PATH = "LIBRARY_PATH_VALUE";
    static final String PROP_LICENSE_PATH = "LICENSE_PATH_VALUE";
    private boolean listenersAttached;
    private final DocumentListener libraryDL;
    private final DocumentListener licenseDL;
    private JButton browseLibraryButton;
    private JButton browseLicenceButton;
    private JPanel confPanel;
    private JPanel filler;
    private JLabel lblLibrary;
    private JLabel lblLicense;
    private JTextField txtLibrary;
    private JTextField txtLicense;

    public LibraryStartVisualPanel(NewModuleProjectData newModuleProjectData) {
        super(newModuleProjectData);
        this.initComponents();
        this.initAccessibility();
        this.libraryDL = new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent documentEvent) {
                LibraryStartVisualPanel.this.checkLibraryAndLicense();
            }
        };
        this.licenseDL = new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent documentEvent) {
                LibraryStartVisualPanel.this.checkLibraryAndLicense();
            }
        };
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(LibraryStartVisualPanel.getMessage("ACS_LibraryStartVisualPanel"));
        this.browseLibraryButton.getAccessibleContext().setAccessibleDescription(LibraryStartVisualPanel.getMessage("ACS_CTL_BrowseLibraries"));
        this.browseLicenceButton.getAccessibleContext().setAccessibleDescription(LibraryStartVisualPanel.getMessage("ACS_CTL_BrowseLicense"));
        this.txtLibrary.getAccessibleContext().setAccessibleDescription(LibraryStartVisualPanel.getMessage("ACS_CTL_Library"));
        this.txtLicense.getAccessibleContext().setAccessibleDescription(LibraryStartVisualPanel.getMessage("ACS_CTL_License"));
    }

    private void checkLibraryAndLicense() {
        Object object;
        String string = this.txtLibrary.getText().trim();
        if (string.length() > 0) {
            object = new StringTokenizer(string, File.pathSeparator);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string2 = ((StringTokenizer)object).nextToken();
                File file = new File(string2);
                if (!file.exists()) {
                    this.setError(LibraryStartVisualPanel.getMessage("MSG_Invalid_Library_Path"));
                    return;
                }
                try {
                    new JarFile(file);
                }
                catch (IOException iOException) {
                    this.setError(LibraryStartVisualPanel.getMessage("MSG_Invalid_Library_Path"));
                    return;
                }
                String string3 = LibraryStartVisualPanel.populateProjectData(this.getData(), string, false);
                if (string3 == null) continue;
                this.setWarning(NbBundle.getMessage(LibraryStartVisualPanel.class, (String)"MSG_ClassInDefaultPackage", (Object)string3));
                return;
            }
        } else {
            this.setError(LibraryStartVisualPanel.getMessage("MSG_Library_Path_Not_Defined"));
            return;
        }
        string = this.txtLicense.getText().trim();
        if (string.length() > 0 && !((File)(object = new File(string))).exists()) {
            this.setError(LibraryStartVisualPanel.getMessage("MSG_Invalid_License_Path"));
            return;
        }
        this.markValid();
    }

    void refreshData() {
    }

    void storeData() {
        String string = this.txtLibrary.getText().trim();
        this.getSettings().putProperty(PROP_LIBRARY_PATH, (Object)string);
        this.getSettings().putProperty(PROP_LICENSE_PATH, (Object)this.txtLicense.getText().trim());
        LibraryStartVisualPanel.populateProjectData(this.getData(), string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String populateProjectData(NewModuleProjectData newModuleProjectData, String string, boolean bl) {
        if (newModuleProjectData.getProjectName() != null && newModuleProjectData.getCodeNameBase() != null && bl) {
            return null;
        }
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        boolean bl2 = false;
        boolean bl3 = false;
        if (stringTokenizer.hasMoreTokens()) {
            bl3 = false;
            File file = new File(stringTokenizer.nextToken());
            if (!file.exists()) {
                return string2;
            }
            String string3 = file.getName();
            int n = string3.lastIndexOf(46);
            if (n > -1) {
                string3 = string3.substring(0, n);
            }
            string3 = string3.replaceAll("[0-9._-]+$", "");
            if (bl) {
                newModuleProjectData.setProjectName(string3);
            }
            JarFile jarFile = null;
            String string4 = null;
            try {
                jarFile = new JarFile(file);
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    String string5;
                    JarEntry jarEntry = enumeration.nextElement();
                    if (jarEntry.isDirectory() || !jarEntry.getName().endsWith(".class") || !Util.isValidJavaFQN((string5 = jarEntry.getName()).substring(0, string5.length() - 6).replace('/', '.'))) continue;
                    int n2 = string5.lastIndexOf(47);
                    if (n2 > -1) {
                        String string6 = string5.substring(0, n2);
                        if (string4 != null && string6.length() == string4.length() && !string6.equals(string4)) {
                            bl2 = true;
                        }
                        if (string4 != null && string6.length() >= string4.length()) continue;
                        string4 = string6;
                        bl2 = false;
                        continue;
                    }
                    if (bl3) continue;
                    string2 = string2 == null ? file.getName() : string2 + "," + file.getName();
                    bl3 = true;
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(16, (Throwable)iOException);
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException iOException) {
                        Util.err.notify(1, (Throwable)iOException);
                    }
                }
            }
            if (string4 != null && bl) {
                string4 = string4.replace('/', '.');
                if (bl2 && string4.indexOf(46) != string4.lastIndexOf(46)) {
                    int n3 = string4.lastIndexOf(46);
                    string4 = string4.substring(0, n3);
                }
                newModuleProjectData.setCodeNameBase(string4);
            }
        }
        return string2;
    }

    public void addNotify() {
        super.addNotify();
        this.attachDocumentListeners();
    }

    public void removeNotify() {
        this.removeDocumentListeners();
        super.removeNotify();
    }

    private void attachDocumentListeners() {
        if (!this.listenersAttached) {
            this.txtLibrary.getDocument().addDocumentListener(this.libraryDL);
            this.txtLicense.getDocument().addDocumentListener(this.licenseDL);
            this.listenersAttached = true;
        }
    }

    private void removeDocumentListeners() {
        if (this.listenersAttached) {
            this.txtLibrary.getDocument().removeDocumentListener(this.libraryDL);
            this.txtLicense.getDocument().removeDocumentListener(this.licenseDL);
            this.listenersAttached = false;
        }
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(LibraryStartVisualPanel.class, (String)string);
    }

    private void initComponents() {
        this.confPanel = new JPanel();
        this.lblLibrary = new JLabel();
        this.txtLibrary = new JTextField();
        this.lblLicense = new JLabel();
        this.txtLicense = new JTextField();
        this.browseLibraryButton = new JButton();
        this.browseLicenceButton = new JButton();
        this.filler = new JPanel();
        this.setLayout(new GridBagLayout());
        this.confPanel.setLayout(new GridBagLayout());
        this.lblLibrary.setLabelFor(this.txtLibrary);
        Mnemonics.setLocalizedText((JLabel)this.lblLibrary, (String)NbBundle.getMessage(LibraryStartVisualPanel.class, (String)"LBL_Library_path"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 0, 6, 12);
        this.confPanel.add((Component)this.lblLibrary, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 0, 6, 0);
        this.confPanel.add((Component)this.txtLibrary, gridBagConstraints);
        this.lblLicense.setLabelFor(this.txtLicense);
        Mnemonics.setLocalizedText((JLabel)this.lblLicense, (String)NbBundle.getMessage(LibraryStartVisualPanel.class, (String)"LBL_License_Path"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.confPanel.add((Component)this.lblLicense, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.confPanel.add((Component)this.txtLicense, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseLibraryButton, (String)NbBundle.getMessage(LibraryStartVisualPanel.class, (String)"CTL_BrowseButton_o"));
        this.browseLibraryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibraryStartVisualPanel.this.browseLibraryButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 6, 0);
        this.confPanel.add((Component)this.browseLibraryButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseLicenceButton, (String)NbBundle.getMessage(LibraryStartVisualPanel.class, (String)"CTL_BrowseButton_w"));
        this.browseLicenceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibraryStartVisualPanel.this.browseLicenceButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.confPanel.add((Component)this.browseLicenceButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.confPanel.add((Component)this.filler, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.add((Component)this.confPanel, gridBagConstraints);
    }

    private void browseLicenceButtonActionPerformed(ActionEvent actionEvent) {
        int n;
        JFileChooser jFileChooser = new JFileChooser(ModuleUISettings.getDefault().getLastChosenLibraryLocation());
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        if (this.txtLicense.getText().trim().length() > 0) {
            jFileChooser.setSelectedFile(new File(this.txtLicense.getText().trim()));
        }
        if ((n = jFileChooser.showDialog(this, LibraryStartVisualPanel.getMessage("LBL_Select"))) == 0) {
            this.txtLicense.setText(jFileChooser.getSelectedFile().getAbsolutePath());
            ModuleUISettings.getDefault().setLastChosenLibraryLocation(this.txtLicense.getText());
        }
    }

    private void browseLibraryButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(ModuleUISettings.getDefault().getLastChosenLibraryLocation());
        File[] fileArray = LibraryStartVisualPanel.convertStringToFiles(this.txtLibrary.getText().trim());
        jFileChooser.setSelectedFiles(fileArray);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(true);
        jFileChooser.addChoosableFileFilter(new JarZipFilter());
        int n = jFileChooser.showDialog(this, LibraryStartVisualPanel.getMessage("LBL_Select"));
        if (n == 0) {
            File[] fileArray2 = jFileChooser.getSelectedFiles();
            String string = "";
            for (int i = 0; i < fileArray2.length; ++i) {
                string = string + fileArray2[i] + (i == fileArray2.length - 1 ? "" : File.pathSeparator);
            }
            this.txtLibrary.setText(string);
            ModuleUISettings.getDefault().setLastChosenLibraryLocation(fileArray2[0].getParentFile().getAbsolutePath());
        }
    }

    static File[] convertStringToFiles(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        File[] fileArray = new File[stringTokenizer.countTokens()];
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i] = new File(stringTokenizer.nextToken());
        }
        return fileArray;
    }

    private static final class JarZipFilter
    extends FileFilter {
        private JarZipFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith("zip") || file.getName().endsWith("jar");
        }

        public String getDescription() {
            return LibraryStartVisualPanel.getMessage("LibraryStartVisualPanel_jar_zip_filter");
        }
    }
}

