/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.Writer;
import javax.swing.SwingUtilities;
import org.netbeans.lib.terminalemulator.Term;
import org.netbeans.lib.terminalemulator.TermInputListener;

public class StreamTerm
extends Term {
    private Writer writer;
    private Pipe pipe;
    private OutputStreamWriter outputStreamWriter;
    private InputStreamReader pout_reader;

    public OutputStreamWriter getOutputStreamWriter() {
        return this.outputStreamWriter;
    }

    public StreamTerm() {
        this.addInputListener(new TermInputListener(){

            public void sendChars(char[] cArray, int n, int n2) {
                if (StreamTerm.this.outputStreamWriter == null) {
                    return;
                }
                try {
                    StreamTerm.this.outputStreamWriter.write(cArray, n, n2);
                    StreamTerm.this.outputStreamWriter.flush();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }

            public void sendChar(char c) {
                if (StreamTerm.this.outputStreamWriter == null) {
                    return;
                }
                try {
                    StreamTerm.this.outputStreamWriter.write(c);
                    StreamTerm.this.outputStreamWriter.flush();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    public void connect(OutputStream outputStream, InputStream inputStream, InputStream inputStream2) {
        if (this.pout_reader != null) {
            throw new IllegalStateException("Cannot call connect() twice");
        }
        if (this.pipe != null) {
            throw new IllegalStateException("Cannot call connect() after getIn()");
        }
        this.updateTtySize();
        if (outputStream != null) {
            this.outputStreamWriter = new OutputStreamWriter(outputStream);
        }
        this.pout_reader = new InputStreamReader(inputStream);
        OutputMonitor outputMonitor = new OutputMonitor(this.pout_reader, this);
        outputMonitor.start();
        if (inputStream2 != null) {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream2);
            OutputMonitor outputMonitor2 = new OutputMonitor(inputStreamReader, this);
            outputMonitor2.start();
        }
    }

    public Reader getIn() {
        if (this.pout_reader != null) {
            throw new IllegalStateException("Cannot call getIn() after connect()");
        }
        if (this.pipe == null) {
            try {
                this.pipe = new Pipe(this);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return this.pipe.reader();
    }

    public Writer getOut() {
        if (this.writer == null) {
            this.writer = new TermWriter();
        }
        return this.writer;
    }

    private class TermWriter
    extends Writer {
        private boolean closed = false;

        TermWriter() {
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            if (this.closed) {
                throw new IOException();
            }
            StreamTerm.this.putChars(cArray, n, n2);
        }

        public void flush() throws IOException {
            if (this.closed) {
                throw new IOException();
            }
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            this.flush();
            this.closed = true;
        }
    }

    private static class Pipe {
        private final Term term;
        private final PipedReader pipedReader;
        private final PipedWriter pipedWriter;

        Pipe(Term term) throws IOException {
            this.term = term;
            this.pipedReader = new PipedReader();
            this.pipedWriter = new PipedWriter(this.pipedReader);
            term.addInputListener(new TermListener());
        }

        Reader reader() {
            return this.pipedReader;
        }

        private class TermListener
        implements TermInputListener {
            private TermListener() {
            }

            public void sendChars(char[] cArray, int n, int n2) {
                try {
                    Pipe.this.pipedWriter.write(cArray, n, n2);
                    Pipe.this.pipedWriter.flush();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }

            public void sendChar(char c) {
                try {
                    Pipe.this.pipedWriter.write(c);
                    Pipe.this.pipedWriter.flush();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private class OutputMonitor
    extends Thread {
        private static final int BUFSZ = 1024;
        private char[] buf;
        private Term term;
        private InputStreamReader reader;

        OutputMonitor(InputStreamReader inputStreamReader, Term term) {
            super("StreamTerm.OutputMonitor");
            this.buf = new char[1024];
            this.reader = inputStreamReader;
            this.term = term;
            this.setPriority(1);
        }

        private void db_echo_receipt(char[] cArray, int n, int n2) {
            System.out.println("Received:");
            int n3 = 0;
            while (n3 < n2) {
                int n4;
                int n5 = n3;
                System.out.print(Fmt.pad(n3, 4) + ": ");
                for (n4 = 0; n4 < 20 && n3 < n2; ++n3, ++n4) {
                    String string = Integer.toHexString(cArray[n + n3]);
                    System.out.print(Fmt.pad0(string, 2) + " ");
                }
                System.out.println();
                n3 = n5;
                System.out.print("      ");
                for (n4 = 0; n4 < 20 && n3 < n2; ++n3, ++n4) {
                    int n6 = cArray[n + n3];
                    if (Character.isISOControl((char)n6)) {
                        n6 = 32;
                    }
                    System.out.print(Fmt.pad((byte)n6, 2) + " ");
                }
                System.out.println();
            }
        }

        public void run() {
            Trampoline trampoline = new Trampoline();
            try {
                while (true) {
                    int n = -1;
                    try {
                        n = this.reader.read(this.buf, 0, 1024);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (n == -1) break;
                    if (StreamTerm.this.debugInput()) {
                        this.db_echo_receipt(this.buf, 0, n);
                    }
                    trampoline.nread = n;
                    SwingUtilities.invokeAndWait(trampoline);
                }
                this.reader.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private final class Trampoline
        implements Runnable {
            public int nread;

            private Trampoline() {
            }

            public void run() {
                OutputMonitor.this.term.putChars(OutputMonitor.this.buf, 0, this.nread);
            }
        }
    }

    static class Fmt {
        private Fmt() {
        }

        public static String pad(int n, int n2) {
            return Fmt.pad("" + n, n2);
        }

        public static String pad(byte by, int n) {
            return Fmt.pad("" + (char)by, n);
        }

        public static String pad0(String string, int n) {
            return Fmt.padwith(string, n, '0');
        }

        public static String pad(String string, int n) {
            return Fmt.padwith(string, n, ' ');
        }

        private static String padwith(String string, int n, char c) {
            boolean bl = false;
            if (n < 0) {
                bl = true;
                n = -n;
            }
            String string2 = string.length() > n ? string.substring(0, n) : string;
            int n2 = n - string2.length();
            StringBuffer stringBuffer = new StringBuffer(string2);
            if (bl) {
                while (n2-- > 0) {
                    stringBuffer.append(c);
                }
            } else {
                while (n2-- > 0) {
                    stringBuffer.insert(0, c);
                }
            }
            return new String(stringBuffer);
        }
    }
}

