/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.api;

import java.awt.EventQueue;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.netbeans.modules.hudson.api.HudsonInstance;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.spi.ConnectionAuthenticator;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public final class ConnectionBuilder {
    private static final Logger LOG = Logger.getLogger(ConnectionBuilder.class.getName());
    private static final RequestProcessor TIMER = new RequestProcessor(ConnectionBuilder.class.getName() + ".TIMER");
    private static final Map<URL, String[]> COOKIES = new HashMap<URL, String[]>();
    private URL home;
    private URL url;
    private final Map<String, String> requestHeaders = new LinkedHashMap<String, String>();
    private byte[] postData;
    private int timeout;
    private boolean auth = true;

    public ConnectionBuilder url(URL uRL) {
        this.url = uRL;
        return this;
    }

    public ConnectionBuilder url(String string) throws MalformedURLException {
        return this.url(new URL(string));
    }

    public ConnectionBuilder homeURL(URL uRL) {
        this.home = uRL;
        return this;
    }

    public ConnectionBuilder instance(HudsonInstance hudsonInstance) {
        try {
            this.home = new URL(hudsonInstance.getUrl());
        }
        catch (MalformedURLException malformedURLException) {
            LOG.warning(malformedURLException.toString());
        }
        return this;
    }

    public ConnectionBuilder job(HudsonJob hudsonJob) {
        HudsonInstance hudsonInstance = hudsonJob.getInstance();
        if (hudsonInstance != null) {
            this.instance(hudsonInstance);
        }
        return this;
    }

    public ConnectionBuilder header(String string, String string2) {
        this.requestHeaders.put(string, string2);
        return this;
    }

    public ConnectionBuilder postData(byte[] byArray) {
        this.postData = byArray;
        return this;
    }

    public ConnectionBuilder timeout(int n) {
        this.timeout = n;
        return this;
    }

    public ConnectionBuilder authentication(boolean bl) {
        this.auth = bl;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLConnection connection() throws IOException {
        if (this.url == null) {
            throw new IllegalArgumentException("You must call the url method!");
        }
        if (this.url.getProtocol().matches("https?") && EventQueue.isDispatchThread()) {
            LOG.log(Level.FINER, "opening " + this.url, new IllegalStateException("Avoid connecting from EQ"));
            if (this.timeout == 0) {
                this.timeout = 3000;
            }
        }
        if (this.timeout == 0) {
            return this.doConnection();
        }
        final Thread thread = Thread.currentThread();
        RequestProcessor.Task task = TIMER.post(new Runnable(){

            public void run() {
                thread.interrupt();
            }
        }, this.timeout);
        try {
            URLConnection uRLConnection = this.doConnection();
            return uRLConnection;
        }
        finally {
            task.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URLConnection doConnection() throws IOException {
        Object object = this.url.openConnection();
        block14: while (true) {
            Object object2;
            Object object3;
            if (object instanceof HttpURLConnection) {
                ((HttpURLConnection)object).setInstanceFollowRedirects(false);
            }
            if (object instanceof HttpsURLConnection) {
                try {
                    object3 = SSLContext.getInstance("SSL");
                    ((SSLContext)object3).init(null, new TrustManager[]{new X509TrustManager(){

                        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                        }

                        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
                        }

                        public X509Certificate[] getAcceptedIssuers() {
                            return new X509Certificate[0];
                        }
                    }}, new SecureRandom());
                    ((HttpsURLConnection)object).setSSLSocketFactory(((SSLContext)object3).getSocketFactory());
                    ((HttpsURLConnection)object).setHostnameVerifier(new HostnameVerifier(){

                        public boolean verify(String string, SSLSession sSLSession) {
                            return true;
                        }
                    });
                }
                catch (Exception exception) {
                    LOG.log(Level.FINE, "could not disable SSL verification", exception);
                }
            }
            object3 = ((URLConnection)object).getURL();
            LOG.log(Level.FINER, "Trying to open {0}", object3);
            if (this.home != null) {
                for (ConnectionAuthenticator connectionAuthenticator : Lookup.getDefault().lookupAll(ConnectionAuthenticator.class)) {
                    connectionAuthenticator.prepareRequest((URLConnection)object, this.home);
                }
                if (COOKIES.containsKey(this.home)) {
                    for (String string : COOKIES.get(this.home)) {
                        object2 = string.replaceFirst(";.*", "");
                        LOG.log(Level.FINER, "Setting cookie {0} for {1}", new Object[]{object2, ((URLConnection)object).getURL()});
                        ((URLConnection)object).setRequestProperty("Cookie", (String)object2);
                    }
                }
            }
            if (this.postData != null) {
                ((URLConnection)object).setDoOutput(true);
            }
            List<String> list = this.requestHeaders.entrySet().iterator();
            while (list.hasNext()) {
                Map.Entry entry = (Map.Entry)list.next();
                ((URLConnection)object).setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
            try {
                ((URLConnection)object).connect();
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw (IOException)new IOException("Connecting to " + object3 + ": " + exception.toString()).initCause(exception);
            }
            if (this.postData != null) {
                list = ((URLConnection)object).getOutputStream();
                try {
                    ((OutputStream)((Object)list)).write(this.postData);
                }
                finally {
                    ((OutputStream)((Object)list)).close();
                }
            }
            if (!(object instanceof HttpURLConnection)) break;
            if (this.home != null && (list = ((URLConnection)object).getHeaderFields().get("Set-Cookie")) != null) {
                LOG.log(Level.FINE, "Cookies set for domain {0}: {1}", new Object[]{this.home, list});
                COOKIES.put(this.home, list.toArray(new String[list.size()]));
            }
            int n = ((HttpURLConnection)object).getResponseCode();
            LOG.log(Level.FINER, "  => {0}", n);
            switch (n) {
                case 301: 
                case 302: {
                    URL uRL = new URL(((URLConnection)object).getHeaderField("Location"));
                    object = uRL.openConnection();
                    continue block14;
                }
                case 403: {
                    if (this.auth && this.home != null) {
                        for (ConnectionAuthenticator connectionAuthenticator : Lookup.getDefault().lookupAll(ConnectionAuthenticator.class)) {
                            object2 = connectionAuthenticator.forbidden((URLConnection)object, this.home);
                            if (object2 == null) continue;
                            LOG.log(Level.FINER, "Retrying after auth from {0}", connectionAuthenticator);
                            object = object2;
                            continue block14;
                        }
                    }
                    iOException = new IOException("403 on " + this.url);
                    Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getMessage(ConnectionBuilder.class, (String)"ConnectionBuilder.log_in", (Object)this.url));
                    throw iOException;
                }
                case 404: {
                    throw new FileNotFoundException(((URL)object3).toString());
                }
                case 200: {
                    break block14;
                }
                default: {
                    throw new IOException("Server rejected connection to " + object3 + " with code " + n);
                }
            }
            break;
        }
        return object;
    }

    public HttpURLConnection httpConnection() throws IOException {
        URLConnection uRLConnection = this.connection();
        if (uRLConnection instanceof HttpURLConnection) {
            return (HttpURLConnection)uRLConnection;
        }
        throw new IOException("Not an HTTP connection: " + uRLConnection);
    }
}

