/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.uiapi;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.project.uiapi.CustomizerPane;
import org.netbeans.modules.project.uiapi.SavingProjectDataPanel;
import org.netbeans.modules.project.uiapi.Utilities;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

public class CustomizerDialog {
    private static final int OPTION_OK = 0;
    private static final int OPTION_CANCEL = 1;
    private static final String COMMAND_OK = "OK";
    private static final String COMMAND_CANCEL = "CANCEL";
    private static final String CUSTOMIZER_DIALOG_X = "CustomizerDailog.dialog.x";
    private static final String CUSTOMIZER_DIALOG_Y = "CustomizerDailog.dialog.y";
    private static final String CUSTOMIZER_DIALOG_WIDTH = "CustomizerDailog.dialog.width";
    private static final String CUSTOMIZER_DIALOG_HEIGHT = "CustomizerDailog.dialog.height";

    private CustomizerDialog() {
    }

    public static Dialog createDialog(ActionListener actionListener, ActionListener actionListener2, final CustomizerPane customizerPane, HelpCtx helpCtx, final ProjectCustomizer.Category[] categoryArray, ProjectCustomizer.CategoryComponentProvider categoryComponentProvider) {
        ListeningButton listeningButton = new ListeningButton(NbBundle.getMessage(CustomizerDialog.class, (String)"LBL_Customizer_Ok_Option"), categoryArray);
        listeningButton.setEnabled(CustomizerDialog.checkValidity(categoryArray));
        Object[] objectArray = new JButton[]{listeningButton, new JButton(NbBundle.getMessage(CustomizerDialog.class, (String)"LBL_Customizer_Cancel_Option"))};
        objectArray[0].setActionCommand(COMMAND_OK);
        objectArray[1].setActionCommand(COMMAND_CANCEL);
        objectArray[0].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerDialog.class, (String)"AD_Customizer_Ok_Option"));
        objectArray[1].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerDialog.class, (String)"AD_Customizer_Cancel_Option"));
        OptionListener optionListener = new OptionListener(actionListener, actionListener2, categoryArray, categoryComponentProvider);
        objectArray[0].addActionListener(optionListener);
        objectArray[1].addActionListener(optionListener);
        customizerPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerDialog.class, (String)"AN_ProjectCustomizer"));
        customizerPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerDialog.class, (String)"AD_ProjectCustomizer"));
        if (helpCtx == null) {
            helpCtx = HelpCtx.DEFAULT_HELP;
        }
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)customizerPane, NbBundle.getMessage(CustomizerDialog.class, (String)"LBL_Customizer_Title"), false, objectArray, (Object)objectArray[0], 0, helpCtx, null);
        customizerPane.addPropertyChangeListener(new HelpCtxChangeListener(dialogDescriptor, helpCtx));
        if (customizerPane instanceof HelpCtx.Provider) {
            dialogDescriptor.setHelpCtx(customizerPane.getHelpCtx());
        }
        dialogDescriptor.setClosingOptions(new Object[]{objectArray[0], objectArray[1]});
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        Preferences preferences = NbPreferences.forModule(CustomizerDialog.class);
        int n = preferences.getInt(CUSTOMIZER_DIALOG_X, 0);
        int n2 = preferences.getInt(CUSTOMIZER_DIALOG_Y, 0);
        int n3 = preferences.getInt(CUSTOMIZER_DIALOG_WIDTH, 0);
        int n4 = preferences.getInt(CUSTOMIZER_DIALOG_HEIGHT, 0);
        if (n3 != 0 && n4 != 0) {
            int n5;
            int n6 = WindowManager.getDefault().getMainWindow().getGraphicsConfiguration().getBounds().width;
            if (n3 > n6) {
                n3 = n6 * 3 / 4;
            }
            if (n4 > (n5 = WindowManager.getDefault().getMainWindow().getGraphicsConfiguration().getBounds().height)) {
                n4 = n5 * 3 / 4;
            }
            dialog.setBounds(n, n2, n3, n4);
        }
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                Preferences preferences = NbPreferences.forModule(CustomizerDialog.class);
                preferences.putInt(CustomizerDialog.CUSTOMIZER_DIALOG_X, windowEvent.getWindow().getX());
                preferences.putInt(CustomizerDialog.CUSTOMIZER_DIALOG_Y, windowEvent.getWindow().getY());
                preferences.putInt(CustomizerDialog.CUSTOMIZER_DIALOG_WIDTH, windowEvent.getWindow().getWidth());
                preferences.putInt(CustomizerDialog.CUSTOMIZER_DIALOG_HEIGHT, windowEvent.getWindow().getHeight());
                customizerPane.clearPanelComponentCache();
                LinkedList<ProjectCustomizer.Category> linkedList = new LinkedList<ProjectCustomizer.Category>(Arrays.asList(categoryArray));
                while (!linkedList.isEmpty()) {
                    ProjectCustomizer.Category category = (ProjectCustomizer.Category)linkedList.remove(0);
                    Utilities.removeCategoryChangeSupport(category);
                    if (category.getSubcategories() == null) continue;
                    linkedList.addAll(Arrays.asList(category.getSubcategories()));
                }
            }
        });
        return dialog;
    }

    private static boolean checkValidity(ProjectCustomizer.Category[] categoryArray) {
        for (ProjectCustomizer.Category category : categoryArray) {
            if (!category.isValid()) {
                return false;
            }
            ProjectCustomizer.Category[] categoryArray2 = category.getSubcategories();
            if (categoryArray2 == null || CustomizerDialog.checkValidity(categoryArray2)) continue;
            return false;
        }
        return true;
    }

    private static class ListeningButton
    extends JButton
    implements PropertyChangeListener {
        private ProjectCustomizer.Category[] categories;

        public ListeningButton(String string, ProjectCustomizer.Category[] categoryArray) {
            super(string);
            this.categories = categoryArray;
            for (ProjectCustomizer.Category category : categoryArray) {
                Utilities.getCategoryChangeSupport(category).addPropertyChangeListener(this);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == "isCategoryValid") {
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.setEnabled(bl && CustomizerDialog.checkValidity(this.categories));
            }
        }
    }

    private static class HelpCtxChangeListener
    implements PropertyChangeListener {
        DialogDescriptor dialogDescriptor;
        HelpCtx defaultHelpCtx;

        HelpCtxChangeListener(DialogDescriptor dialogDescriptor, HelpCtx helpCtx) {
            this.dialogDescriptor = dialogDescriptor;
            this.defaultHelpCtx = helpCtx;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("helpCtxProperty".equals(propertyChangeEvent.getPropertyName())) {
                HelpCtx helpCtx = (HelpCtx)propertyChangeEvent.getNewValue();
                this.dialogDescriptor.setHelpCtx(helpCtx == null || helpCtx == HelpCtx.DEFAULT_HELP ? this.defaultHelpCtx : helpCtx);
            }
        }
    }

    private static class OptionListener
    implements ActionListener {
        private ActionListener okOptionListener;
        private ActionListener storeListener;
        private ProjectCustomizer.Category[] categories;
        private Lookup.Provider prov;

        OptionListener(ActionListener actionListener, ActionListener actionListener2, ProjectCustomizer.Category[] categoryArray, ProjectCustomizer.CategoryComponentProvider categoryComponentProvider) {
            this.okOptionListener = actionListener;
            this.storeListener = actionListener2;
            this.categories = categoryArray;
            if (categoryComponentProvider instanceof Lookup.Provider) {
                this.prov = (Lookup.Provider)categoryComponentProvider;
            }
        }

        public void actionPerformed(final ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (CustomizerDialog.COMMAND_OK.equals(string)) {
                ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Object>(){

                    public Object run() {
                        OptionListener.this.okOptionListener.actionPerformed(actionEvent);
                        OptionListener.this.actionPerformed(actionEvent, OptionListener.this.categories);
                        return null;
                    }
                });
                final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(CustomizerDialog.class, (String)"LBL_Saving_Project_data_progress"));
                JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
                Frame frame = WindowManager.getDefault().getMainWindow();
                final JDialog jDialog = new JDialog(frame, NbBundle.getMessage(CustomizerDialog.class, (String)"LBL_Saving_Project_data"), true);
                SavingProjectDataPanel savingProjectDataPanel = new SavingProjectDataPanel(jComponent);
                jDialog.getContentPane().add(savingProjectDataPanel);
                jDialog.setDefaultCloseOperation(0);
                jDialog.pack();
                Rectangle rectangle = frame.getBounds();
                int n = rectangle.x + rectangle.width / 2;
                int n2 = rectangle.y + rectangle.height / 2;
                Dimension dimension = jDialog.getPreferredSize();
                jDialog.setBounds(n - dimension.width / 2, n2 - dimension.height / 2, dimension.width, dimension.height);
                RequestProcessor.getDefault().post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Object>(){

                                public Object run() {
                                    progressHandle.start();
                                    if (OptionListener.this.storeListener != null) {
                                        OptionListener.this.storeListener.actionPerformed(actionEvent);
                                    }
                                    OptionListener.this.storePerformed(actionEvent, OptionListener.this.categories);
                                    OptionListener.this.saveModifiedProject();
                                    return null;
                                }
                            });
                        }
                        catch (Throwable throwable) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    jDialog.setVisible(false);
                                    jDialog.dispose();
                                }
                            });
                            throw throwable;
                        }
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                });
                jDialog.setVisible(true);
            }
        }

        private void actionPerformed(ActionEvent actionEvent, ProjectCustomizer.Category[] categoryArray) {
            for (ProjectCustomizer.Category category : categoryArray) {
                ActionListener actionListener = category.getOkButtonListener();
                if (actionListener != null) {
                    actionListener.actionPerformed(actionEvent);
                }
                if (category.getSubcategories() == null) continue;
                this.actionPerformed(actionEvent, category.getSubcategories());
            }
        }

        private void storePerformed(ActionEvent actionEvent, ProjectCustomizer.Category[] categoryArray) {
            for (ProjectCustomizer.Category category : categoryArray) {
                ActionListener actionListener = category.getStoreListener();
                if (actionListener != null) {
                    actionListener.actionPerformed(actionEvent);
                }
                if (category.getSubcategories() == null) continue;
                this.storePerformed(actionEvent, category.getSubcategories());
            }
        }

        private void saveModifiedProject() {
            if (this.prov != null) {
                Project project = (Project)this.prov.getLookup().lookup(Project.class);
                if (ProjectManager.getDefault().isModified(project)) {
                    try {
                        ProjectManager.getDefault().saveProject(project);
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        Exceptions.printStackTrace((Throwable)illegalArgumentException);
                    }
                }
            }
        }
    }
}

