/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation.graph;

import java.awt.Point;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.api.visual.vmd.VMDNodeWidget;
import org.netbeans.modules.web.jsf.navigation.Page;
import org.netbeans.modules.web.jsf.navigation.PageFlowToolbarUtilities;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowScene;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageFlowSceneData {
    private final PageFlowToolbarUtilities utilities;
    private final Map<String, PageData> facesConfigSceneData = new HashMap<String, PageData>();
    private final Map<String, PageData> projectSceneData = new HashMap<String, PageData>();
    private final Map<String, PageData> allFacesConfigSceneData = new HashMap<String, PageData>();
    private static Logger LOG = Logger.getLogger(PageFlowSceneData.class.getName());

    public PageFlowSceneData(PageFlowToolbarUtilities pageFlowToolbarUtilities) {
        this.utilities = pageFlowToolbarUtilities;
    }

    public void saveCurrentSceneData(PageFlowScene pageFlowScene) {
        switch (this.utilities.getCurrentScope()) {
            case SCOPE_FACESCONFIG: {
                this.facesConfigSceneData.clear();
                this.facesConfigSceneData.putAll(this.createSceneInfo(pageFlowScene));
                break;
            }
            case SCOPE_PROJECT: {
                this.projectSceneData.clear();
                this.projectSceneData.putAll(this.createSceneInfo(pageFlowScene));
                break;
            }
            case SCOPE_ALL_FACESCONFIG: {
                this.allFacesConfigSceneData.clear();
                this.allFacesConfigSceneData.putAll(this.createSceneInfo(pageFlowScene));
                break;
            }
            default: {
                LOG.fine("PageFlowSceneData: Unknown State");
            }
        }
    }

    public void savePageWithNewName(String string, String string2) {
        this.replaceSceneInfo(this.facesConfigSceneData, string, string2);
        this.replaceSceneInfo(this.projectSceneData, string, string2);
        this.replaceSceneInfo(this.allFacesConfigSceneData, string, string2);
    }

    public void loadSceneData(PageFlowScene pageFlowScene) {
        this.loadSceneData(pageFlowScene, this.getCurrentSceneData());
    }

    public PageData getPageData(String string) {
        Map<String, PageData> map = this.getCurrentSceneData();
        PageData pageData = null;
        if (map != null) {
            pageData = map.get(string);
        }
        return pageData;
    }

    private void loadSceneData(PageFlowScene pageFlowScene, Map<String, PageData> map) {
        if (map == null) {
            return;
        }
        Collection collection = pageFlowScene.getNodes();
        for (Page page : collection) {
            PageData pageData = map.get(page.getDisplayName());
            if (pageData == null) continue;
            VMDNodeWidget vMDNodeWidget = (VMDNodeWidget)pageFlowScene.findWidget(page);
            vMDNodeWidget.setPreferredLocation(pageData.getPoint());
            vMDNodeWidget.setMinimized(pageData.isMinimized());
        }
    }

    private Map<String, PageData> createSceneInfo(PageFlowScene pageFlowScene) {
        HashMap<String, PageData> hashMap = new HashMap<String, PageData>();
        Collection collection = pageFlowScene.getNodes();
        for (Page page : collection) {
            VMDNodeWidget vMDNodeWidget = (VMDNodeWidget)pageFlowScene.findWidget(page);
            Point point = pageFlowScene.isValidated() ? vMDNodeWidget.getLocation() : vMDNodeWidget.getPreferredLocation();
            if (point == null) continue;
            hashMap.put(page.getDisplayName(), PageFlowSceneData.createPageData(point, vMDNodeWidget.isMinimized()));
        }
        return hashMap;
    }

    public String getCurrentScopeStr() {
        return PageFlowToolbarUtilities.getScopeLabel(this.utilities.getCurrentScope());
    }

    public void setCurrentScope(PageFlowToolbarUtilities.Scope scope) {
        this.utilities.setCurrentScope(scope);
    }

    public void setScopeData(PageFlowToolbarUtilities.Scope scope, Map<String, PageData> map) {
        switch (scope) {
            case SCOPE_FACESCONFIG: {
                this.facesConfigSceneData.clear();
                this.facesConfigSceneData.putAll(map);
                break;
            }
            case SCOPE_PROJECT: {
                this.projectSceneData.clear();
                this.projectSceneData.putAll(map);
                break;
            }
            case SCOPE_ALL_FACESCONFIG: {
                this.allFacesConfigSceneData.clear();
                this.allFacesConfigSceneData.putAll(map);
            }
        }
    }

    public Map<String, PageData> getScopeData(PageFlowToolbarUtilities.Scope scope) {
        Map<String, PageData> map = null;
        switch (scope) {
            case SCOPE_FACESCONFIG: {
                map = this.facesConfigSceneData;
                break;
            }
            case SCOPE_PROJECT: {
                map = this.projectSceneData;
                break;
            }
            case SCOPE_ALL_FACESCONFIG: {
                map = this.allFacesConfigSceneData;
            }
        }
        return map;
    }

    private Map<String, PageData> getCurrentSceneData() {
        Map<String, PageData> map = null;
        switch (this.utilities.getCurrentScope()) {
            case SCOPE_FACESCONFIG: {
                map = this.facesConfigSceneData;
                break;
            }
            case SCOPE_PROJECT: {
                map = this.projectSceneData;
                break;
            }
            case SCOPE_ALL_FACESCONFIG: {
                map = this.allFacesConfigSceneData;
                break;
            }
            default: {
                map = null;
            }
        }
        return map;
    }

    private void replaceSceneInfo(Map<String, PageData> map, String string, String string2) {
        assert (string != null);
        assert (string2 != null);
        if (map == null || map.size() < 1) {
            return;
        }
        PageData pageData = map.remove(string);
        if (pageData != null) {
            map.put(string2, pageData);
        }
    }

    public static PageData createPageData(Point point, boolean bl) {
        return new PageData(point, bl);
    }

    public static class PageData {
        private Point point;
        private boolean isMinimized = false;

        private PageData() {
        }

        public PageData(Point point) {
            if (point == null) {
                throw new IllegalArgumentException("Page Data does not accept null points");
            }
            this.point = point;
        }

        public PageData(Point point, boolean bl) {
            this(point);
            this.isMinimized = bl;
        }

        public Point getPoint() {
            return this.point;
        }

        public boolean isMinimized() {
            return this.isMinimized;
        }
    }
}

