/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee.db;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.eecommon.api.UrlData;
import org.netbeans.modules.glassfish.javaee.Hk2DeploymentManager;
import org.netbeans.modules.glassfish.javaee.db.DbUtil;
import org.netbeans.modules.glassfish.javaee.db.DriverMaps;
import org.netbeans.modules.glassfish.javaee.db.SunDatasource;
import org.netbeans.modules.glassfish.javaee.db.VendorNameMgr;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.TreeParser;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.common.api.DatasourceAlreadyExistsException;
import org.netbeans.modules.j2ee.deployment.plugins.spi.DatasourceManager;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hk2DatasourceManager
implements DatasourceManager {
    private static final String DOMAIN_XML_PATH = "config/domain.xml";
    private Hk2DeploymentManager dm;
    private static final String CP_TAG_1 = "    <jdbc-connection-pool allow-non-component-callers=\"false\" associate-with-thread=\"false\" connection-creation-retry-attempts=\"0\" connection-creation-retry-interval-in-seconds=\"10\" connection-leak-reclaim=\"false\" connection-leak-timeout-in-seconds=\"0\" connection-validation-method=\"auto-commit\" ";
    private static final String ATTR_DATASOURCE_CLASSNAME = "datasource-classname";
    private static final String CP_TAG_2 = "fail-all-connections=\"false\" idle-timeout-in-seconds=\"300\" is-connection-validation-required=\"false\" is-isolation-level-guaranteed=\"true\" lazy-connection-association=\"false\" lazy-connection-enlistment=\"false\" match-connections=\"false\" max-connection-usage-count=\"0\" max-pool-size=\"32\" max-wait-time-in-millis=\"60000\" ";
    private static final String ATTR_POOL_NAME = "name";
    private static final String CP_TAG_3 = "non-transactional-connections=\"false\" pool-resize-quantity=\"2\" ";
    private static final String ATTR_RES_TYPE = "res-type";
    private static final String CP_TAG_4 = "statement-timeout-in-seconds=\"-1\" steady-pool-size=\"8\" validate-atmost-once-period-in-seconds=\"0\" wrap-jdbc-objects=\"false\">\n";
    private static final String PROP_SERVER_NAME = "serverName";
    private static final String PROP_PORT_NUMBER = "portNumber";
    private static final String PROP_DATABASE_NAME = "databaseName";
    private static final String PROP_USER = "User";
    private static final String PROP_PASSWORD = "Password";
    private static final String PROP_URL = "URL";
    private static final String PROP_DRIVER_CLASS = "driverClass";
    private static final String CP_TAG_5 = "    </jdbc-connection-pool>\n";
    private static final String RESTYPE_DATASOURCE = "javax.sql.DataSource";
    private static final String JDBC_TAG_1 = "    <jdbc-resource enabled=\"true\" ";
    private static final String ATTR_POOLNAME = "pool-name";
    private static final String ATTR_JNDINAME = "jndi-name";
    private static final String JDBC_TAG_2 = " object-type=\"user\"/>\n";
    private static final String SUN_RESOURCES_XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE resources PUBLIC \"-//Sun Microsystems, Inc.//DTD Application Server 9.0 Resource Definitions //EN\" \"http://www.sun.com/software/appserver/dtds/sun-resources_1_3.dtd\">\n<resources>\n";
    private static final String SUN_RESOURCES_XML_FOOTER = "</resources>\n";

    public Hk2DatasourceManager(Hk2DeploymentManager hk2DeploymentManager) {
        this.dm = hk2DeploymentManager;
    }

    public Set<Datasource> getDatasources() throws ConfigurationException {
        GlassfishModule glassfishModule = this.dm.getCommonServerSupport();
        String string = (String)glassfishModule.getInstanceProperties().get("domainsfolder");
        String string2 = (String)glassfishModule.getInstanceProperties().get("domainname");
        File file = new File(string, string2 + File.separatorChar + DOMAIN_XML_PATH);
        return Hk2DatasourceManager.readDatasources(file, "/domain/", null);
    }

    public void deployDatasources(Set<Datasource> set) throws ConfigurationException, DatasourceAlreadyExistsException {
    }

    public static Set<Datasource> getDatasources(File file) {
        File file2 = new File(file, "sun-resources.xml");
        return Hk2DatasourceManager.readDatasources(file2, "/", file);
    }

    private static Set<Datasource> readDatasources(File file, String string, File file2) {
        HashSet<Datasource> hashSet = new HashSet<Datasource>();
        if (file.exists()) {
            HashMap<String, JdbcResource> hashMap = new HashMap<String, JdbcResource>();
            HashMap<String, ConnectionPool> hashMap2 = new HashMap<String, ConnectionPool>();
            ArrayList<TreeParser.Path> arrayList = new ArrayList<TreeParser.Path>();
            arrayList.add(new TreeParser.Path(string + "resources/jdbc-resource", (TreeParser.NodeReader)new JdbcReader(hashMap)));
            arrayList.add(new TreeParser.Path(string + "resources/jdbc-connection-pool", (TreeParser.NodeReader)new ConnectionPoolReader(hashMap2)));
            try {
                TreeParser.readXml((File)file, arrayList);
            }
            catch (IllegalStateException illegalStateException) {
                Logger.getLogger("glassfish-javaee").log(Level.INFO, illegalStateException.getLocalizedMessage(), illegalStateException);
            }
            for (JdbcResource jdbcResource : hashMap.values()) {
                ConnectionPool connectionPool = (ConnectionPool)hashMap2.get(jdbcResource.getPoolName());
                if (connectionPool == null) continue;
                connectionPool.normalize();
                String string2 = connectionPool.getProperty(PROP_URL);
                if (string2 == null || string2.equals("")) continue;
                String string3 = connectionPool.getProperty(PROP_USER);
                String string4 = connectionPool.getProperty(PROP_PASSWORD);
                String string5 = connectionPool.getProperty(PROP_DRIVER_CLASS);
                hashSet.add(new SunDatasource(jdbcResource.getJndiName(), string2, string3, string4, string5, file2));
            }
        }
        return hashSet;
    }

    public static Datasource createDataSource(String string, String string2, String string3, String string4, String string5, File file) throws ConfigurationException, DatasourceAlreadyExistsException {
        SunDatasource sunDatasource;
        Object object;
        DuplicateJdbcResourceFinder duplicateJdbcResourceFinder = new DuplicateJdbcResourceFinder(string);
        ConnectionPoolFinder connectionPoolFinder = new ConnectionPoolFinder();
        File file2 = new File(file, "sun-resources.xml");
        if (file2.exists()) {
            object = new ArrayList();
            object.add(new TreeParser.Path("/resources/jdbc-resource", (TreeParser.NodeReader)duplicateJdbcResourceFinder));
            object.add(new TreeParser.Path("/resources/jdbc-connection-pool", (TreeParser.NodeReader)connectionPoolFinder));
            try {
                TreeParser.readXml((File)file2, (List)object);
                if (duplicateJdbcResourceFinder.isDuplicate()) {
                    throw new DatasourceAlreadyExistsException((Datasource)new SunDatasource(string, string2, string3, string4, string5));
                }
            }
            catch (IllegalStateException illegalStateException) {
                Logger.getLogger("glassfish-javaee").log(Level.INFO, illegalStateException.getLocalizedMessage(), illegalStateException);
                throw new ConfigurationException(illegalStateException.getLocalizedMessage(), (Throwable)illegalStateException);
            }
        }
        try {
            object = VendorNameMgr.vendorNameFromDbUrl(string2);
            if (object == null) {
                object = string;
            } else if ("derby_embedded".equals(object)) {
                Logger.getLogger("glassfish-javaee").log(Level.WARNING, "Embedded derby not supported as a datasource");
                return null;
            }
            String string6 = Hk2DatasourceManager.computePoolName(string2, (String)object, string3);
            Map<String, CPool> map = connectionPoolFinder.getPoolData();
            CPool cPool = map.get(string6);
            String string7 = null;
            if (cPool != null && Hk2DatasourceManager.isSameDatabaseConnection(cPool, string2, string3, string4)) {
                string7 = string6;
            } else {
                for (CPool cPool2 : map.values()) {
                    if (!Hk2DatasourceManager.isSameDatabaseConnection(cPool2, string2, string3, string4)) continue;
                    string7 = cPool2.getPoolName();
                    break;
                }
            }
            if (string7 == null) {
                string7 = cPool == null ? string6 : Hk2DatasourceManager.generateUniqueName(string6, map.keySet());
                Hk2DatasourceManager.createConnectionPool(file2, string7, string2, string3, string4, string5);
            }
            Hk2DatasourceManager.createJdbcResource(file2, string, string7);
            sunDatasource = new SunDatasource(string, string2, string3, string4, string5, file);
        }
        catch (IOException iOException) {
            Logger.getLogger("glassfish-javaee").log(Level.INFO, iOException.getLocalizedMessage(), iOException);
            throw new ConfigurationException(iOException.getLocalizedMessage(), (Throwable)iOException);
        }
        return sunDatasource;
    }

    private static String generateUniqueName(String string, Set<String> set) {
        int n = 1;
        String string2;
        while (set.contains(string2 = string + "_" + n)) {
            ++n;
        }
        return string2;
    }

    private static boolean isSameDatabaseConnection(CPool cPool, String string, String string2, String string3) {
        boolean bl = false;
        boolean bl2 = false;
        UrlData urlData = new UrlData(string);
        bl2 = DbUtil.strEmpty(cPool.getUrl()) ? DbUtil.strEquivalent(urlData.getHostName(), cPool.getHostname()) && DbUtil.strEquivalent(urlData.getPort(), cPool.getPort()) && DbUtil.strEquivalent(urlData.getDatabaseName(), cPool.getDatabaseName()) && DbUtil.strEquivalent(urlData.getSid(), cPool.getSid()) : DbUtil.strEquivalent(string, cPool.getUrl());
        if (bl2 && DbUtil.strEquivalent(string2, cPool.getUsername()) && DbUtil.strEquivalent(string3, cPool.getPassword())) {
            bl = true;
        }
        return bl;
    }

    public static void createConnectionPool(File file, String string, String string2, String string3, String string4, String string5) throws IOException {
        UrlData urlData = new UrlData(string2);
        String string6 = Hk2DatasourceManager.computeDataSourceClassName(string2, string5);
        StringBuilder stringBuilder = new StringBuilder(2000);
        stringBuilder.append(CP_TAG_1);
        Hk2DatasourceManager.appendAttr(stringBuilder, ATTR_DATASOURCE_CLASSNAME, string6, false);
        stringBuilder.append(CP_TAG_2);
        Hk2DatasourceManager.appendAttr(stringBuilder, ATTR_POOL_NAME, string, true);
        stringBuilder.append(CP_TAG_3);
        Hk2DatasourceManager.appendAttr(stringBuilder, ATTR_RES_TYPE, RESTYPE_DATASOURCE, true);
        stringBuilder.append(CP_TAG_4);
        Hk2DatasourceManager.appendProperty(stringBuilder, PROP_SERVER_NAME, urlData.getHostName(), true);
        Hk2DatasourceManager.appendProperty(stringBuilder, PROP_PORT_NUMBER, urlData.getPort(), false);
        Hk2DatasourceManager.appendProperty(stringBuilder, PROP_DATABASE_NAME, urlData.getDatabaseName(), false);
        Hk2DatasourceManager.appendProperty(stringBuilder, PROP_USER, string3, true);
        if (string4 != null) {
            Hk2DatasourceManager.appendProperty(stringBuilder, PROP_PASSWORD, string4, true);
        }
        Hk2DatasourceManager.appendProperty(stringBuilder, PROP_URL, string2, true);
        Hk2DatasourceManager.appendProperty(stringBuilder, PROP_DRIVER_CLASS, string5, true);
        stringBuilder.append(CP_TAG_5);
        String string7 = stringBuilder.toString();
        Logger.getLogger("glassfish-javaee").log(Level.FINER, "New connection pool resource:\n" + string7);
        Hk2DatasourceManager.appendResource(file, string7);
    }

    private static String computeDataSourceClassName(String string, String string2) {
        String string3 = VendorNameMgr.vendorNameFromDbUrl(string);
        String string4 = VendorNameMgr.dsClassNameFromVendorName(string3);
        if (!(string4 != null && string4.length() != 0 || (string4 = DriverMaps.getDSClassName(string)) != null && string4.length() != 0)) {
            string4 = string2;
        }
        return string4;
    }

    private static String computePoolName(String string, String string2, String string3) {
        UrlData urlData = new UrlData(string);
        StringBuilder stringBuilder = new StringBuilder(string2);
        String string4 = Hk2DatasourceManager.getDatabaseName(urlData);
        if (string4 != null) {
            stringBuilder.append("_" + string4);
        }
        if (string3 != null) {
            stringBuilder.append("_" + string3);
        }
        stringBuilder.append("Pool");
        return stringBuilder.toString();
    }

    private static String getDatabaseName(UrlData urlData) {
        String string = urlData.getDatabaseName();
        if (string == null) {
            string = urlData.getAlternateDBName();
        }
        return string;
    }

    public static void createJdbcResource(File file, String string, String string2) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(500);
        stringBuilder.append(JDBC_TAG_1);
        Hk2DatasourceManager.appendAttr(stringBuilder, ATTR_POOLNAME, string2, true);
        Hk2DatasourceManager.appendAttr(stringBuilder, ATTR_JNDINAME, string, true);
        stringBuilder.append(JDBC_TAG_2);
        String string3 = stringBuilder.toString();
        Logger.getLogger("glassfish-javaee").log(Level.FINER, "New JDBC resource:\n" + string3);
        Hk2DatasourceManager.appendResource(file, string3);
    }

    private static void appendAttr(StringBuilder stringBuilder, String string, String string2, boolean bl) {
        if (bl || string != null && string.length() > 0) {
            stringBuilder.append(string);
            stringBuilder.append("=\"");
            stringBuilder.append(string2);
            stringBuilder.append("\" ");
        }
    }

    private static void appendProperty(StringBuilder stringBuilder, String string, String string2, boolean bl) {
        if (bl || string2 != null && string2.length() > 0) {
            stringBuilder.append("        <property name=\"");
            stringBuilder.append(string);
            stringBuilder.append("\" value=\"");
            stringBuilder.append(string2);
            stringBuilder.append("\"/>\n");
        }
    }

    private static void appendResource(File file, String string) throws IOException {
        String string2 = Hk2DatasourceManager.readResourceFile(file);
        string2 = Hk2DatasourceManager.insertFragment(string2, string);
        Hk2DatasourceManager.writeResourceFile(file, string2);
    }

    private static String insertFragment(String string, String string2) throws IOException {
        int n;
        String string3 = SUN_RESOURCES_XML_HEADER;
        String string4 = SUN_RESOURCES_XML_FOOTER;
        boolean bl = false;
        if (string != null) {
            n = string.indexOf("</resources>");
            if (n == -1) {
                throw new IOException("Malformed XML");
            }
            string3 = string.substring(0, n);
            string4 = string.substring(n);
            if (n > 0 && string.charAt(n - 1) != '\n') {
                bl = true;
            }
        }
        n = string3.length() + string4.length() + 2;
        if (string2 != null) {
            n += string2.length();
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        stringBuilder.append(string3);
        if (bl) {
            String string5 = System.getProperty("line.separator");
            stringBuilder.append(string5 != null ? string5 : "\n");
        }
        if (string2 != null) {
            stringBuilder.append(string2);
        }
        stringBuilder.append(string4);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String readResourceFile(File file) throws IOException {
        String string = null;
        if (!file.exists()) return string;
        FileObject fileObject = FileUtil.toFileObject((File)(file = FileUtil.normalizeFile((File)file)));
        if (fileObject == null) throw new IOException("Unable to get FileObject for " + file.getAbsolutePath());
        InputStream inputStream = null;
        Reader reader = null;
        try {
            String string2;
            long l = fileObject.getSize();
            if (l > 1000000L) {
                throw new IOException(file.getAbsolutePath() + " is too long to update.");
            }
            int n = (int)(2L * l + 32L);
            char[] cArray = new char[n];
            inputStream = new BufferedInputStream(fileObject.getInputStream());
            reader = new InputStreamReader(inputStream, string2 = EncodingUtil.detectEncoding((InputStream)inputStream));
            int n2 = reader.read(cArray);
            if (n2 <= 0) return string;
            string = new String(cArray, 0, n2);
            return string;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void writeResourceFile(File file, String string) throws IOException {
        FileObject fileObject = FileUtil.createFolder((File)file.getParentFile());
        FileSystem fileSystem = fileObject.getFileSystem();
        Hk2DatasourceManager.writeResourceFile(fileSystem, file, string);
    }

    private static void writeResourceFile(FileSystem fileSystem, final File file, final String string) throws IOException {
        fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                FileLock fileLock = null;
                BufferedWriter bufferedWriter = null;
                try {
                    FileObject fileObject = FileUtil.createData((File)file);
                    fileLock = fileObject.lock();
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileObject.getOutputStream(fileLock)));
                    bufferedWriter.write(string);
                }
                finally {
                    if (bufferedWriter != null) {
                        try {
                            bufferedWriter.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (fileLock != null) {
                        fileLock.releaseLock();
                    }
                }
            }
        });
    }

    private static class CPool {
        private final String poolName;
        private final String url;
        private final String hostname;
        private final String port;
        private final String databaseName;
        private final String username;
        private final String password;
        private final String sid;

        public CPool(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
            this.poolName = string;
            this.url = string2;
            this.hostname = string3;
            this.port = string4;
            this.databaseName = string5;
            this.username = string6;
            this.password = string7;
            this.sid = string8;
        }

        public String getPoolName() {
            return this.poolName;
        }

        public String getUrl() {
            return this.url;
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public String getHostname() {
            return this.hostname;
        }

        public String getPassword() {
            return this.password;
        }

        public String getPort() {
            return this.port;
        }

        public String getSid() {
            return this.sid;
        }

        public String getUsername() {
            return this.username;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConnectionPoolFinder
    extends TreeParser.NodeReader {
        private Map<String, String> properties = null;
        private Map<String, CPool> pools = new HashMap<String, CPool>();

        private ConnectionPoolFinder() {
        }

        public void readAttributes(String string, Attributes attributes) throws SAXException {
            this.properties = new HashMap<String, String>();
            String string2 = attributes.getValue(Hk2DatasourceManager.ATTR_POOL_NAME);
            if (string2 != null && string2.length() > 0) {
                if (!this.pools.containsKey(string2)) {
                    this.properties.put(Hk2DatasourceManager.ATTR_POOL_NAME, string2);
                } else {
                    Logger.getLogger("glassfish-javaee").log(Level.WARNING, "Duplicate pool-names defined for JDBC Connection Pools.");
                }
            }
        }

        public void readChildren(String string, Attributes attributes) throws SAXException {
            this.properties.put(attributes.getValue(Hk2DatasourceManager.ATTR_POOL_NAME).toLowerCase(Locale.ENGLISH), attributes.getValue("value"));
        }

        public void endNode(String string) throws SAXException {
            String string2 = this.properties.get(Hk2DatasourceManager.ATTR_POOL_NAME);
            CPool cPool = new CPool(string2, this.properties.get("url"), this.properties.get("servername"), this.properties.get("portnumber"), this.properties.get("databasename"), this.properties.get("user"), this.properties.get("password"), this.properties.get("connectionattributes"));
            this.pools.put(string2, cPool);
        }

        public List<String> getPoolNames() {
            return new ArrayList<String>(this.pools.keySet());
        }

        public Map<String, CPool> getPoolData() {
            return Collections.unmodifiableMap(this.pools);
        }
    }

    private static class DuplicateJdbcResourceFinder
    extends TreeParser.NodeReader {
        private final String targetJndiName;
        private boolean duplicate;
        private String poolName;

        public DuplicateJdbcResourceFinder(String string) {
            this.targetJndiName = string;
            this.duplicate = false;
            this.poolName = null;
        }

        public void readAttributes(String string, Attributes attributes) throws SAXException {
            String string2 = attributes.getValue(Hk2DatasourceManager.ATTR_JNDINAME);
            if (this.targetJndiName.equals(string2)) {
                if (this.duplicate) {
                    Logger.getLogger("glassfish-javaee").log(Level.WARNING, "Duplicate jndi-names defined for JDBC resources.");
                }
                this.duplicate = true;
                this.poolName = attributes.getValue(Hk2DatasourceManager.ATTR_POOLNAME);
            }
        }

        public boolean isDuplicate() {
            return this.duplicate;
        }

        public String getPoolName() {
            return this.poolName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConnectionPoolReader
    extends TreeParser.NodeReader {
        private Map<String, ConnectionPool> resourceMap;
        private ConnectionPool currentPool;

        public ConnectionPoolReader(Map<String, ConnectionPool> map) {
            this.resourceMap = map;
        }

        public void readAttributes(String string, Attributes attributes) throws SAXException {
            String string2 = attributes.getValue(Hk2DatasourceManager.ATTR_POOL_NAME);
            if (string2 != null && string2.length() > 0) {
                this.currentPool = new ConnectionPool(string2);
                this.currentPool.setProperty("dsClassName", attributes.getValue(Hk2DatasourceManager.ATTR_DATASOURCE_CLASSNAME));
                this.currentPool.setProperty("resType", attributes.getValue(Hk2DatasourceManager.ATTR_RES_TYPE));
                this.resourceMap.put(string2, this.currentPool);
            } else {
                this.currentPool = null;
            }
        }

        public void readChildren(String string, Attributes attributes) throws SAXException {
            String string2;
            if (this.currentPool != null && (string2 = attributes.getValue(Hk2DatasourceManager.ATTR_POOL_NAME)) != null && string2.length() > 0) {
                this.currentPool.setProperty(string2, attributes.getValue("value"));
            }
        }
    }

    private static class ConnectionPool {
        private final Map<String, String> properties = new HashMap<String, String>();

        public ConnectionPool(String string) {
        }

        public void setProperty(String string, String string2) {
            this.properties.put(string, string2);
        }

        public String getProperty(String string) {
            return this.properties.get(string);
        }

        public void normalize() {
            DbUtil.normalizePoolMap(this.properties);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JdbcReader
    extends TreeParser.NodeReader {
        private final Map<String, JdbcResource> resourceMap;

        public JdbcReader(Map<String, JdbcResource> map) {
            this.resourceMap = map;
        }

        public void readAttributes(String string, Attributes attributes) throws SAXException {
            String string2 = attributes.getValue("object-type");
            if (string2 != null && string2.startsWith("system-")) {
                return;
            }
            String string3 = attributes.getValue(Hk2DatasourceManager.ATTR_JNDINAME);
            String string4 = attributes.getValue(Hk2DatasourceManager.ATTR_POOLNAME);
            if (string3 != null && string3.length() > 0 && string4 != null && string4.length() > 0) {
                this.resourceMap.put(string4, new JdbcResource(string3, string4));
            }
        }
    }

    private static class JdbcResource {
        private final String jndiName;
        private final String poolName;

        public JdbcResource(String string) {
            this(string, "");
        }

        public JdbcResource(String string, String string2) {
            this.jndiName = string;
            this.poolName = string2;
        }

        public String getJndiName() {
            return this.jndiName;
        }

        public String getPoolName() {
            return this.poolName;
        }
    }
}

