/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee.db;

import java.io.File;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.DeploymentManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.glassfish.eecommon.api.DomainEditor;
import org.netbeans.modules.glassfish.javaee.Hk2DeploymentManager;
import org.netbeans.modules.glassfish.javaee.JavaEEServerModule;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.ServerCommand;
import org.netbeans.modules.glassfish.spi.ServerUtilities;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.openide.util.Lookup;

public class ResourcesHelper {
    public static void addSampleDatasource(J2eeModule j2eeModule) {
        File file = j2eeModule.getResourceDirectory();
        if (null != file && file.exists()) {
            file = file.getParentFile();
        }
        if (null != file) {
            Project project = FileOwnerQuery.getOwner((URI)file.toURI());
            if (null != project) {
                DeploymentManager deploymentManager;
                J2eeModuleProvider j2eeModuleProvider = ResourcesHelper.getProvider(project);
                if (null != j2eeModuleProvider && (deploymentManager = ResourcesHelper.getDeploymentManager(j2eeModuleProvider)) instanceof Hk2DeploymentManager) {
                    GlassfishModule glassfishModule = ((Hk2DeploymentManager)deploymentManager).getCommonServerSupport();
                    String string = (String)glassfishModule.getInstanceProperties().get("domainsfolder");
                    String string2 = (String)glassfishModule.getInstanceProperties().get("domainname");
                    if (glassfishModule.getServerState() != GlassfishModule.ServerState.RUNNING) {
                        DomainEditor domainEditor = new DomainEditor(string, string2, false);
                        domainEditor.createSampleDatasource();
                    } else {
                        ResourcesHelper.registerSampleResource(glassfishModule);
                    }
                }
            } else {
                Logger.getLogger("glassfish-javaee").finer("Could not find project for J2eeModule");
            }
        } else {
            Logger.getLogger("glassfish-javaee").finer("Could not find project root directory for J2eeModule");
        }
    }

    private static J2eeModuleProvider getProvider(Project project) {
        J2eeModuleProvider j2eeModuleProvider = null;
        if (project != null) {
            Lookup lookup = project.getLookup();
            j2eeModuleProvider = (J2eeModuleProvider)lookup.lookup(J2eeModuleProvider.class);
        }
        return j2eeModuleProvider;
    }

    private static DeploymentManager getDeploymentManager(J2eeModuleProvider j2eeModuleProvider) {
        DeploymentManager deploymentManager = null;
        InstanceProperties instanceProperties = j2eeModuleProvider.getInstanceProperties();
        if (instanceProperties != null) {
            deploymentManager = instanceProperties.getDeploymentManager();
        }
        return deploymentManager;
    }

    private static DeploymentManager getDeploymentManager(J2eeModule j2eeModule) {
        DeploymentManager deploymentManager = null;
        File file = j2eeModule.getResourceDirectory();
        if (null != file && file.exists()) {
            file = file.getParentFile();
        }
        if (null != file) {
            Project project = FileOwnerQuery.getOwner((URI)file.toURI());
            if (null != project) {
                J2eeModuleProvider j2eeModuleProvider = ResourcesHelper.getProvider(project);
                if (null != j2eeModuleProvider) {
                    deploymentManager = ResourcesHelper.getDeploymentManager(j2eeModuleProvider);
                }
            } else {
                Logger.getLogger("glassfish-javaee").finer("Could not find project for J2eeModule");
            }
        } else {
            Logger.getLogger("glassfish-javaee").finer("Could not find project root directory for J2eeModule");
        }
        return deploymentManager;
    }

    public static boolean isEE6(J2eeModule j2eeModule) {
        boolean bl = false;
        DeploymentManager deploymentManager = ResourcesHelper.getDeploymentManager(j2eeModule);
        if (deploymentManager instanceof Hk2DeploymentManager) {
            JavaEEServerModule javaEEServerModule;
            Hk2DeploymentManager hk2DeploymentManager = (Hk2DeploymentManager)deploymentManager;
            ServerInstance serverInstance = hk2DeploymentManager.getServerInstance();
            Lookup lookup = ServerUtilities.getEe6Utilities().getLookupFor(serverInstance);
            if (lookup != null && (javaEEServerModule = (JavaEEServerModule)lookup.lookup(JavaEEServerModule.class)) != null) {
                bl = true;
            }
        }
        return bl;
    }

    private static void registerSampleResource(GlassfishModule glassfishModule) {
        String string = "SamplePool";
        String string2 = "jdbc/sample";
        String string3 = "org.apache.derby.jdbc.ClientDataSource";
        String string4 = "javax.sql.DataSource";
        String string5 = "DatabaseName=sample:User=app:Password=app:PortNumber=1527:serverName=localhost:URL=jdbc\\:derby\\://localhost\\:1527/sample";
        Map map = glassfishModule.getResourcesMap("jdbc-resource");
        if (!map.containsKey(string2)) {
            CreateJDBCConnectionPoolCommand createJDBCConnectionPoolCommand = new CreateJDBCConnectionPoolCommand(string, string3, string4, string5);
            Future future = glassfishModule.execute((ServerCommand)createJDBCConnectionPoolCommand);
            try {
                if (future.get(60L, TimeUnit.SECONDS) == GlassfishModule.OperationState.COMPLETED) {
                    CreateJDBCResourceCommand createJDBCResourceCommand = new CreateJDBCResourceCommand(string2, string);
                    glassfishModule.execute((ServerCommand)createJDBCResourceCommand);
                }
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger("glassfish-javaee").log(Level.SEVERE, interruptedException.getLocalizedMessage(), interruptedException);
            }
            catch (ExecutionException executionException) {
                Logger.getLogger("glassfish-javaee").log(Level.SEVERE, executionException.getLocalizedMessage(), executionException);
            }
            catch (TimeoutException timeoutException) {
                Logger.getLogger("glassfish-javaee").log(Level.SEVERE, timeoutException.getLocalizedMessage(), timeoutException);
            }
        }
    }

    public static final class CreateConnectorCommand
    extends ServerCommand {
        public CreateConnectorCommand(String string, String string2, String string3) {
            super("create-connector-resource");
            StringBuilder stringBuilder = new StringBuilder(128);
            if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
                stringBuilder.append("enabled=true");
                stringBuilder.append("&poolname=" + string2);
                stringBuilder.append("&property=" + string3);
                stringBuilder.append("&jndi_name=");
                stringBuilder.append(string);
                this.query = stringBuilder.toString();
            }
        }
    }

    public static final class CreateConnectorConnectionPoolCommand
    extends ServerCommand {
        public CreateConnectorConnectionPoolCommand(String string, String string2, String string3, String string4, String string5) {
            super("create-connector-connection-pool");
            StringBuilder stringBuilder = new StringBuilder(128);
            if (string != null && string.length() > 0 && string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0) {
                stringBuilder.append("raname=" + string2);
                stringBuilder.append("&connectiondefinition=" + string3);
                stringBuilder.append("&property=" + string5);
                stringBuilder.append("&poolname=");
                stringBuilder.append(string);
                this.query = stringBuilder.toString();
            }
        }
    }

    public static final class CreateAdminObjectCommand
    extends ServerCommand {
        public CreateAdminObjectCommand(String string, String string2, String string3, String string4) {
            super("create-admin-object");
            StringBuilder stringBuilder = new StringBuilder(128);
            if (string != null && string.length() > 0 && string3 != null && string3.length() > 0 && string2 != null && string2.length() > 0) {
                stringBuilder.append("enabled=true");
                stringBuilder.append("&restype=" + string3);
                stringBuilder.append("&raname=" + string3);
                stringBuilder.append("&property=" + string2);
                stringBuilder.append("&jndi_name=");
                stringBuilder.append(string);
                this.query = stringBuilder.toString();
            }
        }
    }

    public static final class CreateJDBCResourceCommand
    extends ServerCommand {
        public CreateJDBCResourceCommand(String string, String string2) {
            super("create-jdbc-resource");
            StringBuilder stringBuilder = new StringBuilder(128);
            stringBuilder.append("connectionpoolid=" + string2);
            stringBuilder.append("&jndi_name=");
            stringBuilder.append(string);
            this.query = stringBuilder.toString();
        }
    }

    public static final class CreateJDBCConnectionPoolCommand
    extends ServerCommand {
        public CreateJDBCConnectionPoolCommand(String string, String string2, String string3, String string4) {
            super("create-jdbc-connection-pool");
            StringBuilder stringBuilder = new StringBuilder(128);
            if (string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0 && string != null && string.length() > 0) {
                stringBuilder.append("datasourceclassname=" + string2);
                stringBuilder.append("&restype=" + string3);
                stringBuilder.append("&property=" + string4);
                stringBuilder.append("&jdbc_connection_pool_id=");
                stringBuilder.append(string);
                this.query = stringBuilder.toString();
            }
        }
    }
}

