/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.File;
import java.io.FileWriter;
import java.util.Arrays;
import java.util.Stack;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.TopSecurityManager;

public class StartLog {
    private static final Logger LOG = Logger.getLogger("org.netbeans.log.startup");
    private static final Stack<String> actions = new Stack();
    private static final Stack<Throwable> places = new Stack();
    private static final boolean DEBUG_NESTING = Boolean.getBoolean("org.netbeans.log.startup.debug");
    private static final String logProp = System.getProperty("org.netbeans.log.startup");
    private static final String logFileProp = System.getProperty("org.netbeans.log.startup.logfile");
    static final Handler impl;

    static void register() {
        LOG.setUseParentHandlers(false);
        LOG.addHandler(impl);
        LOG.setLevel(impl.getLevel());
    }

    public static void logStart(String string) {
        if (StartLog.willLog()) {
            LOG.log(Level.FINE, "start", string);
            actions.push(string);
            if (DEBUG_NESTING) {
                places.push(new Throwable("logStart called here:"));
            }
        }
    }

    public static void logProgress(String string) {
        if (StartLog.willLog()) {
            LOG.log(Level.FINE, "progress", string);
        }
    }

    public static void logEnd(String string) {
        if (StartLog.willLog()) {
            Throwable throwable;
            String string2 = actions.empty() ? null : actions.pop();
            Throwable throwable2 = throwable = DEBUG_NESTING && !places.empty() ? places.pop() : null;
            if (!string.equals(string2)) {
                if (throwable != null) {
                    throwable.printStackTrace();
                } else {
                    System.err.println("Either ending too soon, or no info about caller of unmatched start log.");
                    System.err.println("Try running with -J-Dorg.netbeans.log.startup.debug=true");
                }
                Error error = new Error("StartLog mismatch: ending '" + string + "' but expecting '" + string2 + "'; rest of stack: " + actions);
                error.printStackTrace();
                System.err.flush();
                TopSecurityManager.exit((int)1);
            }
            LOG.log(Level.FINE, "end", string);
        }
    }

    public static boolean willLog() {
        return LOG.isLoggable(Level.FINE);
    }

    public static void logMeasuredStartupTime(long l) {
        LOG.log(Level.FINE, "finish", l);
    }

    static {
        if (logProp == null) {
            impl = new StartImpl();
        } else if ("print".equals(logProp)) {
            impl = new PrintImpl();
        } else if ("tests".equals(logProp)) {
            impl = new PerformanceTestsImpl();
        } else {
            throw new Error("Unknown org.netbeans.log.startup value [" + logProp + "], it should be (print or tests) !");
        }
        StartLog.register();
    }

    private static class PerformanceTestsImpl
    extends StartImpl {
        private StringBuffer logs = new StringBuffer();
        private Stack<Long> starts = new Stack();
        long prog;
        private int indent = 0;
        private char[] spaces = new char[0];

        PerformanceTestsImpl() {
        }

        synchronized void start(String string, long l) {
            this.starts.push(l);
            this.prog = l;
            this.log(this.getIndentString(this.indent) + "@" + (l - this.zero) + " - " + string + " started");
            this.indent += 2;
        }

        synchronized void progress(String string, long l) {
            this.log(this.getIndentString(this.indent) + "@" + (l - this.zero) + " - " + string + " dT=" + (l - this.prog));
            this.prog = l;
        }

        synchronized void end(String string, long l) {
            this.indent -= 2;
            long l2 = this.starts.pop();
            this.prog = l;
            this.log(this.getIndentString(this.indent) + "@" + (l - this.zero) + " - " + string + " finished, took " + (l - l2) + "ms");
        }

        boolean willLog() {
            return true;
        }

        private String getIndentString(int n) {
            if (this.spaces.length < n) {
                this.spaces = new char[Math.max(this.spaces.length * 2, n + 10)];
                Arrays.fill(this.spaces, ' ');
            }
            return new String(this.spaces, 0, n);
        }

        synchronized void log(String string) {
            this.logs.append("\n" + string);
        }

        public void publish(LogRecord logRecord) {
            super.publish(logRecord);
            if ("finish".equals(logRecord.getMessage())) {
                long l = (Long)logRecord.getParameters()[0];
                this.log("IDE starts t = " + Long.toString(this.zero) + "\nIDE is running t=" + Long.toString(l) + "\n");
            }
        }

        public synchronized void flush() {
            if (logFileProp != null) {
                try {
                    File file = new File(logFileProp);
                    FileWriter fileWriter = new FileWriter(file);
                    fileWriter.write(this.logs.toString());
                    fileWriter.close();
                }
                catch (Exception exception) {
                    System.err.println("EXCEPTION rises during startup logging:");
                    exception.printStackTrace(System.err);
                }
            } else {
                throw new IllegalStateException("You are trying to log startup logs to unexisting file. You have to set property org.netbeans.log.startup.logfile.");
            }
        }
    }

    private static class PrintImpl
    extends StartImpl {
        private Stack<Long> starts = new Stack();
        long prog;
        private int indent = 0;
        private char[] spaces = new char[0];

        PrintImpl() {
        }

        synchronized void start(String string, long l) {
            this.starts.push(l);
            this.prog = l;
            System.err.println(this.getIndentString(this.indent) + "@" + (l - this.zero) + " - " + string + " started");
            this.indent += 2;
        }

        synchronized void progress(String string, long l) {
            System.err.println(this.getIndentString(this.indent) + "@" + (l - this.zero) + " - " + string + " dT=" + (l - this.prog));
            this.prog = l;
        }

        synchronized void end(String string, long l) {
            this.indent -= 2;
            long l2 = this.starts.pop();
            this.prog = l;
            System.err.println(this.getIndentString(this.indent) + "@" + (l - this.zero) + " - " + string + " finished, took " + (l - l2) + "ms");
        }

        boolean willLog() {
            return true;
        }

        private String getIndentString(int n) {
            if (this.spaces.length < n) {
                this.spaces = new char[Math.max(this.spaces.length * 2, n + 10)];
                Arrays.fill(this.spaces, ' ');
            }
            return new String(this.spaces, 0, n);
        }
    }

    private static class StartImpl
    extends Handler {
        final long zero = System.nanoTime() / 1000000L;

        StartImpl() {
        }

        void start(String string, long l) {
        }

        void progress(String string, long l) {
        }

        void end(String string, long l) {
        }

        boolean willLog() {
            return false;
        }

        public Level getLevel() {
            return this.willLog() ? Level.FINEST : Level.OFF;
        }

        public void publish(LogRecord logRecord) {
            Object[] objectArray = logRecord.getParameters();
            String string = objectArray.length >= 1 && objectArray[0] instanceof String ? (String)objectArray[0] : "";
            long l = System.nanoTime() / 1000000L;
            if ("start".equals(logRecord.getMessage())) {
                this.start(string, l);
                return;
            }
            if ("end".equals(logRecord.getMessage())) {
                this.end(string, l);
                return;
            }
            if ("progress".equals(logRecord.getMessage())) {
                this.progress(string, l);
                return;
            }
        }

        public void flush() {
        }

        public final void close() throws SecurityException {
        }
    }
}

