/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.startup.Main;
import org.netbeans.core.startup.StartLog;
import org.netbeans.core.startup.layers.LayerCacheManager;
import org.netbeans.core.startup.layers.SystemFileSystem;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.XMLFileSystem;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbCollections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleLayeredFileSystem
extends MultiFileSystem
implements LookupListener {
    private static final long serialVersionUID = 782910986724201983L;
    static final Logger err = Logger.getLogger("org.netbeans.core.projects");
    private static Lookup.Result<FileSystem> result = Lookup.getDefault().lookupResult(FileSystem.class);
    private List<URL> urls;
    private LayerCacheManager manager;
    private final FileSystem writableLayer;
    private FileSystem cacheLayer;
    private final FileSystem[] otherLayers;
    private final boolean addLookupBefore;

    ModuleLayeredFileSystem(FileSystem fileSystem, boolean bl, FileSystem[] fileSystemArray, boolean bl2) throws IOException {
        this(fileSystem, bl, fileSystemArray, LayerCacheManager.manager(bl2));
    }

    private ModuleLayeredFileSystem(FileSystem fileSystem, boolean bl, FileSystem[] fileSystemArray, LayerCacheManager layerCacheManager) throws IOException {
        this(fileSystem, bl, fileSystemArray, layerCacheManager, layerCacheManager.loadCache());
    }

    private ModuleLayeredFileSystem(FileSystem fileSystem, boolean bl, FileSystem[] fileSystemArray, LayerCacheManager layerCacheManager, FileSystem fileSystem2) throws IOException {
        super(ModuleLayeredFileSystem.appendLayers(fileSystem, bl, fileSystemArray, fileSystem2 == null ? layerCacheManager.createEmptyFileSystem() : fileSystem2, bl));
        this.manager = layerCacheManager;
        this.writableLayer = fileSystem;
        this.otherLayers = fileSystemArray;
        this.cacheLayer = fileSystem2;
        this.addLookupBefore = bl;
        this.setPropagateMasks(true);
        this.urls = null;
        result.addLookupListener((LookupListener)this);
        result.allItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileSystem[] appendLayers(FileSystem fileSystem, boolean bl, FileSystem[] fileSystemArray, FileSystem fileSystem2, boolean bl2) {
        ArrayList<Object> arrayList = new ArrayList<Object>(fileSystemArray.length + 2);
        arrayList.add(fileSystem);
        if (bl) {
            for (Object object : result.allInstances()) {
                if (Boolean.TRUE.equals(object.getRoot().getAttribute("fallback"))) continue;
                arrayList.add(object);
            }
        }
        arrayList.addAll(Arrays.asList(fileSystemArray));
        arrayList.add(fileSystem2);
        if (bl2) {
            Object object;
            Iterator<URL> iterator = new ArrayList();
            object = Thread.currentThread().getContextClassLoader();
            try {
                for (URL uRL : NbCollections.iterable(((ClassLoader)object).getResources("META-INF/MANIFEST.MF"))) {
                    InputStream inputStream = uRL.openStream();
                    try {
                        Manifest manifest = new Manifest(inputStream);
                        String string = manifest.getMainAttributes().getValue("OpenIDE-Module-Layer");
                        if (string == null) continue;
                        URL uRL2 = ((ClassLoader)object).getResource(string);
                        if (uRL2 != null) {
                            iterator.add(uRL2);
                            continue;
                        }
                        err.warning("No such layer: " + string);
                    }
                    finally {
                        inputStream.close();
                    }
                }
                for (URL uRL : NbCollections.iterable(((ClassLoader)object).getResources("META-INF/generated-layer.xml"))) {
                    iterator.add(uRL);
                }
                XMLFileSystem xMLFileSystem = new XMLFileSystem();
                xMLFileSystem.setXmlUrls(iterator.toArray((URL[])new URL[iterator.size()]));
                arrayList.add(xMLFileSystem);
                err.log(Level.FINE, "Loading classpath layers: {0}", iterator);
            }
            catch (Exception exception) {
                err.log(Level.WARNING, "Setting layer URLs: " + iterator, exception);
            }
        }
        if (!bl) {
            for (Object object : result.allInstances()) {
                if (!Boolean.TRUE.equals(object.getRoot().getAttribute("fallback"))) continue;
                arrayList.add(object);
            }
        }
        return arrayList.toArray(new FileSystem[arrayList.size()]);
    }

    public final FileSystem[] getLayers() {
        return this.getDelegates();
    }

    final FileSystem getWritableLayer() {
        return this.writableLayer;
    }

    public static ModuleLayeredFileSystem getInstallationModuleLayer() {
        SystemFileSystem systemFileSystem;
        try {
            systemFileSystem = (SystemFileSystem)FileUtil.getConfigRoot().getFileSystem();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            throw new AssertionError((Object)fileStateInvalidException);
        }
        ModuleLayeredFileSystem moduleLayeredFileSystem = systemFileSystem.getInstallationLayer();
        if (moduleLayeredFileSystem != null) {
            return moduleLayeredFileSystem;
        }
        return systemFileSystem.getUserLayer();
    }

    public static ModuleLayeredFileSystem getUserModuleLayer() {
        SystemFileSystem systemFileSystem;
        try {
            systemFileSystem = (SystemFileSystem)FileUtil.getConfigRoot().getFileSystem();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            throw new AssertionError((Object)fileStateInvalidException);
        }
        return systemFileSystem.getUserLayer();
    }

    public void setURLs(List<URL> list) throws Exception {
        if (list.contains(null)) {
            throw new NullPointerException("urls=" + list);
        }
        if (err.isLoggable(Level.FINE)) {
            err.fine("setURLs: " + list);
        }
        if (this.urls != null && ((Object)list).equals(this.urls)) {
            err.fine("no-op");
            return;
        }
        StartLog.logStart("setURLs");
        if (this.urls != null || this.cacheLayer == null) {
            if (this.cacheLayer == null) {
                this.cacheLayer = this.manager.createEmptyFileSystem();
            }
            this.cacheLayer = this.manager.store(this.cacheLayer, list);
            err.log(Level.FINEST, "changing delegates");
            this.setDelegates(ModuleLayeredFileSystem.appendLayers(this.writableLayer, this.addLookupBefore, this.otherLayers, this.cacheLayer, false));
            err.log(Level.FINEST, "delegates changed");
        }
        this.urls = list;
        this.firePropertyChange("layers", null, null);
        StartLog.logEnd("setURLs");
    }

    public void addURLs(Collection<URL> collection) throws Exception {
        if (collection.contains(null)) {
            throw new NullPointerException("urls=" + collection);
        }
        ArrayList<URL> arrayList = new ArrayList<URL>(collection);
        if (this.urls != null) {
            arrayList.addAll(this.urls);
        }
        this.setURLs(arrayList);
    }

    public void removeURLs(Collection<URL> collection) throws Exception {
        if (collection.contains(null)) {
            throw new NullPointerException("urls=" + collection);
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (this.urls != null) {
            arrayList.addAll(this.urls);
        }
        arrayList.removeAll(collection);
        this.setURLs(arrayList);
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.setDelegates(ModuleLayeredFileSystem.appendLayers(this.writableLayer, this.addLookupBefore, this.otherLayers, this.cacheLayer, false));
    }

    private static void setStatusText(String string) {
        Main.setStatusText(string);
    }
}

