/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jellytools.modules.j2ee;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.Test;
import junit.framework.TestCase;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jellytools.JellyTestCase;
import org.netbeans.jellytools.NbDialogOperator;
import org.netbeans.jellytools.ProjectsTabOperator;
import org.netbeans.jellytools.modules.j2ee.nodes.GlassFishV2ServerNode;
import org.netbeans.jellytools.modules.j2ee.nodes.GlassFishV3ServerNode;
import org.netbeans.jellytools.modules.j2ee.nodes.J2eeServerNode;
import org.netbeans.jellytools.nodes.Node;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.junit.NbModuleSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J2eeTestCase
extends JellyTestCase {
    private static final String PID_FILE_PREFIX = "J2EE_TEST_CASE_PID_FILE";
    private static final String GLASSFISH_PATH = "com.sun.aas.installRoot";
    private static final String GLASSFISH_V3_PATH = "org.glassfish.v3ee6.installRoot";
    private static final String TOMCAT_PATH = "org.netbeans.modules.tomcat.autoregister.catalinaHome";
    private static final String JBOSS_PATH = "org.netbeans.modules.j2ee.jboss4.installRoot";
    private static final String GLASSFISH_HOME = "glassfish.home";
    private static final String TOMCAT_HOME = "tomcat.home";
    private static final String JBOSS_HOME = "jboss.home";
    private static final Logger LOG = Logger.getLogger(J2eeTestCase.class.getName());
    private static boolean serversLogged = false;

    public J2eeTestCase(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.createPid();
    }

    private void createPid() throws IOException {
        String string = ManagementFactory.getRuntimeMXBean().getName();
        string = string.substring(0, string.indexOf(64));
        String string2 = System.getProperty("java.io.tmpdir");
        File file = new File(string2);
        for (String string3 : file.list()) {
            if (!string3.startsWith(PID_FILE_PREFIX) || new File(file, string3).delete()) continue;
            LOG.warning("File '" + string2 + File.pathSeparator + string3 + "' not successfully deleted!");
        }
        if (!new File(file, PID_FILE_PREFIX + string).createNewFile()) {
            LOG.warning("File '" + string2 + File.pathSeparator + PID_FILE_PREFIX + string + "' not successfully created!");
        }
    }

    private static void registerGlassfish() {
        String string = J2eeTestCase.getServerHome(Server.GLASSFISH);
        if (J2eeTestCase.isValidPath(string) && J2eeTestCase.isValidPath(string + "/domains/domain1")) {
            LOG.info("Setting server path " + string);
            System.setProperty(GLASSFISH_PATH, string);
        }
    }

    private static void registerGlassfishV3() {
        String string = J2eeTestCase.getServerHome(Server.GLASSFISH_V3);
        if (J2eeTestCase.isValidPath(string) && J2eeTestCase.isValidPath(string + "/glassfish/domains/domain1")) {
            LOG.info("Setting server path " + string);
            System.setProperty(GLASSFISH_V3_PATH, string);
        }
    }

    private static void registerTomcat() {
        String string = J2eeTestCase.getServerHome(Server.TOMCAT);
        if (J2eeTestCase.isValidPath(string)) {
            LOG.info("Setting server path " + string);
            System.setProperty(TOMCAT_PATH, string);
            System.setProperty("org.netbeans.modules.tomcat.autoregister.token", "1");
        }
    }

    private static void registerJBoss() {
        String string = J2eeTestCase.getServerHome(Server.JBOSS);
        if (J2eeTestCase.isValidPath(string)) {
            LOG.info("Setting server path " + string);
            System.setProperty(JBOSS_PATH, string);
        }
    }

    private static String getServerHome(Server server) {
        switch (server) {
            case JBOSS: {
                return System.getProperty(JBOSS_HOME);
            }
            case GLASSFISH: 
            case GLASSFISH_V3: {
                String string = System.getProperty(GLASSFISH_HOME);
                if (string == null) {
                    string = System.getProperty("j2ee.appserver.path");
                }
                return string;
            }
            case TOMCAT: {
                return System.getProperty(TOMCAT_HOME);
            }
        }
        return null;
    }

    private static boolean isValidPath(String string) {
        if (string == null) {
            return false;
        }
        LOG.info("Validating path: " + string);
        File file = new File(string);
        if (file.isDirectory()) {
            LOG.info(string + " - is valid directory");
            return true;
        }
        if (!file.exists()) {
            LOG.info(string + " - does not exists!");
        } else {
            LOG.info(string + " - exists, but it is not a directory!");
        }
        return false;
    }

    protected static Test createAllModulesServerSuite(Server server, Class<? extends TestCase> clazz, String ... stringArray) {
        NbModuleSuite.Configuration configuration = NbModuleSuite.createConfiguration(clazz);
        configuration = J2eeTestCase.addServerTests(server, configuration, stringArray).enableModules(".*").clusters(".*");
        return NbModuleSuite.create((NbModuleSuite.Configuration)configuration);
    }

    protected static NbModuleSuite.Configuration addServerTests(NbModuleSuite.Configuration configuration, String ... stringArray) {
        return J2eeTestCase.addServerTests(Server.ANY, configuration, stringArray);
    }

    protected static NbModuleSuite.Configuration addServerTests(Server server, NbModuleSuite.Configuration configuration, String ... stringArray) {
        return J2eeTestCase.addServerTests(server, configuration, null, stringArray);
    }

    protected static NbModuleSuite.Configuration addServerTests(Server server, NbModuleSuite.Configuration configuration, Class<? extends TestCase> clazz, String ... stringArray) {
        if (J2eeTestCase.isRegistered(server)) {
            LOG.info("adding server tests");
            return J2eeTestCase.addTest(configuration, clazz, stringArray);
        }
        if (server.equals((Object)Server.GLASSFISH_V3) || server.equals((Object)Server.ANY)) {
            J2eeTestCase.registerGlassfishV3();
            if (J2eeTestCase.isRegistered(Server.GLASSFISH_V3)) {
                return J2eeTestCase.addTest(configuration, clazz, stringArray);
            }
        }
        if (server.equals((Object)Server.GLASSFISH) || server.equals((Object)Server.ANY)) {
            J2eeTestCase.registerGlassfish();
            if (J2eeTestCase.isRegistered(Server.GLASSFISH)) {
                return J2eeTestCase.addTest(configuration, clazz, stringArray);
            }
        }
        if (server.equals((Object)Server.TOMCAT) || server.equals((Object)Server.ANY)) {
            J2eeTestCase.registerTomcat();
            if (J2eeTestCase.isRegistered(Server.TOMCAT)) {
                return J2eeTestCase.addTest(configuration, clazz, stringArray);
            }
        }
        if (server.equals((Object)Server.JBOSS) || server.equals((Object)Server.ANY)) {
            J2eeTestCase.registerJBoss();
            if (J2eeTestCase.isRegistered(Server.JBOSS)) {
                return J2eeTestCase.addTest(configuration, clazz, stringArray);
            }
        }
        LOG.info("no server to add tests");
        if (!serversLogged) {
            serversLogged = true;
            J2eeTestCase.logServer(JBOSS_HOME, J2eeTestCase.getServerHome(Server.JBOSS));
            J2eeTestCase.logServer(TOMCAT_HOME, J2eeTestCase.getServerHome(Server.TOMCAT));
            J2eeTestCase.logServer(GLASSFISH_HOME, J2eeTestCase.getServerHome(Server.GLASSFISH));
            J2eeTestCase.logServer(GLASSFISH_HOME, J2eeTestCase.getServerHome(Server.GLASSFISH_V3));
        }
        try {
            return configuration.addTest(new String[]{"testEmpty"});
        }
        catch (IllegalStateException illegalStateException) {
            return configuration.addTest(J2eeTestCase.class, new String[]{"testEmpty"});
        }
    }

    private static void logServer(String string, String string2) {
        if (string2 == null) {
            LOG.info(string + " is not set");
        } else {
            LOG.info(string + " is " + string2);
        }
    }

    protected static boolean isRegistered(Server server) {
        boolean bl;
        switch (server) {
            case GLASSFISH_V3: {
                bl = System.getProperty(GLASSFISH_V3_PATH) != null;
                break;
            }
            case GLASSFISH: {
                bl = System.getProperty(GLASSFISH_PATH) != null;
                break;
            }
            case JBOSS: {
                bl = System.getProperty(JBOSS_PATH) != null;
                break;
            }
            case TOMCAT: {
                bl = System.getProperty(TOMCAT_PATH) != null;
                break;
            }
            case ANY: {
                for (Server server2 : Server.values()) {
                    if (server2.equals((Object)Server.ANY) || !J2eeTestCase.isRegistered(server2)) continue;
                    return true;
                }
                return false;
            }
            default: {
                throw new IllegalArgumentException("Unsupported server");
            }
        }
        return bl;
    }

    protected J2eeServerNode getServerNode(Server server) {
        if (!J2eeTestCase.isRegistered(server)) {
            throw new IllegalArgumentException("Server is not registred in IDE");
        }
        switch (server) {
            case GLASSFISH_V3: {
                return GlassFishV3ServerNode.invoke();
            }
            case GLASSFISH: {
                return GlassFishV2ServerNode.invoke();
            }
            case JBOSS: {
                return J2eeServerNode.invoke("JBoss");
            }
            case TOMCAT: {
                return J2eeServerNode.invoke("Tomcat");
            }
            case ANY: {
                for (Server server2 : Server.values()) {
                    if (server2.equals((Object)Server.ANY) || !J2eeTestCase.isRegistered(server2)) continue;
                    return this.getServerNode(server2);
                }
                throw new IllegalArgumentException("No server is registred in IDE");
            }
        }
        throw new IllegalArgumentException("Unsupported server");
    }

    public void testEmpty() {
    }

    private static NbModuleSuite.Configuration addTest(NbModuleSuite.Configuration configuration, Class<? extends TestCase> clazz, String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return configuration;
        }
        if (clazz == null) {
            return configuration.addTest(stringArray);
        }
        return configuration.addTest(clazz, stringArray);
    }

    protected void resolveServer(String string) {
        String string2;
        this.waitScanFinished();
        String string3 = Bundle.getString((String)"org.netbeans.modules.j2ee.common.ui.Bundle", (String)"MSG_Broken_Server_Title");
        if (JDialogOperator.findJDialog((String)string3, (boolean)true, (boolean)true) != null) {
            new NbDialogOperator(string3).close();
            LOG.info("Resolving server");
            ProjectsTabOperator.invoke().getProjectRootNode(string).properties();
            string2 = Bundle.getStringTrimmed((String)"org.netbeans.modules.web.project.ui.customizer.Bundle", (String)"LBL_Customizer_Title");
            NbDialogOperator nbDialogOperator = new NbDialogOperator(string2);
            new Node(new JTreeOperator((ContainerOperator)nbDialogOperator), "Run").select();
            new JComboBoxOperator((ContainerOperator)nbDialogOperator).setSelectedIndex(0);
            nbDialogOperator.ok();
            this.waitScanFinished();
        }
        string2 = Bundle.getStringTrimmed((String)"org.netbeans.modules.web.project.Bundle", (String)"TXT_BuildImplRegenerateTitle");
        int n = 0;
        while (JDialogOperator.findJDialog((String)string2, (boolean)true, (boolean)true) != null && n < 10) {
            ++n;
            NbDialogOperator nbDialogOperator = new NbDialogOperator(string2);
            String string4 = Bundle.getStringTrimmed((String)"org.netbeans.modules.web.project.Bundle", (String)"CTL_Regenerate");
            JButtonOperator jButtonOperator = new JButtonOperator((ContainerOperator)nbDialogOperator, string4);
            jButtonOperator.push();
            LOG.info("Closing buildscript regeneration");
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                LOG.log(Level.INFO, "interrupt exception", interruptedException);
            }
            if (!nbDialogOperator.isVisible()) continue;
            nbDialogOperator.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Server {
        TOMCAT,
        GLASSFISH,
        GLASSFISH_V3,
        JBOSS,
        ANY;

    }
}

