/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.faces.application;

import java.io.IOException;
import java.util.Locale;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ViewHandlerImpl
extends ViewHandler {
    private ViewHandler handler = null;
    private static final Log log = LogFactory.getLog((Class)ViewHandlerImpl.class);

    public ViewHandlerImpl(ViewHandler handler) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating ViewHandler instance, wrapping handler " + handler));
        }
        this.handler = handler;
    }

    public ViewHandler getHandler() {
        return this.handler;
    }

    public void setHandler(ViewHandler handler) {
        this.handler = handler;
    }

    public void renderView(FacesContext context, UIViewRoot view) throws IOException, FacesException {
        Locale locale;
        ExternalContext econtext;
        if (log.isDebugEnabled()) {
            log.debug((Object)("renderView(" + view.getViewId() + ")"));
        }
        if ((econtext = context.getExternalContext()).getSession(false) != null && (locale = (Locale)econtext.getSessionMap().get("org.apache.struts.action.LOCALE")) != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Setting view locale to " + locale));
            }
            view.setLocale(locale);
        }
        this.handler.renderView(context, view);
    }

    public Locale calculateLocale(FacesContext context) {
        return this.handler.calculateLocale(context);
    }

    public String calculateRenderKitId(FacesContext context) {
        return this.handler.calculateRenderKitId(context);
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        return this.handler.createView(context, viewId);
    }

    public String getActionURL(FacesContext context, String viewId) {
        return this.handler.getActionURL(context, viewId);
    }

    public String getResourceURL(FacesContext context, String viewId) {
        return this.handler.getResourceURL(context, viewId);
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        return this.handler.restoreView(context, viewId);
    }

    public void writeState(FacesContext context) throws IOException {
        this.handler.writeState(context);
    }
}

