/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;

class LastIndexKeyResultSet
extends NoPutResultSetImpl {
    protected ExecRow candidate;
    protected long conglomId;
    protected GeneratedMethod resultRowAllocator;
    protected GeneratedMethod startKeyGetter;
    protected int startSearchOperator;
    protected GeneratedMethod stopKeyGetter;
    protected int stopSearchOperator;
    protected Qualifier[][] qualifiers;
    public String tableName;
    public String userSuppliedOptimizerOverrides;
    public String indexName;
    protected boolean runTimeStatisticsOn;
    protected FormatableBitSet accessedCols;
    public int isolationLevel;
    public int lockMode;
    public String stopPositionString;
    public boolean coarserLock;
    public boolean returnedRow;

    public LastIndexKeyResultSet(Activation activation, int n, GeneratedMethod generatedMethod, long l, String string, String string2, String string3, int n2, int n3, boolean bl, int n4, double d, double d2) throws StandardException {
        super(activation, n, d, d2);
        this.conglomId = l;
        this.resultRowAllocator = generatedMethod;
        this.tableName = string;
        this.userSuppliedOptimizerOverrides = string2;
        this.indexName = string3;
        this.lockMode = n3;
        if (n2 != -1) {
            this.accessedCols = (FormatableBitSet)activation.getPreparedStatement().getSavedObject(n2);
        }
        if (n4 == 0) {
            n4 = this.lcc.getCurrentIsolationLevel();
        }
        if (n4 == 4) {
            this.isolationLevel = 5;
        } else {
            if (!bl) {
                this.lockMode = 6;
            }
            if (n4 == 2) {
                this.isolationLevel = 3;
            } else if (n4 == 1) {
                this.isolationLevel = 1;
            } else if (n4 == 3) {
                this.isolationLevel = 4;
            }
        }
        this.runTimeStatisticsOn = this.getLanguageConnectionContext().getRunTimeStatisticsMode();
        this.candidate = (ExecRow)generatedMethod.invoke(activation);
        this.constructorTime += this.getElapsedMillis(this.beginTime);
        activation.informOfRowCount(this, 1L);
    }

    public void openCore() throws StandardException {
        ExecRow execRow = this.candidate.getClone();
        this.beginTime = this.getCurrentTimeMillis();
        this.isOpen = true;
        TransactionController transactionController = this.activation.getTransactionController();
        if (transactionController.fetchMaxOnBtree(this.conglomId, 0, this.lockMode, this.isolationLevel, this.accessedCols, execRow.getRowArray())) {
            this.currentRow = this.getCompactRow(execRow, this.accessedCols, null, true);
            this.setCurrentRow(this.currentRow);
        } else {
            this.clearCurrentRow();
        }
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public ExecRow getNextRowCore() throws StandardException {
        if (this.returnedRow || !this.isOpen) {
            this.clearCurrentRow();
        } else {
            this.returnedRow = true;
        }
        return this.currentRow;
    }

    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.isOpen = false;
            this.clearCurrentRow();
            super.close();
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    public long getTimeSpent(int n) {
        long l = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n == 0) {
            return l;
        }
        return l;
    }

    public ExecRow getCurrentRow() throws StandardException {
        return this.currentRow;
    }
}

