/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.editors;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.netbeans.modules.j2ee.sun.ide.editors.NbProxySelector;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

public class ProxySettings {
    public static final String PROXY_HTTP_HOST = "proxyHttpHost";
    public static final String PROXY_HTTP_PORT = "proxyHttpPort";
    public static final String PROXY_HTTPS_HOST = "proxyHttpsHost";
    public static final String PROXY_HTTPS_PORT = "proxyHttpsPort";
    public static final String PROXY_SOCKS_HOST = "proxySocksHost";
    public static final String PROXY_SOCKS_PORT = "proxySocksPort";
    public static final String NOT_PROXY_HOSTS = "proxyNonProxyHosts";
    public static final String PROXY_TYPE = "proxyType";
    public static final String USE_PROXY_AUTHENTICATION = "useProxyAuthentication";
    public static final String PROXY_AUTHENTICATION_USERNAME = "proxyAuthenticationUsername";
    public static final String PROXY_AUTHENTICATION_PASSWORD = "proxyAuthenticationPassword";
    public static final String USE_PROXY_ALL_PROTOCOLS = "useProxyAllProtocols";
    public static final String DIRECT = "DIRECT";
    private static String presetNonProxyHosts;
    public static final int DIRECT_CONNECTION = 0;
    public static final int AUTO_DETECT_PROXY = 1;
    public static final int MANUAL_SET_PROXY = 2;

    private static Preferences getPreferences() {
        return NbPreferences.forModule(ProxySettings.class);
    }

    public static String getHttpHost() {
        return ProxySettings.normalizeProxyHost(ProxySettings.getPreferences().get(PROXY_HTTP_HOST, ""));
    }

    public static String getHttpPort() {
        return ProxySettings.getPreferences().get(PROXY_HTTP_PORT, "");
    }

    public static String getHttpsHost() {
        if (ProxySettings.useProxyAllProtocols()) {
            return ProxySettings.getHttpHost();
        }
        return ProxySettings.getPreferences().get(PROXY_HTTPS_HOST, "");
    }

    public static String getHttpsPort() {
        if (ProxySettings.useProxyAllProtocols()) {
            return ProxySettings.getHttpPort();
        }
        return ProxySettings.getPreferences().get(PROXY_HTTPS_PORT, "");
    }

    public static String getSocksHost() {
        if (ProxySettings.useProxyAllProtocols()) {
            return ProxySettings.getHttpHost();
        }
        return ProxySettings.getPreferences().get(PROXY_SOCKS_HOST, "");
    }

    public static String getSocksPort() {
        if (ProxySettings.useProxyAllProtocols()) {
            return ProxySettings.getHttpPort();
        }
        return ProxySettings.getPreferences().get(PROXY_SOCKS_PORT, "");
    }

    public static String getNonProxyHosts() {
        return ProxySettings.getPreferences().get(NOT_PROXY_HOSTS, ProxySettings.getDefaultUserNonProxyHosts());
    }

    public static int getProxyType() {
        return ProxySettings.getPreferences().getInt(PROXY_TYPE, 1);
    }

    public static boolean useAuthentication() {
        return ProxySettings.getPreferences().getBoolean(USE_PROXY_AUTHENTICATION, false);
    }

    public static boolean useProxyAllProtocols() {
        return ProxySettings.getPreferences().getBoolean(USE_PROXY_ALL_PROTOCOLS, false);
    }

    public static String getAuthenticationUsername() {
        return ProxySettings.getPreferences().get(PROXY_AUTHENTICATION_USERNAME, "");
    }

    public static char[] getAuthenticationPassword() {
        return ProxySettings.getPreferences().get(PROXY_AUTHENTICATION_PASSWORD, "").toCharArray();
    }

    static void addPreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
        ProxySettings.getPreferences().addPreferenceChangeListener(preferenceChangeListener);
    }

    static void removePreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
        ProxySettings.getPreferences().removePreferenceChangeListener(preferenceChangeListener);
    }

    private static String getSystemNonProxyHosts() {
        String string = System.getProperty("netbeans.system_http_non_proxy_hosts");
        return string == null ? "" : string;
    }

    private static String getPresetNonProxyHosts() {
        if (presetNonProxyHosts == null) {
            presetNonProxyHosts = System.getProperty("http.nonProxyHosts", "");
        }
        return presetNonProxyHosts;
    }

    private static String getDefaultUserNonProxyHosts() {
        return ProxySettings.getModifiedNonProxyHosts(ProxySettings.getSystemNonProxyHosts());
    }

    private static String getModifiedNonProxyHosts(String string) {
        String string2;
        String string3 = string.replaceAll(";", "|").replaceAll(",", "|");
        String string4 = string2 = ProxySettings.getPresetNonProxyHosts() == null ? "" : ProxySettings.getPresetNonProxyHosts().replaceAll(";", "|").replaceAll(",", "|");
        if (Utilities.isWindows()) {
            string3 = ProxySettings.addReguralToNonProxyHosts(string3);
        }
        String string5 = string2 + (string2.length() == 0 ? "" : "|") + string3 + (string3.length() == 0 ? "" : "|") + "localhost|127.0.0.1";
        String string6 = "";
        try {
            string6 = InetAddress.getLocalHost().getHostName();
            if (!"localhost".equals(string6)) {
                string5 = string5 + "|" + string6;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return ProxySettings.compactNonProxyHosts(string5);
    }

    private static String compactNonProxyHosts(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        HashSet<String> hashSet = new HashSet<String>();
        StringBuilder stringBuilder = new StringBuilder();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!hashSet.add(string2.toLowerCase(Locale.US))) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append('|');
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private static String addReguralToNonProxyHosts(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        StringBuilder stringBuilder = new StringBuilder();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.indexOf(42) == -1) {
                string2 = string2 + '*';
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append('|');
            }
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    private static String normalizeProxyHost(String string) {
        if (string.toLowerCase(Locale.US).startsWith("http://")) {
            return string.substring(7, string.length());
        }
        return string;
    }

    static class SystemProxySettings
    extends ProxySettings {
        SystemProxySettings() {
        }

        public static String getHttpHost() {
            if (SystemProxySettings.isSystemProxyDetect()) {
                return SystemProxySettings.getSystemProxyHost();
            }
            return "";
        }

        public static String getHttpPort() {
            if (SystemProxySettings.isSystemProxyDetect()) {
                return SystemProxySettings.getSystemProxyPort();
            }
            return "";
        }

        public static String getHttpsHost() {
            if (SystemProxySettings.isSystemProxyDetect()) {
                return SystemProxySettings.getSystemProxyHost();
            }
            return "";
        }

        public static String getHttpsPort() {
            if (SystemProxySettings.isSystemProxyDetect()) {
                return SystemProxySettings.getSystemProxyPort();
            }
            return "";
        }

        public static String getSocksHost() {
            if (SystemProxySettings.isSystemSocksServerDetect()) {
                return SystemProxySettings.getSystemSocksServerHost();
            }
            return "";
        }

        public static String getSocksPort() {
            if (SystemProxySettings.isSystemSocksServerDetect()) {
                return SystemProxySettings.getSystemSocksServerPort();
            }
            return "";
        }

        public static String getNonProxyHosts() {
            return ProxySettings.getDefaultUserNonProxyHosts();
        }

        private static boolean isSystemProxyDetect() {
            if (NbProxySelector.useSystemProxies()) {
                return true;
            }
            String string = System.getProperty("netbeans.system_http_proxy");
            return string != null && !ProxySettings.DIRECT.equals(string);
        }

        private static String getSystemProxyHost() {
            String string = System.getProperty("netbeans.system_http_proxy");
            if (string == null) {
                return "";
            }
            int n = string.lastIndexOf(":");
            if (n <= 0 || n >= string.length() - 1) {
                return "";
            }
            return ProxySettings.normalizeProxyHost(string.substring(0, n));
        }

        private static String getSystemProxyPort() {
            String string = System.getProperty("netbeans.system_http_proxy");
            if (string == null) {
                return "";
            }
            int n = string.lastIndexOf(":");
            if (n <= 0 || n >= string.length() - 1) {
                return "";
            }
            String string2 = string.substring(n + 1);
            if (string2.indexOf(47) >= 0) {
                string2 = string2.substring(0, string2.indexOf(47));
            }
            return string2;
        }

        private static boolean isSystemSocksServerDetect() {
            return SystemProxySettings.isSystemProxyDetect() && System.getProperty("netbeans.system_socks_proxy") != null;
        }

        private static String getSystemSocksServerHost() {
            String string = System.getProperty("netbeans.system_socks_proxy");
            if (string == null) {
                return "";
            }
            int n = string.lastIndexOf(":");
            if (n <= 0 || n >= string.length() - 1) {
                return "";
            }
            return ProxySettings.normalizeProxyHost(string.substring(0, n));
        }

        private static String getSystemSocksServerPort() {
            String string = System.getProperty("netbeans.system_socks_proxy");
            if (string == null) {
                return "";
            }
            int n = string.lastIndexOf(":");
            if (n <= 0 || n >= string.length() - 1) {
                return "";
            }
            String string2 = string.substring(n + 1);
            if (string2.indexOf(47) >= 0) {
                string2 = string2.substring(0, string2.indexOf(47));
            }
            return string2;
        }
    }
}

