/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.properties.BundleStructure;
import org.netbeans.modules.properties.LocaleNodeCustomizer;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.Util;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class BundleNodeCustomizer
extends JPanel {
    private PropertiesDataObject propDataObject;
    private JButton addLocale;
    private JScrollPane jScrollPane1;
    private JLabel localesLabel;
    private JList localesList;
    private JLabel nameLabel;
    private JTextField nameText;
    private JButton removeLocales;

    public BundleNodeCustomizer(PropertiesDataObject propertiesDataObject) {
        this.propDataObject = propertiesDataObject;
        this.initComponents();
        this.initAccessibility();
        this.nameText.setText(propertiesDataObject.getNodeDelegate().getName());
        this.localesList.setListData(BundleNodeCustomizer.retrieveLocales(propertiesDataObject));
        this.removeLocales.setEnabled(false);
        HelpCtx.setHelpIDString((JComponent)this, (String)"propfiles.addlocale");
    }

    private static Icon getLocaleIcon() {
        return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/properties/propertiesLocale.gif", (boolean)false);
    }

    private static Locale[] retrieveLocales(PropertiesDataObject propertiesDataObject) {
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        BundleStructure bundleStructure = propertiesDataObject.getBundleStructure();
        for (int i = 0; i < bundleStructure.getEntryCount(); ++i) {
            arrayList.add(LocaleNodeCustomizer.getLocale(bundleStructure.getNthEntry(i)));
        }
        Locale[] localeArray = new Locale[arrayList.size()];
        arrayList.toArray(localeArray);
        return localeArray;
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(LocaleNodeCustomizer.class).getString("ACS_BundleNodeCustomizer"));
        this.nameText.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(LocaleNodeCustomizer.class).getString("ACS_CTL_BundleName"));
        this.localesList.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(LocaleNodeCustomizer.class).getString("ACS_CTL_LocalesList"));
        this.addLocale.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(LocaleNodeCustomizer.class).getString("ACS_CTL_AddLocale"));
        this.removeLocales.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(LocaleNodeCustomizer.class).getString("ACS_CTL_RemoveLocale"));
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.nameText = new JTextField();
        this.localesLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.localesList = new JList();
        this.addLocale = new JButton();
        this.removeLocales = new JButton();
        this.setLayout(new GridBagLayout());
        this.nameLabel.setLabelFor(this.nameText);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getBundle(LocaleNodeCustomizer.class).getString("LBL_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.nameLabel, gridBagConstraints);
        this.nameText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BundleNodeCustomizer.this.nameTextActionPerformed(actionEvent);
            }
        });
        this.nameText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                BundleNodeCustomizer.this.nameTextFocusLost(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.nameText, gridBagConstraints);
        this.localesLabel.setLabelFor(this.localesList);
        Mnemonics.setLocalizedText((JLabel)this.localesLabel, (String)NbBundle.getBundle(LocaleNodeCustomizer.class).getString("LBL_Locales"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.add((Component)this.localesLabel, gridBagConstraints);
        this.localesList.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object instanceof String) {
                    return jLabel;
                }
                Locale locale = (Locale)object;
                if (locale.equals(new Locale("", ""))) {
                    jLabel.setText(NbBundle.getBundle(BundleNodeCustomizer.class).getString("LAB_defaultLanguage"));
                } else {
                    jLabel.setText(locale.toString() + (locale.getLanguage().equals("") ? "" : " - " + locale.getDisplayLanguage()) + (locale.getCountry().equals("") ? "" : " / " + locale.getDisplayCountry()) + (locale.getVariant().equals("") ? "" : " / " + locale.getDisplayVariant()));
                }
                jLabel.setIcon(BundleNodeCustomizer.getLocaleIcon());
                return jLabel;
            }
        });
        this.localesList.setPrototypeCellValue("0123456789012345678901234567890123456789");
        this.localesList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                BundleNodeCustomizer.this.localesListValueChanged(listSelectionEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.localesList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 12, 5, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addLocale, (String)NbBundle.getBundle(LocaleNodeCustomizer.class).getString("CTL_AddLocale"));
        this.addLocale.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BundleNodeCustomizer.this.addLocaleActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add((Component)this.addLocale, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeLocales, (String)NbBundle.getBundle(LocaleNodeCustomizer.class).getString("CTL_RemoveLocale"));
        this.removeLocales.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BundleNodeCustomizer.this.removeLocalesActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 11, 5, 11);
        this.add((Component)this.removeLocales, gridBagConstraints);
    }

    private void localesListValueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.localesList.isSelectionEmpty() || new Locale("", "").equals(this.localesList.getSelectedValue()) || this.propDataObject.getBundleStructure().getEntryCount() == 1) {
            this.removeLocales.setEnabled(false);
        } else {
            this.removeLocales.setEnabled(true);
        }
    }

    private void removeLocalesActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.localesList.getSelectedValues();
        String string = this.propDataObject.getPrimaryFile().getName();
        string = Util.getBaseName(string);
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(BundleNodeCustomizer.class, (String)"CTL_Deletebundle_Prompt"));
        confirmation.setTitle(NbBundle.getMessage(BundleNodeCustomizer.class, (String)"CTL_Deletebundle_Title"));
        confirmation.setMessageType(2);
        confirmation.setOptionType(0);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
        if (object != NotifyDescriptor.YES_OPTION) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            PropertiesFileEntry propertiesFileEntry = this.propDataObject.getBundleStructure().getEntryByFileName(string + '_' + objectArray[i].toString());
            try {
                propertiesFileEntry.delete();
                if (this.propDataObject.isValid()) continue;
                this.propDataObject = Util.findPrimaryDataObject(this.propDataObject);
                this.nameText.setText(this.propDataObject.getName());
                continue;
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
        this.localesList.setListData(BundleNodeCustomizer.retrieveLocales(this.propDataObject));
    }

    private void addLocaleActionPerformed(ActionEvent actionEvent) {
        try {
            this.propDataObject.getNodeDelegate().getNewTypes()[0].create();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        this.localesList.setListData(BundleNodeCustomizer.retrieveLocales(this.propDataObject));
    }

    private void nameTextFocusLost(FocusEvent focusEvent) {
        this.nameTextHandler();
    }

    private void nameTextActionPerformed(ActionEvent actionEvent) {
        this.nameTextHandler();
    }

    private void nameTextHandler() {
        String string = this.nameText.getText();
        if (string == null || "".equals(string)) {
            return;
        }
        this.propDataObject.getNodeDelegate().setName(string);
    }
}

