/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.properties.LocalePanel;
import org.netbeans.modules.properties.PropertiesDataNode;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesRequestProcessor;
import org.netbeans.modules.properties.PropertiesStructure;
import org.netbeans.modules.properties.Util;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.loaders.MultiDataObject;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class LocaleNodeCustomizer
extends JPanel {
    private PropertiesFileEntry entry;
    private JButton addKeyButton;
    private JButton changeNameButton;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JLabel keyLabel;
    private JList keyList;
    private JLabel nameLabel;
    private JTextField nameText;
    private JButton removeKeyButton;

    public LocaleNodeCustomizer(PropertiesFileEntry propertiesFileEntry) {
        this.entry = propertiesFileEntry;
        this.initComponents();
        this.initAccessibility();
        Locale locale = LocaleNodeCustomizer.getLocale(propertiesFileEntry);
        if (new Locale("", "").equals(locale)) {
            this.changeNameButton.setEnabled(false);
            this.nameText.setText(NbBundle.getBundle(LocaleNodeCustomizer.class).getString("LAB_defaultLanguage"));
        } else {
            this.nameText.setText(locale.toString());
        }
        this.removeKeyButton.setEnabled(false);
        HelpCtx.setHelpIDString((JComponent)this, (String)"propfiles.editlocale");
    }

    private void updateName(Locale locale) {
        if (locale.equals(new Locale("", "")) || locale.equals(LocaleNodeCustomizer.getLocale(this.entry))) {
            return;
        }
        String string = Util.assembleName(this.entry.getDataObject().getPrimaryFile().getName(), locale.toString());
        this.entry.getNodeDelegate().setName(string);
        this.nameText.setText(locale.toString());
    }

    private static Icon getKeyIcon() {
        return ImageUtilities.loadImageIcon((String)"org/netbeans/modules/properties/propertiesKey.gif", (boolean)false);
    }

    static Locale getLocale(PropertiesFileEntry propertiesFileEntry) {
        String string = Util.getLocaleSuffix((MultiDataObject.Entry)propertiesFileEntry);
        String string2 = Util.getLanguage(string);
        if (string2 == null) {
            return new Locale("", "");
        }
        String string3 = Util.getCountry(string);
        if (string3 == null) {
            return new Locale(string2, "");
        }
        String string4 = Util.getVariant(string);
        if (string4 == null) {
            return new Locale(string2, string3);
        }
        return new Locale(string2, string3, string4);
    }

    private static String[] retrieveKeys(PropertiesFileEntry propertiesFileEntry) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (propertiesFileEntry == null) {
            return new String[0];
        }
        String[] stringArray = propertiesFileEntry.getHandler().getStructure().allItems();
        while (stringArray.hasNext()) {
            String string = stringArray.next().getKey();
            if (string == null || arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(LocaleNodeCustomizer.class).getString("ACS_LocaleNodeCustomizer"));
        this.nameText.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(LocaleNodeCustomizer.class).getString("ACS_CTL_LocaleName"));
        this.addKeyButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(LocaleNodeCustomizer.class).getString("ACS_CTL_AddKey"));
        this.changeNameButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(LocaleNodeCustomizer.class).getString("ACS_CTL_ChangeNameButton"));
        this.removeKeyButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(LocaleNodeCustomizer.class).getString("ACS_CTL_RemoveKey"));
        this.keyList.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(LocaleNodeCustomizer.class).getString("ACS_CTL_KeyList"));
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.keyLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.keyList = new JList<String>(LocaleNodeCustomizer.retrieveKeys(this.entry));
        this.addKeyButton = new JButton();
        this.removeKeyButton = new JButton();
        this.jPanel1 = new JPanel();
        this.nameText = new JTextField();
        this.changeNameButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.nameLabel.setLabelFor(this.nameText);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getBundle(LocaleNodeCustomizer.class).getString("LBL_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.nameLabel, gridBagConstraints);
        this.keyLabel.setLabelFor(this.keyList);
        Mnemonics.setLocalizedText((JLabel)this.keyLabel, (String)NbBundle.getBundle(LocaleNodeCustomizer.class).getString("LBL_Keys"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.add((Component)this.keyLabel, gridBagConstraints);
        this.keyList.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                jLabel.setText(object.toString());
                jLabel.setIcon(LocaleNodeCustomizer.getKeyIcon());
                return jLabel;
            }
        });
        this.keyList.setPrototypeCellValue("0123456789012345678901234567890123456789");
        this.keyList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                LocaleNodeCustomizer.this.keyListValueChanged(listSelectionEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.keyList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 5, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.addKeyButton, (String)NbBundle.getBundle(LocaleNodeCustomizer.class).getString("CTL_AddKey"));
        this.addKeyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LocaleNodeCustomizer.this.addKeyButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add((Component)this.addKeyButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeKeyButton, (String)NbBundle.getBundle(LocaleNodeCustomizer.class).getString("CTL_RemoveKey"));
        this.removeKeyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LocaleNodeCustomizer.this.removeKeyButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(5, 11, 5, 11);
        this.add((Component)this.removeKeyButton, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.nameText.setEditable(false);
        this.nameText.selectAll();
        this.nameText.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                LocaleNodeCustomizer.this.nameTextFocusGained(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.nameText, gridBagConstraints);
        this.changeNameButton.setText("...");
        this.changeNameButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LocaleNodeCustomizer.this.changeNameButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel1.add((Component)this.changeNameButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void nameTextFocusGained(FocusEvent focusEvent) {
        this.nameText.selectAll();
    }

    private void changeNameButtonActionPerformed(ActionEvent actionEvent) {
        final Dialog[] dialogArray = new Dialog[1];
        final LocalePanel localePanel = new LocalePanel(LocaleNodeCustomizer.getLocale(this.entry));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)localePanel, NbBundle.getBundle(PropertiesDataNode.class).getString("CTL_NewLocaleTitle"), true, 2, DialogDescriptor.OK_OPTION, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == DialogDescriptor.OK_OPTION) {
                    dialogArray[0].setVisible(false);
                    dialogArray[0].dispose();
                    LocaleNodeCustomizer.this.updateName(localePanel.getLocale());
                } else if (actionEvent.getSource() == DialogDescriptor.CANCEL_OPTION) {
                    dialogArray[0].setVisible(false);
                    dialogArray[0].dispose();
                }
            }
        });
        dialogArray[0] = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialogArray[0].setVisible(true);
    }

    private void keyListValueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.keyList.isSelectionEmpty()) {
            this.removeKeyButton.setEnabled(false);
        } else {
            this.removeKeyButton.setEnabled(true);
        }
    }

    private void removeKeyButtonActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.keyList.getSelectedValues();
        PropertiesStructure propertiesStructure = this.entry.getHandler().getStructure();
        for (int i = 0; i < objectArray.length; ++i) {
            propertiesStructure.deleteItem((String)objectArray[i]);
        }
        this.updateKeyList();
    }

    private void addKeyButtonActionPerformed(ActionEvent actionEvent) {
        try {
            this.entry.getNodeDelegate().getNewTypes()[0].create();
            this.updateKeyList();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
    }

    private void updateKeyList() {
        PropertiesRequestProcessor.getInstance().post(new Runnable(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        LocaleNodeCustomizer.this.keyList.setListData(LocaleNodeCustomizer.retrieveKeys(LocaleNodeCustomizer.this.entry));
                    }
                });
            }
        });
    }
}

