/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.deployment.wm;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.netbeans.mobility.activesync.ActiveSyncOps;
import org.netbeans.mobility.activesync.RemoteFile;
import org.netbeans.mobility.activesync.RemoteProcess;

public class WindowsMobileDeployTask
extends Task {
    private String jarFile;
    private String jadFile;
    private String appLocation;

    public String getJarFile() {
        return this.jarFile;
    }

    public void setJarFile(String jarFile) {
        this.jarFile = jarFile;
    }

    public String getJadFile() {
        return this.jadFile;
    }

    public void setJadFile(String jadFile) {
        this.jadFile = jadFile;
    }

    public String getAppLocation() {
        return this.appLocation;
    }

    public void setAppLocation(String appLocation) {
        this.appLocation = appLocation;
    }

    public void execute() throws BuildException {
        ActiveSyncOps activeSync;
        block16: {
            block15: {
                activeSync = ActiveSyncOps.getDefault();
                this.log("Windows Mobile Deployment: ");
                this.log("jar: " + this.jarFile);
                this.log("jad: " + this.jadFile);
                if (activeSync == null) break block15;
                if (activeSync.isAvailable()) break block16;
            }
            throw new BuildException("active sync is not available");
        }
        try {
            RemoteFile rjar;
            try {
                for (int i = 0; i < 5 && !activeSync.isDeviceConnected(); ++i) {
                    Thread.sleep(400L);
                }
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if (!activeSync.isDeviceConnected()) {
                throw new BuildException("device not connected");
            }
            File fjar = new File(this.jarFile);
            if (!fjar.exists()) {
                throw new BuildException("jar file does not exist");
            }
            File fjad = new File(this.jadFile);
            if (!fjad.exists()) {
                throw new BuildException("jad file does not exist");
            }
            RemoteFile appdir = new RemoteFile(this.appLocation, WindowsMobileDeployTask.basename(fjad.getName()));
            appdir = WindowsMobileDeployTask.createRemoteDir(activeSync, appdir);
            RemoteFile rapp = rjar = new RemoteFile(appdir.getFullPath(), fjar.getName());
            RemoteFile rjad = new RemoteFile(appdir.getFullPath(), fjad.getName());
            if (rjar.exists()) {
                activeSync.delete(rjar);
            }
            activeSync.copyToDevice(fjar, appdir);
            if (rjad.exists()) {
                activeSync.delete(rjad);
            }
            if (fjad.exists()) {
                activeSync.copyToDevice(fjad, appdir);
                rapp = rjad;
            }
            String process = "\\SUN_JVM_1.1.3\\runMidlet.exe";
            RemoteProcess rp = activeSync.executeRemoteProcess(process, new String[]{"install_file", "\"file:\\" + rapp.getFullPath() + "\""});
            StringBuffer sb = new StringBuffer(rp.getProcessName());
            String[] ar = rp.getProcessArguments();
            for (int i = 0; i < ar.length; ++i) {
                sb.append(' ');
                sb.append(ar[i]);
            }
            this.log("remote process: " + sb.toString());
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private static RemoteFile createRemoteDir(ActiveSyncOps activeSync, RemoteFile rf) throws IOException {
        if (!rf.exists()) {
            WindowsMobileDeployTask.createRemoteDir(activeSync, rf.getParentDir());
            return activeSync.createNewDirectory(rf.getParentDir().getFullPath(), rf.getName());
        }
        return rf;
    }

    private static String basename(String string) {
        int index = string.lastIndexOf(46);
        if (index != -1) {
            return string.substring(0, index);
        }
        return string;
    }
}

