/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.CustomizerNode;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.CustomizerRootNodeProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.PrioritizedCustomizerNode;

public class DebuggerChooserConfiguration {
    private static List<CustomizerNode> nodes = null;
    private static String[] names;
    private static int def;
    private int value;
    private boolean modified;
    private boolean dirty = false;

    public DebuggerChooserConfiguration() {
        DebuggerChooserConfiguration.init();
        this.reset();
    }

    public DebuggerChooserConfiguration(DebuggerChooserConfiguration debuggerChooserConfiguration) {
        this.value = debuggerChooserConfiguration.value;
        this.setModified(false);
    }

    private static void init() {
        if (nodes == null) {
            nodes = CustomizerRootNodeProvider.getInstance().getCustomizerNodes("Debug");
            String[] stringArray = new String[]{""};
            if (nodes.size() >= 1) {
                int n = -1;
                int n2 = 0;
                ArrayList<String> arrayList = new ArrayList<String>();
                for (CustomizerNode customizerNode : nodes) {
                    if (customizerNode instanceof PrioritizedCustomizerNode) {
                        if (((PrioritizedCustomizerNode)((Object)customizerNode)).getPriority() > n) {
                            n = ((PrioritizedCustomizerNode)((Object)customizerNode)).getPriority();
                            n2 = arrayList.size();
                        }
                    } else if (customizerNode.getClass().getName().toLowerCase().contains("dbx")) {
                        n = 9999;
                        n2 = arrayList.size();
                    }
                    arrayList.add(customizerNode.getDisplayName());
                }
                names = arrayList.toArray(stringArray);
                def = n2;
            } else {
                names = stringArray;
                def = 0;
            }
        }
    }

    public void setValue(int n) {
        this.value = n;
        this.setModified(true);
    }

    public void setValue(String string) {
        if (string != null) {
            for (int i = 0; i < names.length; ++i) {
                if (!string.equals(names[i])) continue;
                this.setValue(i);
                break;
            }
        }
    }

    public int getValue() {
        return this.value;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public boolean getModified() {
        return this.modified;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public boolean getDirty() {
        return this.dirty;
    }

    public int getDefault() {
        return def;
    }

    public void reset() {
        this.value = this.getDefault();
        this.setModified(false);
    }

    public String getName() {
        if (this.getValue() < names.length) {
            return names[this.getValue()];
        }
        return "???";
    }

    public CustomizerNode getNode() {
        if (this.getValue() < nodes.size()) {
            return nodes.get(this.getValue());
        }
        return null;
    }

    public String[] getNames() {
        return names;
    }

    public void assign(DebuggerChooserConfiguration debuggerChooserConfiguration) {
        this.dirty = this.getValue() != debuggerChooserConfiguration.getValue();
        this.setValue(debuggerChooserConfiguration.getValue());
        this.setModified(debuggerChooserConfiguration.getModified());
    }

    public DebuggerChooserConfiguration clone() {
        return new DebuggerChooserConfiguration(this);
    }
}

