/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VectorConfiguration<E> {
    private VectorConfiguration<E> master;
    private List<E> value;
    private boolean dirty = false;

    public VectorConfiguration(VectorConfiguration<E> vectorConfiguration) {
        this.master = vectorConfiguration;
        this.value = new ArrayList(0);
        this.reset();
    }

    public VectorConfiguration<E> getMaster() {
        return this.master;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public boolean getDirty() {
        return this.dirty;
    }

    public void add(E e) {
        this.getValue().add(e);
    }

    public void setValue(List<E> list) {
        assert (list != null);
        this.value = list;
    }

    public List<E> getValue() {
        return this.value;
    }

    public boolean getModified() {
        return this.value.size() != 0;
    }

    public void reset() {
        this.value = new ArrayList();
    }

    public void assign(VectorConfiguration<E> vectorConfiguration) {
        this.setDirty(!this.equals(vectorConfiguration));
        this.reset();
        this.getValue().addAll(vectorConfiguration.getValue());
    }

    public boolean equals(Object object) {
        if (!(object instanceof VectorConfiguration)) {
            return false;
        }
        VectorConfiguration vectorConfiguration = (VectorConfiguration)object;
        List<E> list = this.getValue();
        List<E> list2 = vectorConfiguration.getValue();
        if (list == null && list2 == null) {
            return true;
        }
        if (list != null && list2 != null) {
            if (list.size() != list2.size()) {
                return false;
            }
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i).equals(list2.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = 3;
        for (E e : this.getValue()) {
            n = 17 * n + e.hashCode();
        }
        return n;
    }

    public VectorConfiguration<E> clone() {
        VectorConfiguration<E> vectorConfiguration = new VectorConfiguration<E>(this.master);
        vectorConfiguration.setValue(new ArrayList<E>(this.getValue()));
        return vectorConfiguration;
    }

    public String toString(ToString<E> toString) {
        StringBuilder stringBuilder = new StringBuilder();
        List<E> list = this.getValue();
        for (E e : list) {
            String string = toString.toString(e);
            if (string == null || 0 >= string.length()) continue;
            stringBuilder.append(string).append(' ');
        }
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ToString<E> {
        public String toString(E var1);
    }
}

