/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.packaging;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.api.PackagerDescriptor;
import org.netbeans.modules.cnd.makeproject.api.PackagerFileElement;
import org.netbeans.modules.cnd.makeproject.api.PackagerInfoElement;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.PackagingConfiguration;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPSPackager
implements PackagerDescriptor {
    public static final String PACKAGER_NAME = "IPS";

    @Override
    public String getName() {
        return PACKAGER_NAME;
    }

    @Override
    public String getDisplayName() {
        return IPSPackager.getString("IPSPackage");
    }

    @Override
    public boolean hasInfoList() {
        return true;
    }

    @Override
    public List<PackagerInfoElement> getDefaultInfoList(MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) {
        ArrayList<PackagerInfoElement> arrayList = new ArrayList<PackagerInfoElement>();
        arrayList.add(new PackagerInfoElement(PACKAGER_NAME, "name", packagingConfiguration.getOutputName(), false, true));
        arrayList.add(new PackagerInfoElement(PACKAGER_NAME, "description", "Package description ...", false, true));
        return arrayList;
    }

    @Override
    public List<String> getOptionalInfoList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("name");
        arrayList.add("description");
        return arrayList;
    }

    @Override
    public String getDefaultOptions() {
        return "";
    }

    @Override
    public String getDefaultTool() {
        return "";
    }

    @Override
    public boolean isOutputAFolder() {
        return true;
    }

    @Override
    public String getOutputFileName(MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) {
        return null;
    }

    @Override
    public String getOutputFileSuffix() {
        return null;
    }

    @Override
    public String getTopDir(MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) {
        return "/usr";
    }

    @Override
    public boolean supportsGroupAndOwner() {
        return true;
    }

    @Override
    public PackagerDescriptor.ShellSciptWriter getShellFileWriter() {
        return new ScriptWriter();
    }

    private static String getString(String string) {
        return NbBundle.getMessage(IPSPackager.class, (String)string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ScriptWriter
    implements PackagerDescriptor.ShellSciptWriter {
        @Override
        public void writeShellScript(BufferedWriter bufferedWriter, MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) throws IOException {
            this.writePackagingScriptBodyIPS(bufferedWriter, makeConfiguration);
        }

        private List<String> findUndefinedDirectories(PackagingConfiguration packagingConfiguration) {
            String string;
            List<PackagerFileElement> list = packagingConfiguration.getFiles().getValue();
            HashSet<String> hashSet = new HashSet<String>();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (PackagerFileElement packagerFileElement : list) {
                if (packagerFileElement.getType() != PackagerFileElement.FileType.DIRECTORY) continue;
                string = packagingConfiguration.expandMacros(packagerFileElement.getTo());
                if (string.endsWith("/")) {
                    string = string.substring(0, string.length() - 1);
                }
                hashSet.add(string);
            }
            for (PackagerFileElement packagerFileElement : list) {
                if (packagerFileElement.getType() != PackagerFileElement.FileType.FILE && packagerFileElement.getType() != PackagerFileElement.FileType.SOFTLINK) continue;
                string = IpeUtils.getDirName((String)packagingConfiguration.expandMacros(packagerFileElement.getTo()));
                String string2 = "";
                if (string == null || string.length() <= 0) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
                while (stringTokenizer.hasMoreTokens()) {
                    if (hashSet.contains(string2 = string2 + "/" + stringTokenizer.nextToken())) continue;
                    hashSet.add(string2);
                    arrayList.add(string2);
                }
            }
            return arrayList;
        }

        /*
         * WARNING - void declaration
         */
        private void writePackagingScriptBodyIPS(BufferedWriter bufferedWriter, MakeConfiguration makeConfiguration) throws IOException {
            PackagingConfiguration packagingConfiguration = makeConfiguration.getPackagingConfiguration();
            List<PackagerFileElement> list = packagingConfiguration.getFiles().getValue();
            bufferedWriter.write("# Copy files and create directories and links\n");
            for (PackagerFileElement object32 : list) {
                bufferedWriter.write("cd \"${TOP}\"\n");
                if (object32.getType() == PackagerFileElement.FileType.FILE) {
                    String string = IpeUtils.getDirName((String)makeConfiguration.getPackagingConfiguration().expandMacros(object32.getTo()));
                    if (string != null && string.length() >= 0) {
                        void var7_13;
                        if (string.charAt(0) == '/') {
                            String string2 = string.substring(1);
                        }
                        bufferedWriter.write("makeDirectory ${TMPDIR}/" + (String)var7_13 + "\n");
                    }
                    bufferedWriter.write("copyFileToTmpDir \"" + object32.getFrom() + "\" \"${TMPDIR}/" + object32.getTo() + "\" 0" + object32.getPermission() + "\n");
                } else if (object32.getType() == PackagerFileElement.FileType.DIRECTORY) {
                    bufferedWriter.write("makeDirectory  \"${TMPDIR}/" + object32.getTo() + "\"" + " 0" + object32.getPermission() + "\n");
                } else if (object32.getType() == PackagerFileElement.FileType.SOFTLINK) {
                    void var7_16;
                    String string = IpeUtils.getDirName((String)object32.getTo());
                    String string3 = IpeUtils.getBaseName((String)object32.getTo());
                    if (string != null && string.length() >= 0) {
                        if (string.charAt(0) == '/') {
                            String string4 = string.substring(1);
                        }
                        bufferedWriter.write("makeDirectory \"${TMPDIR}/" + (String)var7_16 + "\"" + "\n");
                    }
                    bufferedWriter.write("cd \"${TMPDIR}/" + (String)var7_16 + "\"" + "\n");
                    bufferedWriter.write("ln -s \"" + object32.getFrom() + "\"" + " " + "\"" + string3 + "\"" + "\n");
                } else if (object32.getType() != PackagerFileElement.FileType.UNKNOWN) assert (false);
                bufferedWriter.write("\n");
            }
            bufferedWriter.write("\n");
            bufferedWriter.write("# Create manifest file\n");
            bufferedWriter.write("cd \"${TOP}\"\n");
            bufferedWriter.write("MANIFEST=${TMPDIR}/manifest\n");
            bufferedWriter.write("rm -f ${MANIFEST}\n");
            bufferedWriter.write("\n");
            bufferedWriter.write("cd \"${TOP}\"\n");
            bufferedWriter.write("echo '#' >> ${MANIFEST}\n");
            bufferedWriter.write("echo '# header' >> ${MANIFEST}\n");
            bufferedWriter.write("echo '#' >> ${MANIFEST}\n");
            List<PackagerInfoElement> list2 = packagingConfiguration.getHeaderSubList(IPSPackager.PACKAGER_NAME);
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                PackagerInfoElement packagerInfoElement = (PackagerInfoElement)iterator.next();
                String string = packagerInfoElement.getValue();
                int n = 0;
                int n2 = string.indexOf("\\n");
                while (n2 >= 0) {
                    if (n == 0) {
                        bufferedWriter.write("echo '" + packagerInfoElement.getName() + ": " + string.substring(n, n2) + "' >> ${MANIFEST}\n");
                    } else {
                        bufferedWriter.write("echo '" + string.substring(n, n2) + "' >> ${MANIFEST}\n");
                    }
                    n = n2 + 2;
                    n2 = string.indexOf("\\n", n);
                }
                if (n >= string.length()) continue;
                if (n == 0) {
                    bufferedWriter.write("echo 'name=\"" + packagerInfoElement.getName() + "\" value=\"" + string.substring(n) + "\"' >> ${MANIFEST}\n");
                    continue;
                }
                bufferedWriter.write("echo '" + string.substring(n) + "' >> ${MANIFEST}\n");
            }
            for (String string : packagingConfiguration.getAdditionalInfo().getValue()) {
                bufferedWriter.write("echo \"" + string + "\" >> ${MANIFEST}\n");
            }
            bufferedWriter.write("\n");
            bufferedWriter.write("echo '#' >> ${MANIFEST}\n");
            bufferedWriter.write("echo '# directories' >> ${MANIFEST}\n");
            bufferedWriter.write("echo '#' >> ${MANIFEST}\n");
            List<String> list3 = this.findUndefinedDirectories(packagingConfiguration);
            for (String string : list3) {
                bufferedWriter.write("echo \"");
                bufferedWriter.write("dir ");
                bufferedWriter.write("mode=0" + MakeOptions.getInstance().getDefExePerm() + " ");
                bufferedWriter.write("owner=" + MakeOptions.getInstance().getDefOwner() + " ");
                bufferedWriter.write("group=" + MakeOptions.getInstance().getDefGroup() + " ");
                bufferedWriter.write("path=" + string);
                bufferedWriter.write("\"");
                bufferedWriter.write(" >> ${MANIFEST}\n");
            }
            for (PackagerFileElement packagerFileElement : list) {
                if (packagerFileElement.getType() != PackagerFileElement.FileType.DIRECTORY) continue;
                String string = packagingConfiguration.expandMacros(packagerFileElement.getTo());
                if (string.endsWith("/")) {
                    string = string.substring(0, string.length() - 1);
                }
                bufferedWriter.write("echo \"");
                bufferedWriter.write("dir ");
                bufferedWriter.write("mode=0" + packagerFileElement.getPermission() + " ");
                bufferedWriter.write("owner=" + packagerFileElement.getOwner() + " ");
                bufferedWriter.write("group=" + packagerFileElement.getGroup() + " ");
                bufferedWriter.write("path=" + string);
                bufferedWriter.write("\"");
                bufferedWriter.write(" >> ${MANIFEST}\n");
            }
            bufferedWriter.write("\n");
            bufferedWriter.write("echo '#' >> ${MANIFEST}\n");
            bufferedWriter.write("echo '# files' >> ${MANIFEST}\n");
            bufferedWriter.write("echo '#' >> ${MANIFEST}\n");
            for (PackagerFileElement packagerFileElement : list) {
                if (packagerFileElement.getType() != PackagerFileElement.FileType.FILE) continue;
                String string = packagingConfiguration.expandMacros(packagerFileElement.getTo());
                bufferedWriter.write("echo \"");
                bufferedWriter.write("file ");
                bufferedWriter.write(string.substring(1) + " ");
                bufferedWriter.write("mode=0" + packagerFileElement.getPermission() + " ");
                bufferedWriter.write("owner=" + packagerFileElement.getOwner() + " ");
                bufferedWriter.write("group=" + packagerFileElement.getGroup() + " ");
                bufferedWriter.write("path=" + string);
                bufferedWriter.write("\"");
                bufferedWriter.write(" >> ${MANIFEST}\n");
            }
            bufferedWriter.write("\n");
            bufferedWriter.write("echo '#' >> ${MANIFEST}\n");
            bufferedWriter.write("echo '# links' >> ${MANIFEST}\n");
            bufferedWriter.write("echo '#' >> ${MANIFEST}\n");
            for (PackagerFileElement packagerFileElement : list) {
                if (packagerFileElement.getType() != PackagerFileElement.FileType.SOFTLINK) continue;
                String string = packagingConfiguration.expandMacros(packagerFileElement.getTo());
                bufferedWriter.write("echo \"");
                bufferedWriter.write("hardlink ");
                bufferedWriter.write("path=" + string + " ");
                bufferedWriter.write("target=" + packagingConfiguration.expandMacros(packagerFileElement.getFrom()));
                bufferedWriter.write("\"");
                bufferedWriter.write(" >> ${MANIFEST}\n");
            }
            bufferedWriter.write("\n");
            bufferedWriter.write("cd \"${TOP}\"\n");
            bufferedWriter.write("checkReturnCode\n");
            bufferedWriter.write("mkdir -p  " + packagingConfiguration.getOutputValue() + "\n");
            bufferedWriter.write("checkReturnCode\n");
            bufferedWriter.write("cd \"${TMPDIR}\"\n");
            bufferedWriter.write("for i in *; do cd \"${TOP}\"; rm -rf " + packagingConfiguration.getOutputValue() + "/$i; done" + "\n");
            bufferedWriter.write("checkReturnCode\n");
            bufferedWriter.write("cd \"${TOP}\"\n");
            bufferedWriter.write("mv ${TMPDIR}/* " + packagingConfiguration.getOutputValue() + "\n");
            bufferedWriter.write("checkReturnCode\n");
            bufferedWriter.write("\n");
            bufferedWriter.write("echo IPS: " + packagingConfiguration.getOutputValue() + "\n");
            bufferedWriter.write("\n");
        }
    }
}

