/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.extras.api.support;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.dlight.api.datafilter.DataFilterManager;
import org.netbeans.modules.dlight.extras.api.ViewportAware;
import org.netbeans.modules.dlight.extras.api.ViewportModel;
import org.netbeans.modules.dlight.extras.api.support.DefaultViewportModel;
import org.netbeans.modules.dlight.extras.api.support.ViewportBar;
import org.netbeans.modules.dlight.spi.indicator.Indicator;
import org.netbeans.modules.dlight.util.Range;
import org.netbeans.modules.dlight.util.TimeFormatter;
import org.netbeans.modules.dlight.util.UIThread;
import org.netbeans.modules.dlight.util.ui.DLightUIPrefs;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IndicatorsContainer
extends JPanel
implements AdjustmentListener,
ChangeListener {
    private static final long EXTENT = 20000000000L;
    private static final TimeFormatter TIME_FORMATTER = new TimeFormatter();
    private final JScrollPane indicatorsScrollPane;
    private final ViewportBar viewportBar;
    private final JScrollBar hScrollBar;
    private final JScrollBar vScrollBar;
    private final DefaultViewportModel viewportModel = new DefaultViewportModel((Range<Long>)new Range((Number)0L, (Number)0L), (Range<Long>)new Range((Number)0L, (Number)20000000000L));
    private final JLabel timeLabel;
    private boolean isAdjusting;

    public IndicatorsContainer(DataFilterManager dataFilterManager, List<Indicator<?>> list) {
        this.viewportModel.setMinViewportSize(1000000000L);
        this.viewportModel.addChangeListener(this);
        this.indicatorsScrollPane = IndicatorsContainer.packIndicatorsIntoScrollPane(list, this.viewportModel);
        this.vScrollBar = this.indicatorsScrollPane.getVerticalScrollBar();
        this.vScrollBar.setVisible(false);
        this.indicatorsScrollPane.setHorizontalScrollBarPolicy(31);
        this.indicatorsScrollPane.setVerticalScrollBarPolicy(21);
        this.indicatorsScrollPane.getViewport().addChangeListener(this);
        this.timeLabel = new JLabel(TIME_FORMATTER.format(0L), 0);
        this.timeLabel.setOpaque(false);
        this.timeLabel.setFont(DLightUIPrefs.getFont((String)"indicator.title.font"));
        this.timeLabel.setForeground(DLightUIPrefs.getColor((String)"indicator.title.font.color"));
        int n = UIManager.getInt("ScrollBar.width");
        int n2 = DLightUIPrefs.getInt((String)"indicator.padding");
        int n3 = n2 + DLightUIPrefs.getInt((String)"indicator.y_axis.width") - n;
        int n4 = n2 + DLightUIPrefs.getInt((String)"indicator.legend.width") - n;
        this.viewportBar = new ViewportBar(this.viewportModel, dataFilterManager, n, n);
        this.hScrollBar = new JScrollBar(0);
        this.hScrollBar.setToolTipText(IndicatorsContainer.getMessage("IndicatorsContainer.hScrollBar.tooltip"));
        this.adjust();
        this.hScrollBar.addAdjustmentListener(this);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1, true).add((Component)this.indicatorsScrollPane, 200, 200, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap(n3, n3).add((GroupLayout.Group)groupLayout.createParallelGroup(1, true).add(1, (Component)this.hScrollBar, -1, -1, Short.MAX_VALUE).add(1, (Component)this.viewportBar, 200 - n3 - n4, 200 - n3 - n4, Short.MAX_VALUE)).add((Component)this.timeLabel, -2, n4, -2))).add((Component)this.vScrollBar));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1, true).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.indicatorsScrollPane, 100, 100, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createParallelGroup(4, false).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.viewportBar, -2, -1, -2).add((Component)this.hScrollBar, -2, -1, -2)).add((Component)this.timeLabel, -1, -1, Short.MAX_VALUE))).add((Component)this.vScrollBar));
    }

    private static JScrollPane packIndicatorsIntoScrollPane(List<Indicator<?>> list, ViewportModel viewportModel) {
        JScrollPane jScrollPane = null;
        if (list != null && !list.isEmpty()) {
            Indicator<?> indicator;
            int n;
            JScrollPane jScrollPane2 = new JScrollPane();
            jScrollPane2.setViewportBorder(BorderFactory.createEmptyBorder());
            JSplitPane jSplitPane = null;
            int n2 = 0;
            for (n = 0; n < list.size(); ++n) {
                indicator = list.get(n).getComponent();
                if (indicator.isMaximumSizeSet()) continue;
                ++n2;
            }
            for (n = 0; n < list.size(); ++n) {
                indicator = list.get(n);
                JComponent jComponent = list.get(n).getComponent();
                if (indicator instanceof ViewportAware) {
                    ((ViewportAware)indicator).setViewportModel(viewportModel);
                }
                if (n + 1 < list.size()) {
                    JSplitPane jSplitPane2 = new JSplitPane(0);
                    jSplitPane2.setBorder(BorderFactory.createEmptyBorder());
                    jSplitPane2.setContinuousLayout(true);
                    jSplitPane2.setDividerSize(5);
                    if (!jComponent.isMaximumSizeSet()) {
                        jSplitPane2.setResizeWeight(1.0 / (double)(n2 - n));
                    }
                    jSplitPane2.setTopComponent(jComponent);
                    jComponent = jSplitPane2;
                }
                if (jSplitPane == null) {
                    jScrollPane2.setViewportView(jComponent);
                } else {
                    jSplitPane.setBottomComponent(jComponent);
                }
                if (!(jComponent instanceof JSplitPane)) continue;
                jSplitPane = (JSplitPane)jComponent;
            }
            jScrollPane = jScrollPane2;
        } else {
            JLabel jLabel = new JLabel(IndicatorsContainer.getMessage("IndicatorsContainer.EmptyContent"));
            jLabel.setAlignmentX(0.5f);
            jScrollPane = new JScrollPane(jLabel);
        }
        jScrollPane.setBorder(new ThreeSidesBorder());
        return jScrollPane;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.setColor(DLightUIPrefs.getColor((String)"indicator.border.color"));
        graphics.fillRect(0, this.viewportBar.getY(), this.indicatorsScrollPane.getWidth(), 2);
    }

    private void adjust() {
        Range range = this.viewportModel.getLimits();
        this.timeLabel.setText(TIME_FORMATTER.format(Math.max(0L, (Long)range.getEnd() - 1000000000L)));
        Range<Long> range2 = this.viewportModel.getViewport();
        range = range.extend(range2);
        this.isAdjusting = true;
        this.hScrollBar.setMinimum((int)TimeUnit.MILLISECONDS.toSeconds((Long)range.getStart()));
        this.hScrollBar.setMaximum((int)TimeUnit.MILLISECONDS.toSeconds((Long)range.getEnd()));
        this.hScrollBar.setValue((int)TimeUnit.MILLISECONDS.toSeconds((Long)range2.getStart()));
        this.hScrollBar.setVisibleAmount((int)TimeUnit.MILLISECONDS.toSeconds((Long)range2.getEnd() - (Long)range2.getStart()));
        this.isAdjusting = false;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.viewportModel) {
            UIThread.invoke((Runnable)new Runnable(){

                public void run() {
                    IndicatorsContainer.this.adjust();
                }
            });
        } else if (changeEvent.getSource() == this.indicatorsScrollPane.getViewport()) {
            UIThread.invoke((Runnable)new Runnable(){

                public void run() {
                    Dimension dimension = IndicatorsContainer.this.indicatorsScrollPane.getViewport().getViewSize();
                    Dimension dimension2 = IndicatorsContainer.this.indicatorsScrollPane.getViewport().getExtentSize();
                    IndicatorsContainer.this.vScrollBar.setVisible(dimension2.height < dimension.height);
                }
            });
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (!this.isAdjusting) {
            Range<Long> range = this.viewportModel.getViewport();
            long l = TimeUnit.SECONDS.toMillis(adjustmentEvent.getValue());
            this.viewportModel.setViewport((Range<Long>)new Range((Number)l, (Number)(l + (Long)range.getEnd() - (Long)range.getStart())));
        }
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(IndicatorsContainer.class, (String)string);
    }

    private static class ThreeSidesBorder
    implements Border {
        private ThreeSidesBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(DLightUIPrefs.getColor((String)"indicator.border.color"));
            graphics.fillRect(0, 0, n3, 2);
            graphics.fillRect(0, 0, 2, n4);
            graphics.fillRect(n3 - 2, 0, 2, n4);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(2, 2, 0, 2);
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

