/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.extras.api.support;

import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.dlight.extras.api.AxisMark;
import org.netbeans.modules.dlight.extras.api.support.AbstractCachingAxisMarksProvider;
import org.netbeans.modules.dlight.util.DLightMath;
import org.netbeans.modules.dlight.util.ValueFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValueMarksProvider
extends AbstractCachingAxisMarksProvider {
    private final ValueFormatter formatter;

    public static ValueMarksProvider newInstance() {
        return new ValueMarksProvider(null);
    }

    public static ValueMarksProvider newInstance(ValueFormatter valueFormatter) {
        return new ValueMarksProvider(valueFormatter);
    }

    private ValueMarksProvider(ValueFormatter valueFormatter) {
        this.formatter = valueFormatter;
    }

    @Override
    protected List<AxisMark> getAxisMarksImpl(long l, long l2, int n, FontMetrics fontMetrics) {
        ArrayList<AxisMark> arrayList = new ArrayList<AxisMark>();
        this.createMarks(l, l2, 0, n, fontMetrics, arrayList);
        arrayList.add(new AxisMark(n, this.formatValue(l2)));
        return arrayList;
    }

    private void createMarks(long l, long l2, int n, int n2, FontMetrics fontMetrics, List<AxisMark> list) {
        if (n2 - n <= fontMetrics.getAscent()) {
            return;
        }
        int n3 = (n + n2) / 2;
        long l3 = (l + l2) / 2L;
        if (fontMetrics.getAscent() <= n3 - n) {
            this.createMarks(l, l3, n, n3, fontMetrics, list);
        }
        list.add(new AxisMark(n3, l2 - l < 2L ? null : this.formatValue(l3), DLightMath.map((int)(n2 - n), (int)(3 * fontMetrics.getAscent() / 2), (int)(2 * fontMetrics.getAscent()), (int)0, (int)255), DLightMath.map((int)(n2 - n), (int)(2 * fontMetrics.getAscent()), (int)(3 * fontMetrics.getAscent()), (int)0, (int)255)));
        if (fontMetrics.getAscent() <= n2 - n3) {
            this.createMarks(l3, l2, n3, n2, fontMetrics, list);
        }
    }

    private String formatValue(long l) {
        if (this.formatter == null) {
            return String.valueOf(l);
        }
        return this.formatter.format(l);
    }
}

